/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.collection.mutable;

import java.io.Serializable;
import java.util.Collection;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.impl.collection.mutable.AbstractSynchronizedMutableCollection;
import org.eclipse.collections.impl.collection.mutable.CollectionAdapter;
import org.eclipse.collections.impl.collection.mutable.SynchronizedCollectionSerializationProxy;
import org.eclipse.collections.impl.collection.mutable.UnmodifiableMutableCollection;

public class SynchronizedMutableCollection<T>
extends AbstractSynchronizedMutableCollection<T>
implements Serializable {
    private static final long serialVersionUID = 2L;

    SynchronizedMutableCollection(MutableCollection<T> newCollection) {
        this(newCollection, null);
    }

    SynchronizedMutableCollection(MutableCollection<T> newCollection, Object newLock) {
        super(newCollection, newLock);
    }

    public static <E, C extends Collection<E>> SynchronizedMutableCollection<E> of(C collection) {
        return new SynchronizedMutableCollection(CollectionAdapter.adapt(collection));
    }

    public static <E, C extends Collection<E>> SynchronizedMutableCollection<E> of(C collection, Object lock) {
        return new SynchronizedMutableCollection(CollectionAdapter.adapt(collection), lock);
    }

    protected Object writeReplace() {
        return new SynchronizedCollectionSerializationProxy(this.getDelegate());
    }

    public MutableCollection<T> with(T element) {
        this.add(element);
        return this;
    }

    public MutableCollection<T> without(T element) {
        this.remove(element);
        return this;
    }

    public MutableCollection<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    public MutableCollection<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCollection<T> asUnmodifiable() {
        Object object = this.lock;
        synchronized (object) {
            return new UnmodifiableMutableCollection(this);
        }
    }

    public MutableCollection<T> asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableCollection<T> toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().toImmutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCollection<T> newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().newEmpty().asSynchronized();
        }
    }
}

