/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts;

import java.util.Objects;

public class EventOccurrence
implements Comparable<EventOccurrence> {
    private final String eventName;
    private final double timestampNs;
    private final Type type;
    private State state;
    private final int ruleIndex;
    private final String eventID;

    public EventOccurrence(String eventName, double timestampNs) {
        this(eventName, timestampNs, Type.RECORDED, State.NOT_SET, 0);
    }

    public EventOccurrence(String eventName, double timestampNs, String eventID) {
        this(eventName, timestampNs, Type.RECORDED, State.NOT_SET, 0, eventID);
    }

    public EventOccurrence(String eventName, double timestampNs, Type type, State state, int ruleIndex) {
        this(eventName, timestampNs, type, state, ruleIndex, null);
    }

    public EventOccurrence(String eventName, double timestampNs, Type type, State state, int ruleIndex, String eventID) {
        this.eventName = eventName;
        this.timestampNs = timestampNs;
        this.type = type;
        this.state = state;
        this.ruleIndex = ruleIndex;
        this.eventID = eventID;
    }

    public String getShortName() {
        int idx = this.eventName.lastIndexOf(46);
        if (idx < 0 || idx + 1 > this.eventName.length()) {
            return "";
        }
        return this.eventName.substring(idx + 1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EventOccurrence) {
            EventOccurrence other = (EventOccurrence)obj;
            if (this.eventName.equals(other.eventName) && this.timestampNs == other.timestampNs && this.type == other.type) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventName, this.timestampNs, this.type});
    }

    @Override
    public int compareTo(EventOccurrence other) {
        int comp = Double.compare(this.timestampNs, other.timestampNs);
        if (comp == 0) {
            return this.type.compareTo(other.type);
        }
        return comp;
    }

    public String eventName() {
        return this.eventName;
    }

    public double timestampNs() {
        return this.timestampNs;
    }

    public Type type() {
        return this.type;
    }

    public State state() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public int ruleIndex() {
        return this.ruleIndex;
    }

    public String eventID() {
        return this.eventID;
    }

    public static enum State {
        NOT_SET,
        FULFILLING,
        ISSUE;

    }

    public static enum Type {
        RECORDED,
        MISSED_MARKER;

    }
}

