/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts.dialogs;

import java.util.List;
import org.eclipse.fordiac.ide.contracts.ContractIssue;
import org.eclipse.fordiac.ide.contracts.ContractSystem;
import org.eclipse.fordiac.ide.contracts.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.diagnostics.Severity;

public class ContractCheckResultDialog
extends MessageDialog {
    private static final int MAX_LIST_HEIGHT = 200;
    private final ContractSystem contractSys;

    public ContractCheckResultDialog(ContractSystem contractSys, boolean networkCheck, Shell shell) {
        super(shell, contractSys.getIssues().isEmpty() ? Messages.ContractCheckSuccess_Title : Messages.ContractCheckIssue_Title, null, ContractCheckResultDialog.createDialogMessage(contractSys, networkCheck), contractSys.getIssues().isEmpty() ? 2 : 1, 0, new String[]{Messages.ContractCheck_OK});
        this.contractSys = contractSys;
    }

    private static String createDialogMessage(ContractSystem contractSys, boolean networkCheck) {
        StringBuilder sb = new StringBuilder();
        if (networkCheck) {
            sb.append(Messages.ContractCheckNetworkSize.formatted(contractSys.getNComponents()));
        } else {
            sb.append(Messages.ContractCheckSelectionSize.formatted(contractSys.getNComponents()));
        }
        sb.append(System.lineSeparator());
        if (contractSys.getIssues().isEmpty()) {
            sb.append(Messages.ContractCheckNoIssues);
        } else if (contractSys.getIssues().size() == 1) {
            sb.append(Messages.ContractCheckOneIssue);
        } else {
            sb.append(Messages.ContractCheckNIssues.formatted(contractSys.getIssues().size()));
        }
        return sb.toString();
    }

    protected Control createCustomArea(Composite parent) {
        List<ContractIssue> issues = this.contractSys.getIssues();
        if (!issues.isEmpty()) {
            parent.setLayout((Layout)new GridLayout(1, false));
            org.eclipse.swt.widgets.List issueList = new org.eclipse.swt.widgets.List(parent, 2560);
            GridData gData = new GridData(4, 4, true, true);
            if (issues.size() * issueList.getItemHeight() > 200) {
                gData.heightHint = 200;
            }
            issueList.setLayoutData((Object)gData);
            for (ContractIssue issue : issues) {
                String prefix = switch (issue.getSeverity()) {
                    case Severity.ERROR -> "[ERROR] ";
                    case Severity.WARNING -> "[WARN] ";
                    case Severity.INFO -> "[INFO] ";
                    case Severity.IGNORE -> "[IGNORE] ";
                    default -> throw new MatchException(null, null);
                };
                issueList.add(prefix + issue.getMessage());
            }
        }
        return parent;
    }
}

