/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.fordiac.ide.debug.LaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.debug.ui.Messages;
import org.eclipse.fordiac.ide.gef.widgets.VariableWidget;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class MainLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    public static final String ID = "org.eclipse.fordiac.ide.debug.ui.mainTab";
    private Text resourceText;
    private Button stopOnFirstLineCheckbox;
    private VariableWidget argumentsWidget;
    private List<Variable<?>> arguments;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(comp);
        this.setControl((Control)comp);
        Composite resourceComponent = this.createResourceComponent(comp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)resourceComponent);
        Composite optionsComponent = this.createOptionsComponent(comp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)optionsComponent);
    }

    protected Composite createResourceComponent(Composite parent) {
        Group group = new Group(parent, 2048);
        GridLayoutFactory.swtDefaults().applyTo((Composite)group);
        group.setText("Target");
        Composite comp = new Composite((Composite)group, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(comp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)comp);
        Label resourceLabel = new Label(comp, 0);
        resourceLabel.setText("Location:");
        GridDataFactory.swtDefaults().applyTo((Control)resourceLabel);
        this.resourceText = new Text(comp, 2048);
        this.resourceText.setEnabled(false);
        this.resourceText.setMessage("Location");
        this.resourceText.addModifyListener(e -> this.scheduleUpdateJob());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.resourceText);
        Button resourceButton = new Button(comp, 2048);
        resourceButton.setText("Browse...");
        resourceButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleResourceButtonSelected()));
        GridDataFactory.swtDefaults().applyTo((Control)resourceButton);
        return group;
    }

    protected Composite createOptionsComponent(Composite parent) {
        Group group = new Group(parent, 2048);
        GridLayoutFactory.swtDefaults().applyTo((Composite)group);
        group.setText("Options");
        Composite comp = new Composite((Composite)group, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo(comp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)comp);
        this.stopOnFirstLineCheckbox = new Button(comp, 32);
        this.stopOnFirstLineCheckbox.setText("Stop on first line");
        this.stopOnFirstLineCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
        GridDataFactory.fillDefaults().applyTo((Control)this.stopOnFirstLineCheckbox);
        return group;
    }

    protected Composite createArgumentsComponent(Composite parent) {
        Group group = new Group(parent, 2048);
        GridLayoutFactory.swtDefaults().applyTo((Composite)group);
        group.setText("Arguments");
        this.argumentsWidget = new VariableWidget();
        this.argumentsWidget.addVariableModificationListener((variable, oldValue, newValue) -> this.updateLaunchConfigurationDialog());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.argumentsWidget.createWidget((Composite)group));
        return group;
    }

    private void handleResourceButtonSelected() {
        Object object;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        IResource initialResource = this.getResource();
        if (initialResource != null) {
            dialog.setInitialSelection((Object)initialResource);
        }
        dialog.setAllowMultiple(false);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IResource resource = (IResource)Adapters.adapt((Object)element, IResource.class);
                try {
                    return MainLaunchConfigurationTab.this.filterTargetResource(resource);
                }
                catch (CoreException e) {
                    return false;
                }
            }
        });
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length > 0 && (object = result[0]) instanceof IResource) {
            IResource resource = (IResource)object;
            String resourceString = resource.getFullPath().toString();
            this.resourceText.setText(resourceString);
            this.handleResourceUpdated();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.removeAttribute("org.eclipse.fordiac.ide.debug.resource");
        configuration.removeAttribute("org.eclipse.fordiac.ide.debug.arguments");
        configuration.removeAttribute("org.eclipse.fordiac.ide.debug.stopOnFirstLine");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String resourceAttribute = configuration.getAttribute("org.eclipse.fordiac.ide.debug.resource", "");
            this.resourceText.setText(resourceAttribute);
            this.stopOnFirstLineCheckbox.setSelection(LaunchConfigurationAttributes.isStopOnFirstLine((ILaunchConfiguration)configuration));
        }
        catch (CoreException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    protected void initializeArgumentsFrom(ILaunchConfiguration configuration) {
        try {
            this.arguments = LaunchConfigurationAttributes.getArguments((ILaunchConfiguration)configuration, this.getDefaultArguments());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.MainLaunchConfigurationTab_ConfigurationError, (String)Messages.MainLaunchConfigurationTab_ErrorInitializingArguments, (IStatus)e.getStatus());
            this.arguments = Collections.emptyList();
        }
        this.argumentsWidget.setInput(this.arguments);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String resourceString = this.resourceText.getText();
        configuration.setAttribute("org.eclipse.fordiac.ide.debug.resource", resourceString);
        if (this.arguments != null) {
            configuration.setAttribute("org.eclipse.fordiac.ide.debug.arguments", this.arguments.stream().collect(Collectors.toMap(Variable::getName, Object::toString)));
        } else {
            configuration.removeAttribute("org.eclipse.fordiac.ide.debug.arguments");
        }
        configuration.setAttribute("org.eclipse.fordiac.ide.debug.stopOnFirstLine", this.stopOnFirstLineCheckbox.getSelection());
    }

    protected void handleResourceUpdated() {
        this.updateLaunchConfigurationDialog();
    }

    protected void updateArguments() {
        try {
            List<Variable<?>> oldArguments = this.arguments;
            this.arguments = this.getDefaultArguments();
            if (oldArguments != null && this.arguments != null) {
                this.arguments.forEach(variable -> oldArguments.stream().filter(arg -> Objects.equals(arg.getName(), variable.getName())).findFirst().ifPresent(arg -> {
                    try {
                        variable.setValue(arg.getValue().toString());
                    }
                    catch (Exception e) {
                        FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)e);
                    }
                }));
            }
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.MainLaunchConfigurationTab_ConfigurationError, (String)Messages.MainLaunchConfigurationTab_ErrorUpdatingArguments, (IStatus)e.getStatus());
            this.arguments = Collections.emptyList();
        }
        this.argumentsWidget.setInput(this.arguments);
        this.updateLaunchConfigurationDialog();
    }

    protected abstract List<Variable<?>> getDefaultArguments() throws CoreException;

    protected boolean filterTargetResource(IResource resource) throws CoreException {
        if (resource instanceof IFile) {
            return false;
        }
        if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                if (this.filterTargetResource(child)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    public String getName() {
        return "Main";
    }

    public String getId() {
        return ID;
    }

    public IResource getResource() {
        String resourceString = this.resourceText.getText();
        if (resourceString != null && !resourceString.isEmpty()) {
            return ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(resourceString));
        }
        return null;
    }
}

