/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.validation;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotation;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;

public class GraphicalValidationAnnotation
extends GraphicalAnnotation {
    private final String message;
    private final Map<String, Object> attributes;

    protected GraphicalValidationAnnotation(String type, Object target, String message, Map<String, Object> attributes) {
        super(type, target);
        this.message = message;
        this.attributes = Map.copyOf(attributes);
    }

    public static Optional<GraphicalValidationAnnotation> forDiagnostic(Diagnostic diagnostic) {
        EObject target = FordiacMarkerHelper.getDiagnosticTarget((Diagnostic)diagnostic);
        Map attributes = FordiacMarkerHelper.getDiagnosticAttributes((Diagnostic)diagnostic);
        if (target != null && !attributes.isEmpty()) {
            return Optional.of(new GraphicalValidationAnnotation(GraphicalValidationAnnotation.getType(diagnostic), target, diagnostic.getMessage(), attributes));
        }
        return Optional.empty();
    }

    @Override
    public String getText() {
        return this.message;
    }

    @Override
    public String getLocation() {
        Object object = this.attributes.get("location");
        if (object instanceof String) {
            String location = (String)object;
            return location;
        }
        return "";
    }

    @Override
    public Object getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getTarget(), this.message);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphicalValidationAnnotation other = (GraphicalValidationAnnotation)obj;
        return Objects.equals(this.getType(), other.getType()) && Objects.equals(this.message, other.message) && Objects.equals(this.getTarget(), other.getTarget());
    }

    protected static String getType(Diagnostic diagnostic) {
        return switch (diagnostic.getSeverity()) {
            case 1 -> "org.eclipse.fordiac.ide.model.ui.annotation.info";
            case 2 -> "org.eclipse.fordiac.ide.model.ui.annotation.warning";
            case 4 -> "org.eclipse.fordiac.ide.model.ui.annotation.error";
            default -> "org.eclipse.fordiac.ide.model.ui.annotation.unknown";
        };
    }
}

