/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextalgorithm.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public final class STAlgorithmEditorUtils {
    public static IEditorPart open(URI uri, boolean activate) {
        IEditorInput editorInput = STAlgorithmEditorUtils.createEditorInput(uri);
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            return IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)editorInput, (String)STAlgorithmEditorUtils.getEditorId(uri), (boolean)activate);
        }
        catch (PartInitException partInitException) {
            FordiacLogHelper.logError((String)("Error while opening editor part for " + String.valueOf(uri)), (Throwable)partInitException);
            return null;
        }
    }

    public static void executeCommand(URI uri, Command command) {
        CommandStack commandStack;
        IEditorPart editor = STAlgorithmEditorUtils.open(uri, false);
        if (editor != null && (commandStack = (CommandStack)editor.getAdapter(CommandStack.class)) != null) {
            commandStack.execute(command);
        }
    }

    public static IEditorInput createEditorInput(URI uri) {
        if (uri.isPlatformResource()) {
            return new FileEditorInput(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))));
        }
        if (uri.isFile()) {
            return new FileEditorInput(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toFileString())));
        }
        return null;
    }

    public static String getEditorId(URI uri) throws PartInitException, OperationCanceledException {
        IEditorDescriptor editorDescriptor = STAlgorithmEditorUtils.getEditorDescriptor(uri);
        if (editorDescriptor != null) {
            return editorDescriptor.getId();
        }
        return null;
    }

    public static IEditorDescriptor getEditorDescriptor(URI uri) throws PartInitException, OperationCanceledException {
        if (uri.isPlatformResource()) {
            return IDE.getEditorDescriptor((IFile)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))), (boolean)true, (boolean)false);
        }
        if (uri.isFile()) {
            return IDE.getEditorDescriptor((IFile)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toFileString())), (boolean)true, (boolean)false);
        }
        return null;
    }

    private STAlgorithmEditorUtils() {
        throw new UnsupportedOperationException();
    }
}

