/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.replaydebugging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.debug.replaydebugging.DataPointChange;
import org.eclipse.fordiac.ide.debug.replaydebugging.EventChange;
import org.eclipse.fordiac.ide.debug.replaydebugging.ReplayNavigator;
import org.eclipse.fordiac.ide.debug.replaydebugging.ReplayNavigatorManager;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchData;
import org.eclipse.fordiac.ide.deployment.devResponse.Data;
import org.eclipse.fordiac.ide.deployment.devResponse.DevResponseFactory;
import org.eclipse.fordiac.ide.deployment.devResponse.FB;
import org.eclipse.fordiac.ide.deployment.devResponse.Port;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementExecutorService;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class ReplayDebuggingResource
implements ReplayNavigator.StateListener {
    private ReplayNavigator replayNavigator;
    private final ReplayNavigator.Identifier replayNavigatorIdentifier;
    private final IDeviceManagementExecutorService deviceManagementExecutorService;
    private final Resource resource;
    private final Set<String> portNames;
    private final UpdateListener updateListener;
    org.eclipse.fordiac.ide.deployment.devResponse.Resource resourceResponse = DevResponseFactory.eINSTANCE.createResource();
    private final Map<String, Data> dataValues = new HashMap<String, Data>();

    public ReplayDebuggingResource(Resource resource, Set<String> portNames, ReplayNavigator.Identifier reaplayNavigatorIdentifier, IDeviceManagementExecutorService deviceManagementExecutorService, UpdateListener updateListener) {
        this.replayNavigatorIdentifier = reaplayNavigatorIdentifier;
        this.deviceManagementExecutorService = deviceManagementExecutorService;
        this.resource = resource;
        this.portNames = portNames;
        this.updateListener = updateListener;
    }

    public org.eclipse.fordiac.ide.deployment.devResponse.Resource getResourceResponse() {
        return this.resourceResponse;
    }

    public EventChange getCurrentEventChange() {
        return this.replayNavigator.getCurrentEventChange();
    }

    public void load() throws DeploymentException {
        this.createReplayNavigator();
    }

    public void unload() {
        this.replayNavigator.removeStateChangeListener(this);
        ReplayNavigatorManager.getDefault().unregisterNavigator(this.replayNavigator);
    }

    private void createReplayNavigator() throws DeploymentException {
        for (String portName : this.portNames) {
            this.deviceManagementExecutorService.addWatch(this.resource, portName);
        }
        DeploymentDebugWatchData watchData = new DeploymentDebugWatchData(this.deviceManagementExecutorService.readWatches());
        ReplayNavigator.DatapointsState initialState = new ReplayNavigator.DatapointsState();
        initialState.putAll(this.getWatchData(watchData, this.resource, this.portNames));
        this.createResourceResponse(initialState);
        List<EventChange> eventChanges = this.iterateOverAllEvents(initialState);
        this.replayNavigator = new ReplayNavigator(this.replayNavigatorIdentifier, initialState, eventChanges);
        this.replayNavigator.addStateChangeListener(this);
        ReplayNavigatorManager.getDefault().registerNavigator(this.replayNavigator);
    }

    private HashMap<String, String> getWatchData(DeploymentDebugWatchData data, Resource resource, Set<String> portNames) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String portName : portNames) {
            Data portData = data.getLastData(resource, portName);
            if (portData == null) continue;
            result.put(portName, portData.getValue());
        }
        return result;
    }

    private void createResourceResponse(ReplayNavigator.DatapointsState initialState) {
        this.resourceResponse.setName(this.resource.getName());
        EList responseFBs = this.resourceResponse.getFbs();
        HashMap<String, FB> existingResponseFBs = new HashMap<String, FB>();
        for (Map.Entry entry : initialState.entrySet()) {
            FB responseFB;
            String datapoint = (String)entry.getKey();
            String value = (String)entry.getValue();
            int lastDot = datapoint.lastIndexOf(46);
            String fbName = datapoint.substring(0, lastDot);
            String portName = datapoint.substring(lastDot + 1);
            if (!existingResponseFBs.containsKey(fbName)) {
                responseFB = DevResponseFactory.eINSTANCE.createFB();
                responseFB.setName(fbName);
                responseFBs.add((Object)responseFB);
                existingResponseFBs.put(fbName, responseFB);
            } else {
                responseFB = (FB)existingResponseFBs.get(fbName);
            }
            EList responseFBPorts = responseFB.getPorts();
            Port responsePort = DevResponseFactory.eINSTANCE.createPort();
            responsePort.setName(portName);
            responseFBPorts.add((Object)responsePort);
            EList responsePortDataValues = responsePort.getDataValues();
            Data dataValuesValue = DevResponseFactory.eINSTANCE.createData();
            dataValuesValue.setValue(value);
            responsePortDataValues.add((Object)dataValuesValue);
            this.dataValues.put(datapoint, dataValuesValue);
        }
    }

    private List<EventChange> iterateOverAllEvents(ReplayNavigator.DatapointsState initialState) throws DeploymentException {
        int eventCounter = 0;
        ArrayList<EventChange> eventChanges = new ArrayList<EventChange>();
        HashMap<String, String> previousState = new HashMap<String, String>(initialState);
        Optional lastEvent = this.deviceManagementExecutorService.replayNextEvent(this.resource);
        while (lastEvent.isPresent()) {
            DeploymentDebugWatchData watchData = new DeploymentDebugWatchData(this.deviceManagementExecutorService.readWatches());
            HashMap<String, String> currentState = this.getWatchData(watchData, this.resource, initialState.keySet().stream().collect(Collectors.toSet()));
            ArrayList<DataPointChange> dataPointChanges = new ArrayList<DataPointChange>();
            for (Map.Entry entry : currentState.entrySet()) {
                String key = (String)entry.getKey();
                String currentStateValue = (String)entry.getValue();
                if (((String)previousState.get(key)).equals(currentStateValue)) continue;
                dataPointChanges.add(new DataPointChange(key, (String)previousState.get(key), currentStateValue));
            }
            eventChanges.add(new EventChange(++eventCounter, (String)lastEvent.get(), dataPointChanges));
            previousState = new HashMap<String, String>(currentState);
            FordiacLogHelper.logInfo((String)("\nEvent triggered " + (String)lastEvent.get() + " with the following data changes:"));
            for (DataPointChange change : dataPointChanges) {
                FordiacLogHelper.logInfo((String)("  " + change.datapoint() + ": " + change.newValue()));
            }
            lastEvent = this.deviceManagementExecutorService.replayNextEvent(this.resource);
        }
        return eventChanges;
    }

    @Override
    public void update(ReplayNavigator replayNavigator, ReplayNavigator.DatapointsState changedValues) {
        for (Map.Entry entry : changedValues.entrySet()) {
            String datapoint = (String)entry.getKey();
            String value = (String)entry.getValue();
            Data dataValue = this.dataValues.get(datapoint);
            dataValue.setValue(value);
        }
        this.updateListener.onUpdate(this);
    }

    @FunctionalInterface
    public static interface UpdateListener {
        public void onUpdate(ReplayDebuggingResource var1);
    }
}

