/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.fallback;

import com.google.common.collect.Iterables;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ide.ui.internal.logical.StorageTypedElement;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;

public class TextFallbackCompareInputData {
    private EObject origin;
    private Resource originResource;
    private IStorage originStorage;
    private ITypedElement originTypedElement;
    private EObject left;
    private Resource leftResource;
    private IStorage leftStorage;
    private ITypedElement leftTypedElement;
    private EObject right;
    private Resource rightResource;
    private IStorage rightStorage;
    private ITypedElement rightTypedElement;

    public TextFallbackCompareInputData(EObject eObject) {
        this.populate(eObject);
        this.populateStorage();
    }

    public boolean hasTypedElement() {
        return this.getOriginTypedElement() != null || this.getLeftTypedElement() != null || this.getRightTypedElement() != null;
    }

    private void populate(EObject eObject) {
        if (eObject instanceof Match) {
            this.populateFromMatch((Match)eObject);
        } else if (eObject instanceof Diff) {
            this.populateFromDiff((Diff)eObject);
        } else if (eObject instanceof MatchResource) {
            MatchResource matchResource = (MatchResource)eObject;
            this.originResource = matchResource.getOrigin();
            this.leftResource = matchResource.getLeft();
            this.rightResource = matchResource.getRight();
        } else if (eObject instanceof Equivalence) {
            Equivalence equivalence = (Equivalence)eObject;
            EList differences = equivalence.getDifferences();
            Diff first = (Diff)Iterables.getFirst((Iterable)differences, null);
            this.populate((EObject)first);
        } else if (eObject instanceof Conflict) {
            Conflict conflict = (Conflict)eObject;
            EList differences = conflict.getDifferences();
            Diff first = (Diff)Iterables.getFirst((Iterable)differences, null);
            this.populate((EObject)first);
        }
    }

    private void populateFromMatch(Match match) {
        this.origin = match.getOrigin();
        this.left = match.getLeft();
        this.right = match.getRight();
        if (this.getOrigin() == null && this.getLeft() == null && this.getRight() == null) {
            EObject eContainer = match.eContainer();
            if (eContainer instanceof Match) {
                this.populateFromMatch((Match)eContainer);
            }
        } else {
            Comparison comparison = match.getComparison();
            if (comparison != null) {
                MatchResource matchResource = this.getMatchResource(comparison, this.getSideResource(this.getLeft()));
                if (matchResource == null && (matchResource = this.getMatchResource(comparison, this.getSideResource(this.getRight()))) == null) {
                    matchResource = this.getMatchResource(comparison, this.getSideResource(this.getOrigin()));
                }
                if (matchResource != null) {
                    this.originResource = matchResource.getOrigin();
                    if (this.getOriginResource() == null) {
                        this.originResource = this.getSideResource(this.getOrigin());
                    }
                    this.leftResource = matchResource.getLeft();
                    if (this.getLeftResource() == null) {
                        this.leftResource = this.getSideResource(this.getLeft());
                    }
                    this.rightResource = matchResource.getRight();
                    if (this.getRightResource() == null) {
                        this.rightResource = this.getSideResource(this.getRight());
                    }
                }
            } else {
                this.originResource = this.getSideResource(this.getOrigin());
                this.leftResource = this.getSideResource(this.getLeft());
                this.rightResource = this.getSideResource(this.getRight());
            }
        }
    }

    private void populateFromDiff(Diff diff) {
        Match match;
        Comparison comparison;
        EObject value;
        ReferenceChange referenceChange;
        for (Diff refinedDiff : diff.getRefinedBy()) {
            if (!this.areAllResourcesNull()) continue;
            this.populateFromDiff(refinedDiff);
        }
        if (this.areAllResourcesNull() && diff instanceof ReferenceChange && (referenceChange = (ReferenceChange)diff).getReference().isContainment() && (value = referenceChange.getValue()) != null && (comparison = ComparisonUtil.getComparison((Diff)diff)) != null && (match = comparison.getMatch(value)) != null) {
            this.populateFromMatch(match);
        }
        if (this.areAllResourcesNull()) {
            this.populateFromMatch(diff.getMatch());
        }
    }

    private boolean areAllResourcesNull() {
        return this.getOriginResource() == null && this.getLeftResource() == null && this.getRightResource() == null;
    }

    private MatchResource getMatchResource(Comparison comparison, Resource resource) {
        if (resource != null) {
            for (MatchResource matchResource : comparison.getMatchedResources()) {
                if (matchResource.getLeft() != resource && matchResource.getRight() != resource && matchResource.getOrigin() != resource) continue;
                return matchResource;
            }
        }
        return null;
    }

    private Resource getSideResource(EObject eObject) {
        if (eObject != null) {
            return eObject.eResource();
        }
        return null;
    }

    private void populateStorage() {
        this.originStorage = this.getStorage(this.getOriginResource());
        this.originTypedElement = this.getTypedElement(this.getOriginStorage());
        this.leftStorage = this.getStorage(this.getLeftResource());
        this.leftTypedElement = this.getTypedElement(this.getLeftStorage());
        this.rightStorage = this.getStorage(this.getRightResource());
        this.rightTypedElement = this.getTypedElement(this.getRightStorage());
    }

    private IStorage getStorage(Resource resource) {
        if (resource != null) {
            return ResourceUtil.getAssociatedStorage((Resource)resource);
        }
        return null;
    }

    private ITypedElement getTypedElement(IStorage storage) {
        if (storage instanceof IResource) {
            IResource resourceStorage = (IResource)storage;
            return new LocalResourceTypedElement(resourceStorage);
        }
        if (storage != null) {
            return new StorageTypedElement(storage, ResourceUtil.getFixedPath((IStorage)storage).toString());
        }
        return null;
    }

    public EObject getOrigin() {
        return this.origin;
    }

    public Resource getOriginResource() {
        return this.originResource;
    }

    public IStorage getOriginStorage() {
        return this.originStorage;
    }

    public ITypedElement getOriginTypedElement() {
        return this.originTypedElement;
    }

    public EObject getLeft() {
        return this.left;
    }

    public Resource getLeftResource() {
        return this.leftResource;
    }

    public IStorage getLeftStorage() {
        return this.leftStorage;
    }

    public ITypedElement getLeftTypedElement() {
        return this.leftTypedElement;
    }

    public EObject getRight() {
        return this.right;
    }

    public Resource getRightResource() {
        return this.rightResource;
    }

    public IStorage getRightStorage() {
        return this.rightStorage;
    }

    public ITypedElement getRightTypedElement() {
        return this.rightTypedElement;
    }
}

