/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.conflict;

import com.google.common.base.Preconditions;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.internal.conflict.AbstractConflictSearch;
import org.eclipse.emf.compare.internal.conflict.AttributeChangeConflictSearch;
import org.eclipse.emf.compare.internal.conflict.ComparisonIndex;
import org.eclipse.emf.compare.internal.conflict.ContainmentRefChangeConflictSearch;
import org.eclipse.emf.compare.internal.conflict.FeatureMapChangeConflictSearch;
import org.eclipse.emf.compare.internal.conflict.NonContainmentRefChangeConflictSearch;
import org.eclipse.emf.compare.internal.conflict.ResourceAttachmentChangeConflictSearch;
import org.eclipse.emf.compare.util.CompareSwitch;
import org.eclipse.emf.ecore.EReference;

public class ConflictSearchFactory
extends CompareSwitch<AbstractConflictSearch<? extends Diff>> {
    private final ComparisonIndex index;
    private final Monitor monitor;

    public ConflictSearchFactory(Comparison comparison, Monitor monitor) {
        Preconditions.checkNotNull((Object)comparison);
        this.monitor = (Monitor)Preconditions.checkNotNull((Object)monitor);
        this.index = ComparisonIndex.index(comparison, monitor);
    }

    @Override
    public AbstractConflictSearch<AttributeChange> caseAttributeChange(AttributeChange diff) {
        switch (diff.getKind()) {
            case ADD: {
                return new AttributeChangeConflictSearch.Add(diff, this.index, this.monitor);
            }
            case CHANGE: {
                return new AttributeChangeConflictSearch.Change(diff, this.index, this.monitor);
            }
            case DELETE: {
                return new AttributeChangeConflictSearch.Delete(diff, this.index, this.monitor);
            }
            case MOVE: {
                return new AttributeChangeConflictSearch.Move(diff, this.index, this.monitor);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public AbstractConflictSearch<? extends Diff> caseFeatureMapChange(FeatureMapChange diff) {
        switch (diff.getKind()) {
            case ADD: {
                return new FeatureMapChangeConflictSearch.Add(diff, this.index, this.monitor);
            }
            case CHANGE: {
                return new FeatureMapChangeConflictSearch.Change(diff, this.index, this.monitor);
            }
            case DELETE: {
                return new FeatureMapChangeConflictSearch.Delete(diff, this.index, this.monitor);
            }
            case MOVE: {
                return new FeatureMapChangeConflictSearch.Move(diff, this.index, this.monitor);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public AbstractConflictSearch<? extends Diff> caseReferenceChange(ReferenceChange diff) {
        EReference ref = diff.getReference();
        Preconditions.checkNotNull((Object)ref);
        if (ref.isContainment()) {
            return this.createContainmentSearch(diff);
        }
        return this.createNonContaimentSearch(diff);
    }

    private AbstractConflictSearch<? extends Diff> createContainmentSearch(ReferenceChange diff) {
        switch (diff.getKind()) {
            case ADD: {
                return new ContainmentRefChangeConflictSearch.Add(diff, this.index, this.monitor);
            }
            case CHANGE: {
                return new ContainmentRefChangeConflictSearch.Change(diff, this.index, this.monitor);
            }
            case DELETE: {
                return new ContainmentRefChangeConflictSearch.Delete(diff, this.index, this.monitor);
            }
            case MOVE: {
                return new ContainmentRefChangeConflictSearch.Move(diff, this.index, this.monitor);
            }
        }
        throw new IllegalArgumentException();
    }

    private AbstractConflictSearch<? extends Diff> createNonContaimentSearch(ReferenceChange diff) {
        switch (diff.getKind()) {
            case ADD: {
                return new NonContainmentRefChangeConflictSearch.Add(diff, this.index, this.monitor);
            }
            case CHANGE: {
                return new NonContainmentRefChangeConflictSearch.Change(diff, this.index, this.monitor);
            }
            case DELETE: {
                return new NonContainmentRefChangeConflictSearch.Delete(diff, this.index, this.monitor);
            }
            case MOVE: {
                return new NonContainmentRefChangeConflictSearch.Move(diff, this.index, this.monitor);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public AbstractConflictSearch<? extends Diff> caseResourceAttachmentChange(ResourceAttachmentChange diff) {
        switch (diff.getKind()) {
            case ADD: {
                return new ResourceAttachmentChangeConflictSearch.Add(diff, this.index, this.monitor);
            }
            case CHANGE: {
                return new ResourceAttachmentChangeConflictSearch.Change(diff, this.index, this.monitor);
            }
            case DELETE: {
                return new ResourceAttachmentChangeConflictSearch.Delete(diff, this.index, this.monitor);
            }
            case MOVE: {
                return new ResourceAttachmentChangeConflictSearch.Move(diff, this.index, this.monitor);
            }
        }
        throw new IllegalArgumentException();
    }
}

