/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.editparts.TargetInterfaceElement;
import org.eclipse.fordiac.ide.application.policies.DeleteTargetInterfaceElementPolicy;
import org.eclipse.fordiac.ide.gef.policies.ModifiedNonResizeableEditPolicy;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerManager;
import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceGetter;
import org.eclipse.fordiac.ide.ui.preferences.UIPreferenceConstants;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IEditorPart;

public class TargetInterfaceElementEditPart
extends AbstractGraphicalEditPart {
    public static final int LABEL_ALPHA = 120;
    private static final String NOT_SIGN = "\u00ac";
    private int maxLabelLength = 40;
    private final Adapter nameChangeAdapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            Object feature = notification.getFeature();
            if (LibraryElementPackage.eINSTANCE.getINamedElement_Name().equals(feature) || LibraryElementPackage.eINSTANCE.getINamedElement_Comment().equals(feature) || !TargetInterfaceElementEditPart.this.getModel().getRefElement().getOutputConnections().stream().map(Connection::isNegated).toList().isEmpty()) {
                TargetInterfaceElementEditPart.this.refreshVisuals();
            }
            super.notifyChanged(notification);
        }
    };

    public void activate() {
        if (!this.isActive()) {
            this.initializeMaxLabelLength();
            super.activate();
            this.getRefElement().eAdapters().add((Object)this.nameChangeAdapter);
            FBNetworkElement parent = this.getRefElement().getFBNetworkElement();
            if (parent != null) {
                parent.eAdapters().add((Object)this.nameChangeAdapter);
                FBNetworkElement grandParent = parent.getOuterFBNetworkElement();
                if (grandParent != null) {
                    grandParent.eAdapters().add((Object)this.nameChangeAdapter);
                }
            }
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            this.getRefElement().eAdapters().remove((Object)this.nameChangeAdapter);
            FBNetworkElement parent = this.getRefElement().getFBNetworkElement();
            if (parent != null && parent.eAdapters().contains((Object)this.nameChangeAdapter)) {
                parent.eAdapters().remove((Object)this.nameChangeAdapter);
                FBNetworkElement grandParent = parent.getOuterFBNetworkElement();
                if (grandParent != null && grandParent.eAdapters().contains((Object)this.nameChangeAdapter)) {
                    grandParent.eAdapters().remove((Object)this.nameChangeAdapter);
                }
            }
            super.deactivate();
        }
    }

    public TargetInterfaceElement getModel() {
        return (TargetInterfaceElement)super.getModel();
    }

    private IInterfaceElement getRefElement() {
        return this.getModel().getRefElement();
    }

    protected IFigure createFigure() {
        Label label = new Label(){

            protected void paintFigure(Graphics graphics) {
                int alpha = graphics.getAlpha();
                graphics.setAlpha(120);
                graphics.fillRoundRectangle(this.getBounds(), 8, 8);
                graphics.setAlpha(alpha);
                super.paintFigure(graphics);
            }
        };
        label.setOpaque(false);
        label.setBackgroundColor(this.getModelColor());
        label.setText(this.getLabelText());
        label.setLabelAlignment(1);
        return label;
    }

    public Label getFigure() {
        return (Label)super.getFigure();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.getFigure().setText(this.getLabelText());
    }

    private String getLabelText() {
        Object labelText = this.labelTruncate(this.getModel().getRefPinFullName());
        if (this.getRefElement().getOutputConnections().stream().anyMatch(con -> !con.isVisible() && con.isNegated())) {
            labelText = NOT_SIGN + (String)labelText;
        }
        return (String)labelText + "\n" + this.labelTruncate(this.getRefElement().getComment());
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ModifiedNonResizeableEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeleteTargetInterfaceElementPolicy());
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            EditPartViewer viewer = this.getViewer();
            EditPart editPart = viewer.getEditPartForModel((Object)this.getRefElement());
            if (editPart == null) {
                TargetInterfaceElementEditPart.openInBreadCrumb(this.getRefElement());
            } else if (viewer instanceof AdvancedScrollingGraphicalViewer) {
                AdvancedScrollingGraphicalViewer asgv = (AdvancedScrollingGraphicalViewer)viewer;
                asgv.selectAndRevealEditPart(editPart);
            } else {
                viewer.select(editPart);
                viewer.reveal(editPart);
            }
        } else {
            super.performRequest(request);
        }
    }

    private Color getModelColor() {
        if (this.getRefElement() instanceof Event) {
            return UIPreferenceConstants.getEventConnectorColor();
        }
        if (this.getRefElement() instanceof AdapterDeclaration) {
            return UIPreferenceConstants.getAdapterConnectorColor();
        }
        return PreferenceGetter.getDataColor((String)this.getRefElement().getType().getName());
    }

    private String labelTruncate(String label) {
        if (label.length() <= this.maxLabelLength) {
            return label;
        }
        return label.substring(0, this.maxLabelLength) + "\u2026";
    }

    public static void openInBreadCrumb(IInterfaceElement target) {
        IEditorPart editor = OpenListenerManager.openEditor((EObject)TargetInterfaceElementEditPart.getTargetEditorElement(target));
        HandlerHelper.selectElement((Object)target, (IEditorPart)editor);
    }

    private static EObject getTargetEditorElement(IInterfaceElement target) {
        SubApp subApp;
        FBNetworkElement fbnEl = target.getFBNetworkElement();
        if (fbnEl == null) {
            return target.eContainer().eContainer();
        }
        FBNetworkElement parent = fbnEl.getOuterFBNetworkElement();
        if (parent == null) {
            return fbnEl.getFbNetwork().getApplication();
        }
        while (parent instanceof SubApp && (subApp = (SubApp)parent).isUnfolded()) {
            if (subApp.getOuterFBNetworkElement() == null) {
                return parent.getFbNetwork().getApplication();
            }
            parent = subApp.getOuterFBNetworkElement();
        }
        return parent;
    }

    public <T> T getAdapter(Class<T> key) {
        if (key == IInterfaceElement.class) {
            return key.cast(this.getModel().getHost());
        }
        return (T)super.getAdapter(key);
    }

    private void initializeMaxLabelLength() {
        AdvancedScrollingGraphicalViewer viewer = (AdvancedScrollingGraphicalViewer)this.getViewer();
        if (viewer != null) {
            this.maxLabelLength = viewer.getPreferencesCache().getMaxInterfaceBarSize();
        }
    }
}

