/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties;

import org.eclipse.fordiac.ide.application.commands.ResizeGroupOrSubappCommand;
import org.eclipse.fordiac.ide.application.editparts.GroupEditPart;
import org.eclipse.fordiac.ide.application.properties.GroupSectionFilter;
import org.eclipse.fordiac.ide.gef.properties.AbstractDoubleColumnSection;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeGroupBoundsCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeGroupSizeLockCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class GroupPropertySection
extends AbstractDoubleColumnSection {
    private static final int MAX_INPUT_LENGTH = 5;
    private static final int TWO_COLUMNS = 2;
    private Text nameText;
    private Text commentText;
    private Text heightText;
    private Text widthText;
    private Button lockCheckbox;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite fbInfoContainer = this.createFBInfoContainer(this.getLeftComposite());
        this.createNameEntry(fbInfoContainer);
        this.createCommentEntry(fbInfoContainer);
        Composite sizeGroup = this.createSizeGroup(this.getRightComposite());
        Composite hwGroup = this.createHeightAndWidthGroup(sizeGroup);
        this.createHeightEntry(hwGroup);
        this.createWidthEntry(hwGroup);
        this.createLockGroupCheckbox(hwGroup);
    }

    protected void performRefresh() {
        if (!this.nameText.isDisposed() && !this.nameText.getParent().isDisposed()) {
            this.nameText.setText(this.getType().getName() != null ? this.getType().getName() : "");
            this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
            this.heightText.setText(Integer.toString(CoordinateConverter.INSTANCE.iec61499ToScreen(this.getType().getHeight())));
            this.widthText.setText(Integer.toString(CoordinateConverter.INSTANCE.iec61499ToScreen(this.getType().getWidth())));
            this.lockCheckbox.setSelection(this.getType().isLocked());
        }
    }

    protected Composite createFBInfoContainer(Composite parent) {
        Composite fbInfoContainer = this.getWidgetFactory().createComposite(parent);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(fbInfoContainer);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)fbInfoContainer);
        return fbInfoContainer;
    }

    private Composite createSizeGroup(Composite parent) {
        Group group = new Group(parent, 32);
        group.setText(FordiacMessages.Size);
        this.getWidgetFactory().adapt((Composite)group);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo((Composite)group);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)group);
        return group;
    }

    private Composite createHeightAndWidthGroup(Composite parent) {
        Composite composite = new Composite(parent, 32);
        this.getWidgetFactory().adapt(composite);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 5).applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        return composite;
    }

    private void createNameEntry(Composite fbInfoGroup) {
        this.getWidgetFactory().createCLabel(fbInfoGroup, FordiacMessages.Name + ":");
        this.nameText = this.createGroupText(fbInfoGroup, true);
        this.nameText.addModifyListener(e -> {
            this.removeContentAdapter();
            this.executeCommand((Command)ChangeNameCommand.forName((INamedElement)this.getType(), (String)this.nameText.getText()));
            this.addContentAdapter();
        });
    }

    private void createHeightEntry(Composite parent) {
        this.getWidgetFactory().createCLabel(parent, FordiacMessages.Height + ":");
        this.heightText = this.createGroupText(parent, true);
        this.heightText.setTextLimit(5);
        this.heightText.addVerifyListener(GroupPropertySection::ensureTextContainsOnlyDigits);
        this.heightText.addModifyListener(e -> {
            if (this.getType() != null) {
                int heightDiff;
                try {
                    heightDiff = Integer.parseInt(this.heightText.getText()) - CoordinateConverter.INSTANCE.iec61499ToScreen(this.getType().getHeight());
                }
                catch (Exception exc) {
                    return;
                }
                this.removeContentAdapter();
                this.executeCommand((Command)new ChangeGroupBoundsCommand(this.getType(), 0, 0, 0, heightDiff));
                this.addContentAdapter();
            }
        });
    }

    private void createWidthEntry(Composite parent) {
        this.getWidgetFactory().createCLabel(parent, FordiacMessages.Width + ":");
        this.widthText = this.createGroupText(parent, true);
        this.widthText.setTextLimit(5);
        this.widthText.addVerifyListener(GroupPropertySection::ensureTextContainsOnlyDigits);
        this.widthText.addModifyListener(e -> {
            if (this.getType() != null) {
                int widthDiff;
                try {
                    widthDiff = Integer.parseInt(this.widthText.getText()) - CoordinateConverter.INSTANCE.iec61499ToScreen(this.getType().getWidth());
                }
                catch (Exception exc) {
                    return;
                }
                this.removeContentAdapter();
                this.executeCommand((Command)new ChangeGroupBoundsCommand(this.getType(), 0, 0, widthDiff, 0));
                this.addContentAdapter();
            }
        });
    }

    private void createLockGroupCheckbox(Composite parent) {
        this.getWidgetFactory().createCLabel(parent, FordiacMessages.Group_LABEL_DisableAutoResize);
        this.lockCheckbox = this.getWidgetFactory().createButton(parent, null, 32);
        this.lockCheckbox.setToolTipText(FordiacMessages.Group_TOOLTIP_DisableAutoResize);
        this.lockCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.getType() != null) {
                this.removeContentAdapter();
                this.executeCommand((Command)new ChangeGroupSizeLockCommand(this.getType(), this.lockCheckbox.getSelection()));
                this.addContentAdapter();
            }
        }));
    }

    private static void ensureTextContainsOnlyDigits(VerifyEvent e) {
        e.doit = e.text.matches("\\d*");
    }

    private void createCommentEntry(Composite parent) {
        CLabel commentLabel = this.getWidgetFactory().createCLabel(parent, FordiacMessages.Comment + ":");
        GridDataFactory.fillDefaults().align(16384, 128).grab(false, false).applyTo((Control)commentLabel);
        this.commentText = this.createGroupText(parent, true, 2562);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.commentText);
        this.commentText.addModifyListener(e -> {
            this.removeContentAdapter();
            if (EditorUtils.getGraphicalViewerFromCurrentActiveEditor() != null && this.getType() != null) {
                GroupEditPart gep;
                EditPart groupforFBNetowrkEditPart = EditorUtils.getGraphicalViewerFromCurrentActiveEditor().getEditPartForModel((Object)this.getType());
                if (groupforFBNetowrkEditPart instanceof GroupEditPart && (gep = (GroupEditPart)groupforFBNetowrkEditPart).getContentEP() != null) {
                    this.executeCommand(new ResizeGroupOrSubappCommand(gep.getContentEP(), (Command)new ChangeCommentCommand((INamedElement)this.getType(), this.commentText.getText())));
                }
            } else {
                this.executeCommand((Command)new ChangeCommentCommand((INamedElement)this.getType(), this.commentText.getText()));
            }
            this.addContentAdapter();
        });
    }

    protected Object getInputType(Object input) {
        return GroupSectionFilter.groupFromSelectedObejct(input);
    }

    protected org.eclipse.fordiac.ide.model.libraryElement.Group getType() {
        Object object = this.type;
        if (object instanceof org.eclipse.fordiac.ide.model.libraryElement.Group) {
            org.eclipse.fordiac.ide.model.libraryElement.Group group = (org.eclipse.fordiac.ide.model.libraryElement.Group)object;
            return group;
        }
        return null;
    }

    protected void setInputCode() {
    }

    protected void setInputInit() {
    }
}

