/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.utilities;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.fordiac.ide.application.utilities.FBTypeTemplateCreationFactory;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SubAppTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.requests.CreationFactory;

public class FbTypeTemplateTransferDropTargetListener
extends TemplateTransferDropTargetListener {
    private final IProject targetProject;

    public FbTypeTemplateTransferDropTargetListener(EditPartViewer viewer, IProject targetProject) {
        super(viewer);
        this.targetProject = targetProject;
    }

    protected void handleDragOver() {
        super.handleDragOver();
        this.getCurrentEvent().feedback = 24;
        this.getCurrentEvent().detail = 0;
        this.getCurrentEvent().operations = 0;
        Object object = TemplateTransfer.getInstance().getTemplate();
        Objects.requireNonNull(object);
        Object object2 = object;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AdapterTypeEntry.class, FBTypeEntry.class, DataTypeEntry.class}, (Object)object2, 0)) {
            case 0: {
                AdapterTypeEntry adpTypeEntry = (AdapterTypeEntry)object2;
                break;
            }
            case 1: {
                FBTypeEntry fbEntry = (FBTypeEntry)object2;
                this.handleFBDragOver(fbEntry);
                break;
            }
            case 2: {
                DataTypeEntry dataTypeEntry = (DataTypeEntry)object2;
                this.handleDataTypeDragOver(dataTypeEntry);
                break;
            }
        }
    }

    protected void handleDrop() {
        DataTypeEntry dataTypeEntry;
        Object object;
        if (!(this.getCurrentEvent().data instanceof FBTypeEntry || this.getCurrentEvent().data instanceof SubAppTypeEntry || (object = this.getCurrentEvent().data) instanceof DataTypeEntry && (dataTypeEntry = (DataTypeEntry)object).getType() instanceof StructuredType)) {
            return;
        }
        super.handleDrop();
        TemplateTransfer.getInstance().setTemplate(null);
    }

    private void handleFBDragOver(FBTypeEntry fbEntry) {
        if (this.isFromSameProject((TypeEntry)fbEntry)) {
            this.getCurrentEvent().detail = 1;
        }
    }

    private void handleDataTypeDragOver(DataTypeEntry dataTypeEntry) {
        if (!this.isFromSameProject((TypeEntry)dataTypeEntry)) {
            return;
        }
        if (dataTypeEntry.getType() instanceof StructuredType && this.getTargetEditPart() != null && this.getTargetEditPart().getModel() instanceof ConfigurableFB) {
            this.getCurrentEvent().detail = 1;
        }
    }

    protected CreationFactory getFactory(Object template) {
        DataTypeEntry dataTypeEntry;
        this.getCurrentEvent().detail = 1;
        if (template instanceof FBType || template instanceof FBTypeEntry || template instanceof SubAppTypeEntry || template instanceof DataTypeEntry && (dataTypeEntry = (DataTypeEntry)template).getType() instanceof StructuredType) {
            return new FBTypeTemplateCreationFactory(template);
        }
        return null;
    }

    private boolean isFromSameProject(TypeEntry entry) {
        IProject srcProject = entry.getFile().getProject();
        return this.targetProject != null && this.targetProject.equals((Object)srcProject);
    }
}

