/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts.model.helpers;

import java.util.List;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;

public class ContractElementBuilder {
    private final StringBuilder contractElement = new StringBuilder();

    public ContractElementBuilder add(String s) {
        this.contractElement.append(s);
        return this;
    }

    public ContractElementBuilder addEventList(List<Event> pins) {
        this.contractElement.append(String.join((CharSequence)", ", pins.stream().map(INamedElement::getName).toList()));
        return this;
    }

    public ContractElementBuilder addEventExpr(List<Event> pins) {
        if (pins.size() == 1) {
            this.contractElement.append(pins.get(0).getName());
            this.contractElement.append(" ");
            return this;
        }
        this.contractElement.append("(");
        this.addEventList(pins);
        this.contractElement.append(") ");
        return this;
    }

    public ContractElementBuilder addAssumption() {
        this.contractElement.append("ASSUMPTION");
        this.contractElement.append(" ");
        return this;
    }

    public ContractElementBuilder addComma() {
        this.contractElement.append(",");
        this.contractElement.append(" ");
        return this;
    }

    public ContractElementBuilder addEClose() {
        this.contractElement.append(")");
        this.contractElement.append(" ");
        return this;
    }

    public ContractElementBuilder addEOpen() {
        this.contractElement.append("(");
        return this;
    }

    public ContractElementBuilder addEvent() {
        this.contractElement.append("event");
        this.contractElement.append(" ");
        return this;
    }

    public ContractElementBuilder addEvent(String event) {
        this.contractElement.append(event);
        return this;
    }

    public ContractElementBuilder addEvents() {
        this.contractElement.append("events");
        this.contractElement.append(" ");
        return this;
    }

    public ContractElementBuilder addEventSpace(String event) {
        this.contractElement.append(event);
        this.contractElement.append(" ");
        return this;
    }

    public ContractElementBuilder addEvery() {
        this.contractElement.append("every");
        this.contractElement.append(" ");
        return this;
    }

    public ContractElementBuilder addGuarantee() {
        this.contractElement.append("GUARANTEE");
        this.contractElement.append(" ");
        return this;
    }

    public ContractElementBuilder addOccur() {
        this.contractElement.append("occur");
        this.contractElement.append(" ");
        return this;
    }

    public ContractElementBuilder addOccurs() {
        this.contractElement.append("occurs");
        this.contractElement.append(" ");
        return this;
    }

    public ContractElementBuilder addHasOccurred() {
        this.contractElement.append("has");
        this.contractElement.append(" ");
        this.contractElement.append("occurred");
        this.contractElement.append(" ");
        return this;
    }

    public ContractElementBuilder addOccursComma() {
        this.contractElement.append("occurs");
        this.contractElement.append(",");
        this.contractElement.append(" ");
        return this;
    }

    public ContractElementBuilder addOffet() {
        this.contractElement.append("offset");
        this.contractElement.append(" ");
        return this;
    }

    public ContractElementBuilder addReaction() {
        this.contractElement.append("Reaction");
        this.contractElement.append(" ");
        return this;
    }

    public ContractElementBuilder addAge() {
        this.contractElement.append("Age");
        this.contractElement.append(" ");
        return this;
    }

    public ContractElementBuilder addSpace() {
        this.contractElement.append(" ");
        return this;
    }

    public ContractElementBuilder addThen() {
        this.contractElement.append("then");
        this.contractElement.append(" ");
        return this;
    }

    public ContractElementBuilder addTime(String time) {
        this.contractElement.append(time);
        return this;
    }

    public ContractElementBuilder addTimeUnit() {
        this.contractElement.append("ms");
        return this;
    }

    public ContractElementBuilder addMs() {
        this.contractElement.append("ms");
        return this;
    }

    public ContractElementBuilder addWhenever() {
        this.contractElement.append("whenever");
        this.contractElement.append(" ");
        return this;
    }

    public ContractElementBuilder addWith() {
        this.contractElement.append("with");
        this.contractElement.append(" ");
        return this;
    }

    public ContractElementBuilder addWithin() {
        this.contractElement.append("within");
        this.contractElement.append(" ");
        return this;
    }

    public String getString() {
        return this.contractElement.toString();
    }
}

