/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.util;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.AnyType;
import org.eclipse.fordiac.ide.model.data.ArrayType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.DateAndTimeType;
import org.eclipse.fordiac.ide.model.data.DateType;
import org.eclipse.fordiac.ide.model.data.LdateType;
import org.eclipse.fordiac.ide.model.data.LdtType;
import org.eclipse.fordiac.ide.model.data.LtimeType;
import org.eclipse.fordiac.ide.model.data.LtodType;
import org.eclipse.fordiac.ide.model.data.StringType;
import org.eclipse.fordiac.ide.model.data.TimeOfDayType;
import org.eclipse.fordiac.ide.model.data.TimeType;
import org.eclipse.fordiac.ide.model.data.WstringType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.GlobalConstants;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.value.StringValueConverter;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public final class ForteNgExportUtil {
    public static final CharSequence VARIABLE_EXPORT_PREFIX = "var_";
    public static final CharSequence EVENT_EXPORT_PREFIX = "evt_";
    public static final CharSequence FB_EXPORT_PREFIX = "fb_";
    private static final Pattern END_COMMENT_PATTERN = Pattern.compile("\\*/");
    private static final String GENERIC_CLASS_NAME_ATTRIBUTE = "GenericClassName";

    public static CharSequence generateName(IInterfaceElement element) {
        EObject _rootContainer;
        EReference _eContainmentFeature;
        boolean _equals;
        StringConcatenation _switchResult = null;
        boolean _matched = false;
        if (element instanceof Event) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)EVENT_EXPORT_PREFIX);
            String _name = ((Event)element).getName();
            _builder.append(_name);
            _switchResult = _builder;
        }
        if (!_matched && (_equals = Objects.equals(_eContainmentFeature = element.eContainmentFeature(), LibraryElementPackage.Literals.BASE_FB_TYPE__INTERNAL_CONST_VARS))) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)VARIABLE_EXPORT_PREFIX);
            _builder.append("const_");
            String _name = element.getName();
            _builder.append(_name);
            _switchResult = _builder;
        }
        if (!_matched && (_rootContainer = EcoreUtil.getRootContainer((EObject)element)) instanceof AdapterType) {
            _matched = true;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)VARIABLE_EXPORT_PREFIX);
            String _name_1 = element.getName();
            _builder_1.append(_name_1);
            _builder_1.append("()");
            _switchResult = _builder_1;
        }
        if (!_matched) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append((Object)VARIABLE_EXPORT_PREFIX);
            String _name_2 = element.getName();
            _builder_2.append(_name_2);
            _switchResult = _builder_2;
        }
        return _switchResult;
    }

    public static CharSequence generateName(FB feature) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)FB_EXPORT_PREFIX);
        String _name = feature.getName();
        _builder.append(_name);
        return _builder;
    }

    public static CharSequence generateName(AdapterFB feature) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)VARIABLE_EXPORT_PREFIX);
        String _name = feature.getName();
        _builder.append(_name);
        return _builder;
    }

    public static CharSequence generateTypeName(INamedElement type) {
        boolean _isGenericType;
        String _generateTypeNamePlain;
        StringConcatenation _builder;
        String _switchResult = null;
        boolean _matched = false;
        if (type instanceof AdapterType) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("FORTE_");
            _generateTypeNamePlain = ForteNgExportUtil.generateTypeNamePlain(type);
            _builder.append(_generateTypeNamePlain);
            _switchResult = _builder;
        }
        if (!_matched && type instanceof ArrayType) {
            _matched = true;
            Functions.Function2 _function = (result, subrange) -> {
                String _xblockexpression = null;
                boolean fixed = subrange.isSetLowerLimit() && subrange.isSetUpperLimit();
                StringConcatenation _builder = new StringConcatenation();
                if (fixed) {
                    _builder.append("CIEC_ARRAY_FIXED");
                } else {
                    _builder.append("CIEC_ARRAY_VARIABLE");
                }
                _builder.append("<");
                _builder.append(result);
                if (fixed) {
                    _builder.append(", ");
                    int _lowerLimit = subrange.getLowerLimit();
                    _builder.append((Object)_lowerLimit);
                    _builder.append(", ");
                    int _upperLimit = subrange.getUpperLimit();
                    _builder.append((Object)_upperLimit);
                }
                _builder.append(">");
                _xblockexpression = _builder.toString();
                return _xblockexpression;
            };
            _switchResult = ((CharSequence)IterableExtensions.fold((Iterable)ListExtensions.reverseView((List)((ArrayType)type).getSubranges()), (Object)ForteNgExportUtil.generateTypeName((INamedElement)((ArrayType)type).getBaseType()), (Functions.Function2)_function)).toString();
        }
        if (!_matched && type instanceof StringType) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("CIEC_");
            _generateTypeNamePlain = ForteNgExportUtil.generateTypeNamePlain(type);
            _builder.append(_generateTypeNamePlain);
            boolean _isSetMaxLength = ((StringType)type).isSetMaxLength();
            if (_isSetMaxLength) {
                _builder.append("_FIXED<");
                int _maxLength = ((StringType)type).getMaxLength();
                _builder.append((Object)_maxLength);
                _builder.append(">");
            }
            _switchResult = _builder;
        }
        if (!_matched && type instanceof DataType) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("CIEC_");
            _generateTypeNamePlain = ForteNgExportUtil.generateTypeNamePlain(type);
            _builder.append(_generateTypeNamePlain);
            boolean _isAnyType = IecTypes.GenericTypes.isAnyType((DataType)((DataType)type));
            if (_isAnyType) {
                _builder.append("_VARIANT");
            }
            _switchResult = _builder;
        }
        if (!_matched && type instanceof FBType && (_isGenericType = ForteNgExportUtil.isGenericType((FBType)type))) {
            _matched = true;
            _switchResult = ForteNgExportUtil.getGenericClassName((FBType)type);
        }
        if (!_matched && type instanceof FBType) {
            _matched = true;
            StringConcatenation _builder2 = new StringConcatenation();
            _builder2.append("FORTE_");
            _generateTypeNamePlain = ForteNgExportUtil.generateTypeNamePlain(type);
            _builder2.append(_generateTypeNamePlain);
            _switchResult = _builder2;
        }
        if (!_matched) {
            _switchResult = ForteNgExportUtil.generateTypeNamePlain(type);
        }
        return _switchResult;
    }

    public static CharSequence generateTypeNameAsParameter(INamedElement type) {
        boolean _isGenericType;
        String _generateTypeNamePlain;
        StringConcatenation _builder;
        String _switchResult = null;
        boolean _matched = false;
        if (type instanceof AdapterType) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("FORTE_");
            _generateTypeNamePlain = ForteNgExportUtil.generateTypeNamePlain(type);
            _builder.append(_generateTypeNamePlain);
            _switchResult = _builder;
        }
        if (!_matched && type instanceof ArrayType) {
            _matched = true;
            Functions.Function2 _function = (result, subrange) -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("CIEC_ARRAY_COMMON<");
                _builder.append(result);
                _builder.append(">");
                return _builder.toString();
            };
            _switchResult = ((CharSequence)IterableExtensions.fold((Iterable)ListExtensions.reverseView((List)((ArrayType)type).getSubranges()), (Object)ForteNgExportUtil.generateTypeName((INamedElement)((ArrayType)type).getBaseType()), (Functions.Function2)_function)).toString();
        }
        if (!_matched && type instanceof StringType) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("CIEC_");
            _generateTypeNamePlain = ForteNgExportUtil.generateTypeNamePlain(type);
            _builder.append(_generateTypeNamePlain);
            boolean _isSetMaxLength = ((StringType)type).isSetMaxLength();
            if (_isSetMaxLength) {
                _builder.append("_FIXED<");
                int _maxLength = ((StringType)type).getMaxLength();
                _builder.append((Object)_maxLength);
                _builder.append(">");
            }
            _switchResult = _builder;
        }
        if (!_matched && type instanceof DataType) {
            _matched = true;
            _builder = new StringConcatenation();
            _builder.append("CIEC_");
            _generateTypeNamePlain = ForteNgExportUtil.generateTypeNamePlain(type);
            _builder.append(_generateTypeNamePlain);
            _switchResult = _builder;
        }
        if (!_matched && type instanceof FBType && (_isGenericType = ForteNgExportUtil.isGenericType((FBType)type))) {
            _matched = true;
            _switchResult = ForteNgExportUtil.getGenericClassName((FBType)type);
        }
        if (!_matched && type instanceof FBType) {
            _matched = true;
            StringConcatenation _builder2 = new StringConcatenation();
            _builder2.append("FORTE_");
            _generateTypeNamePlain = ForteNgExportUtil.generateTypeNamePlain(type);
            _builder2.append(_generateTypeNamePlain);
            _switchResult = _builder2;
        }
        if (!_matched) {
            _switchResult = ForteNgExportUtil.generateTypeNamePlain(type);
        }
        return _switchResult;
    }

    public static CharSequence generateTypeSpec(INamedElement type) {
        CharSequence _switchResult = null;
        boolean _matched = false;
        if (type instanceof ArrayType) {
            _matched = true;
            Functions.Function2 _function = (result, subrange) -> {
                StringConcatenation _builder = new StringConcatenation();
                CharSequence _fORTEStringId = ForteNgExportUtil.getFORTEStringId(ForteNgExportUtil.generateTypeNamePlain(type));
                _builder.append((Object)_fORTEStringId);
                _builder.append(", static_cast<CStringDictionary::TStringId>(");
                int _lowerLimit = subrange.getLowerLimit();
                _builder.append((Object)_lowerLimit);
                _builder.append("), static_cast<CStringDictionary::TStringId>(");
                int _upperLimit = subrange.getUpperLimit();
                _builder.append((Object)_upperLimit);
                _builder.append("), ");
                _builder.append(result);
                return _builder.toString();
            };
            _switchResult = ((CharSequence)IterableExtensions.fold((Iterable)ListExtensions.reverseView((List)((ArrayType)type).getSubranges()), (Object)ForteNgExportUtil.getFORTEStringId(ForteNgExportUtil.generateTypeNamePlain((INamedElement)((ArrayType)type).getBaseType())), (Functions.Function2)_function)).toString();
        }
        if (!_matched) {
            _switchResult = ForteNgExportUtil.getFORTEStringId(ForteNgExportUtil.generateTypeNamePlain(type));
        }
        return _switchResult;
    }

    public static String generateDefiningInclude(EObject object) {
        String _switchResult = null;
        boolean _matched = false;
        if (object instanceof LibraryElement) {
            _matched = true;
            _switchResult = ForteNgExportUtil.generateTypeIncludePath((INamedElement)object);
        }
        if (!_matched) {
            Resource _eResource = object.eResource();
            String _generateDefiningInclude = null;
            if (_eResource != null) {
                _generateDefiningInclude = ForteNgExportUtil.generateDefiningInclude(_eResource);
            }
            _switchResult = _generateDefiningInclude;
        }
        return _switchResult;
    }

    public static String generateDefiningInclude(Resource resource) {
        String _elvis = null;
        Iterable _filter = Iterables.filter((Iterable)resource.getContents(), LibraryElement.class);
        LibraryElement _head = null;
        if (_filter != null) {
            _head = (LibraryElement)IterableExtensions.head((Iterable)_filter);
        }
        String _generateTypeIncludePath = null;
        if (_head != null) {
            _generateTypeIncludePath = ForteNgExportUtil.generateTypeIncludePath((INamedElement)_head);
        }
        if (_generateTypeIncludePath != null) {
            _elvis = _generateTypeIncludePath;
        } else {
            StringConcatenation _builder = new StringConcatenation();
            String _lastSegment = resource.getURI().trimFileExtension().lastSegment();
            _builder.append(_lastSegment);
            _builder.append(".h");
            _elvis = _builder.toString();
        }
        return _elvis;
    }

    public static String generateTypeIncludePath(INamedElement type) {
        boolean _not;
        String _generateTypePath;
        String _switchResult = null;
        String path = _generateTypePath = ForteNgExportUtil.generateTypePath(type);
        boolean _matched = false;
        boolean _isEmpty = path.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(path);
            _builder.append("/");
            String _generateTypeBasename = ForteNgExportUtil.generateTypeBasename(type);
            _builder.append(_generateTypeBasename);
            _builder.append(".h");
            _switchResult = _builder.toString();
        }
        if (!_matched) {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _generateTypeBasename_1 = ForteNgExportUtil.generateTypeBasename(type);
            _builder_1.append(_generateTypeBasename_1);
            _builder_1.append(".h");
            _switchResult = _builder_1.toString();
        }
        return _switchResult;
    }

    public static String generateTypeGenIncludePath(INamedElement type) {
        boolean _not;
        String _generateTypePath;
        String _switchResult = null;
        String path = _generateTypePath = ForteNgExportUtil.generateTypePath(type);
        boolean _matched = false;
        boolean _isEmpty = path.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(path);
            _builder.append("/");
            String _generateTypeBasename = ForteNgExportUtil.generateTypeBasename(type);
            _builder.append(_generateTypeBasename);
            _builder.append("_gen.cpp");
            _switchResult = _builder.toString();
        }
        if (!_matched) {
            StringConcatenation _builder_1 = new StringConcatenation();
            String _generateTypeBasename_1 = ForteNgExportUtil.generateTypeBasename(type);
            _builder_1.append(_generateTypeBasename_1);
            _builder_1.append("_gen.cpp");
            _switchResult = _builder_1.toString();
        }
        return _switchResult;
    }

    public static String generateTypeInclude(INamedElement type) {
        StringConcatenation _builder = new StringConcatenation();
        String _generateTypeBasename = ForteNgExportUtil.generateTypeBasename(type);
        _builder.append(_generateTypeBasename);
        _builder.append(".h");
        return _builder.toString();
    }

    public static String generateTypeSource(INamedElement type) {
        StringConcatenation _builder = new StringConcatenation();
        String _generateTypeBasename = ForteNgExportUtil.generateTypeBasename(type);
        _builder.append(_generateTypeBasename);
        _builder.append(".cpp");
        return _builder.toString();
    }

    public static String generateTypeBasename(INamedElement type) {
        boolean _isGenericType;
        String _genericClassName;
        boolean _isGenericType2;
        boolean _isAnyType;
        boolean _isSetMaxLength;
        Object _switchResult = null;
        boolean _matched = false;
        if (type instanceof TimeType) {
            _matched = true;
            _switchResult = "forte_time";
        }
        if (!_matched && type instanceof LtimeType) {
            _matched = true;
            _switchResult = "forte_ltime";
        }
        if (!_matched && type instanceof DateType) {
            _matched = true;
            _switchResult = "forte_date";
        }
        if (!_matched && type instanceof LdateType) {
            _matched = true;
            _switchResult = "forte_ldate";
        }
        if (!_matched && type instanceof TimeOfDayType) {
            _matched = true;
            _switchResult = "forte_time_of_day";
        }
        if (!_matched && type instanceof LtodType) {
            _matched = true;
            _switchResult = "forte_ltime_of_day";
        }
        if (!_matched && type instanceof DateAndTimeType) {
            _matched = true;
            _switchResult = "forte_date_and_time";
        }
        if (!_matched && type instanceof LdtType) {
            _matched = true;
            _switchResult = "forte_ldate_and_time";
        }
        if (!_matched && type instanceof StringType && (_isSetMaxLength = ((StringType)type).isSetMaxLength())) {
            _matched = true;
            _switchResult = "forte_string_fixed";
        }
        if (!_matched && type instanceof StringType) {
            _matched = true;
            _switchResult = "forte_string";
        }
        if (!_matched && type instanceof WstringType) {
            _matched = true;
            _switchResult = "forte_wstring";
        }
        if (!_matched && type instanceof ArrayType) {
            _matched = true;
            _switchResult = ForteNgExportUtil.generateTypeBasename((INamedElement)((ArrayType)type).getBaseType());
        }
        if (!_matched && type instanceof AdapterType) {
            _matched = true;
            String _name = ((AdapterType)type).getName();
            _switchResult = _name + "_adp";
        }
        if (!_matched && type instanceof AnyDerivedType) {
            _matched = true;
            String _name = ((AnyDerivedType)type).getName();
            _switchResult = _name + "_dtp";
        }
        if (!_matched && type instanceof DataType && (_isAnyType = IecTypes.GenericTypes.isAnyType((DataType)((DataType)type)))) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("forte_");
            String _lowerCase = ForteNgExportUtil.generateTypeNamePlain(type).toLowerCase();
            _builder.append(_lowerCase);
            _builder.append("_variant");
            _switchResult = _builder.toString();
        }
        if (!_matched && type instanceof DataType) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("forte_");
            String _lowerCase = ((DataType)type).getName().toLowerCase();
            _builder.append(_lowerCase);
            _switchResult = _builder.toString();
        }
        if (!_matched && type instanceof FunctionFBType && (_isGenericType2 = ForteNgExportUtil.isGenericType((FBType)type))) {
            _matched = true;
            _genericClassName = ForteNgExportUtil.getGenericClassName((FBType)type);
            _switchResult = _genericClassName + "_fct";
        }
        if (!_matched && type instanceof FunctionFBType) {
            _matched = true;
            String _name = ((FunctionFBType)type).getName();
            _switchResult = _name + "_fct";
        }
        if (!_matched && type instanceof FBType && (_isGenericType = ForteNgExportUtil.isGenericType((FBType)type))) {
            _matched = true;
            _genericClassName = ForteNgExportUtil.getGenericClassName((FBType)type);
            _switchResult = _genericClassName + "_fbt";
        }
        if (!_matched && type instanceof FBType) {
            _matched = true;
            String _name = ((FBType)type).getName();
            _switchResult = _name + "_fbt";
        }
        if (!_matched && type instanceof GlobalConstants) {
            _matched = true;
            String _name = ((GlobalConstants)type).getName();
            _switchResult = _name + "_gcf";
        }
        if (!_matched) {
            _switchResult = type.getName();
        }
        return _switchResult;
    }

    public static String generateTypePath(INamedElement type) {
        String _switchResult = null;
        boolean _matched = false;
        if (type instanceof ArrayType) {
            _matched = true;
            _switchResult = ForteNgExportUtil.generateTypePath((INamedElement)((ArrayType)type).getBaseType());
        }
        if (!_matched && type instanceof AnyType) {
            boolean _tripleEquals;
            TypeEntry _typeEntry = ((AnyType)type).getTypeEntry();
            boolean bl = _tripleEquals = _typeEntry == null;
            if (_tripleEquals) {
                _matched = true;
                _switchResult = "core/datatypes";
            }
        }
        if (!_matched && type instanceof LibraryElement) {
            _matched = true;
            String _elvis = null;
            CompilerInfo _compilerInfo = ((LibraryElement)type).getCompilerInfo();
            String _packageName = null;
            if (_compilerInfo != null) {
                _packageName = _compilerInfo.getPackageName();
            }
            String _replace = null;
            if (_packageName != null) {
                _replace = _packageName.replace("::", "/");
            }
            _elvis = _replace != null ? _replace : "";
            _switchResult = _elvis;
        }
        if (!_matched) {
            _switchResult = type.getName();
        }
        return _switchResult;
    }

    public static String generateMangledPackageName(LibraryElement type) {
        Object _xblockexpression = null;
        CompilerInfo _compilerInfo = type.getCompilerInfo();
        String _packageName = null;
        if (_compilerInfo != null) {
            _packageName = _compilerInfo.getPackageName();
        }
        String _replace = null;
        if (_packageName != null) {
            _replace = _packageName.replace(":", "_");
        }
        String packageName = _replace;
        Object _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)packageName);
        _xifexpression = _isNullOrEmpty ? "" : packageName + "__";
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static String generateTypeNamePlain(INamedElement type) {
        String _switchResult = null;
        boolean _matched = false;
        if (type instanceof TimeType) {
            _matched = true;
            _switchResult = "TIME";
        }
        if (!_matched && type instanceof LtimeType) {
            _matched = true;
            _switchResult = "LTIME";
        }
        if (!_matched && type instanceof DateType) {
            _matched = true;
            _switchResult = "DATE";
        }
        if (!_matched && type instanceof LdateType) {
            _matched = true;
            _switchResult = "LDATE";
        }
        if (!_matched && type instanceof TimeOfDayType) {
            _matched = true;
            _switchResult = "TIME_OF_DAY";
        }
        if (!_matched && type instanceof LtodType) {
            _matched = true;
            _switchResult = "LTIME_OF_DAY";
        }
        if (!_matched && type instanceof DateAndTimeType) {
            _matched = true;
            _switchResult = "DATE_AND_TIME";
        }
        if (!_matched && type instanceof LdtType) {
            _matched = true;
            _switchResult = "LDATE_AND_TIME";
        }
        if (!_matched && type instanceof ArrayType) {
            _matched = true;
            _switchResult = "ARRAY";
        }
        if (!_matched && type instanceof StringType) {
            _matched = true;
            _switchResult = "STRING";
        }
        if (!_matched && type instanceof WstringType) {
            _matched = true;
            _switchResult = "WSTRING";
        }
        if (!_matched && type instanceof LibraryElement) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            String _generateMangledPackageName = ForteNgExportUtil.generateMangledPackageName((LibraryElement)type);
            _builder.append(_generateMangledPackageName);
            String _name = ((LibraryElement)type).getName();
            _builder.append(_name);
            _switchResult = _builder.toString();
        }
        if (!_matched) {
            _switchResult = type.getName();
        }
        return _switchResult;
    }

    public static CharSequence getFORTEStringId(String s) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("g_nStringId");
        _builder.append(s);
        return _builder;
    }

    public static int getInterfaceElementIndex(IInterfaceElement element) {
        int _xifexpression = 0;
        if (element.eContainer() != null && element.eContainingFeature().isMany()) {
            Object _eGet = element.eContainer().eGet(element.eContainingFeature());
            _xifexpression = ((EList)_eGet).indexOf((Object)element);
        } else {
            _xifexpression = 0;
        }
        return _xifexpression;
    }

    public static CharSequence escapeMultilineCommentString(CharSequence string) {
        return END_COMMENT_PATTERN.matcher(string).replaceAll("* /");
    }

    public static boolean isGenericType(FBType type) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equals(_name, GENERIC_CLASS_NAME_ATTRIBUTE);
        };
        return IterableExtensions.exists((Iterable)type.getAttributes(), (Functions.Function1)_function);
    }

    public static String getGenericClassName(FBType type) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equals(_name, GENERIC_CLASS_NAME_ATTRIBUTE);
        };
        return StringValueConverter.INSTANCE.toValue(((Attribute)IterableExtensions.findFirst((Iterable)type.getAttributes(), (Functions.Function1)_function)).getValue());
    }

    private ForteNgExportUtil() {
        throw new UnsupportedOperationException();
    }
}

