/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.handlers;

import org.eclipse.draw2d.zoom.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class ZoomComboContributionItem
extends WorkbenchWindowControlContribution
implements ZoomListener {
    private Combo combo;
    private ZoomManager zoomManager;
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            ZoomManager zm = (ZoomManager)part.getAdapter(ZoomManager.class);
            if (zm != null) {
                ZoomComboContributionItem.this.setZoomManager(zm);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };

    public ZoomComboContributionItem() {
        super("org.eclipse.gef.zoom_widget");
    }

    public ZoomComboContributionItem(String id) {
        super(id);
    }

    protected Control createControl(Composite parent) {
        this.getPartService().addPartListener(this.partListener);
        this.combo = new Combo(parent, 4);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ZoomComboContributionItem.this.handleComboSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ZoomComboContributionItem.this.handleComboSelected();
            }
        });
        this.combo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ZoomComboContributionItem.this.refresh();
            }
        });
        this.setZoomManager(this.getInitialZoomManager());
        return this.combo;
    }

    public void zoomChanged(double zoom) {
        this.refresh();
    }

    public void dispose() {
        super.dispose();
        this.combo = null;
        if (this.zoomManager != null) {
            this.zoomManager.removeZoomListener((ZoomListener)this);
            this.zoomManager = null;
        }
        if (this.partListener != null) {
            this.getPartService().removePartListener(this.partListener);
            this.partListener = null;
        }
    }

    private IPartService getPartService() {
        return this.getWorkbenchWindow().getPartService();
    }

    private ZoomManager getZoomManager() {
        return this.zoomManager;
    }

    private ZoomManager getInitialZoomManager() {
        IEditorPart activeEditor;
        IWorkbenchPage activePage = this.getWorkbenchWindow().getActivePage();
        if (activePage != null && (activeEditor = activePage.getActiveEditor()) != null) {
            return (ZoomManager)activeEditor.getAdapter(ZoomManager.class);
        }
        return null;
    }

    private void setZoomManager(ZoomManager zm) {
        if (this.zoomManager == zm) {
            return;
        }
        if (this.zoomManager != null) {
            this.zoomManager.removeZoomListener((ZoomListener)this);
        }
        this.zoomManager = zm;
        if (this.zoomManager != null) {
            this.repopulateCombo();
            this.zoomManager.addZoomListener((ZoomListener)this);
        }
        this.refresh();
    }

    private void repopulateCombo() {
        this.combo.setItems(this.getZoomManager().getZoomLevelsAsText());
    }

    private void refresh() {
        if (this.combo == null || this.combo.isDisposed() || this.zoomManager == null) {
            return;
        }
        String zoom = this.getZoomManager().getZoomAsText();
        int index = this.combo.indexOf(zoom);
        if (index == -1) {
            this.combo.setText(zoom);
        } else {
            this.combo.select(index);
        }
        this.combo.pack();
        this.combo.getParent().pack();
    }

    private void handleComboSelected() {
        if (this.zoomManager != null) {
            int selected = this.combo.getSelectionIndex();
            if (selected >= 0) {
                this.zoomManager.setZoomAsText(this.combo.getItem(selected));
            } else {
                this.zoomManager.setZoomAsText(this.combo.getText());
            }
        }
        this.refresh();
    }
}

