/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.policies;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.fordiac.ide.gef.handles.ScrollingConnectionEndpointHandle;
import org.eclipse.fordiac.ide.gef.policies.ModifiedMoveHandle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.handles.ConnectionEndpointHandle;
import org.eclipse.gef.requests.SelectionRequest;

public class FeedbackConnectionEndpointEditPolicy
extends ConnectionEndpointEditPolicy
implements PropertyChangeListener {
    private static final int SELECTION_FEEDBACK_SIZE_DELTA = 6;
    private IFigure selectionFeedback;
    private IFigure hoverFeedback;

    public void activate() {
        super.activate();
        this.getConnection().addPropertyChangeListener("points", (PropertyChangeListener)this);
    }

    public void deactivate() {
        this.getConnection().removePropertyChangeListener("points", (PropertyChangeListener)this);
        this.removeHoverFigure();
        this.removeSelectionFigure();
        super.deactivate();
    }

    public void showSelection() {
        super.showSelection();
        this.getConnectionFigure().setLineWidth(5);
        this.removeHoverFigure();
        if (this.selectionFeedback == null) {
            this.addSelectionFeedbackFigure();
        }
    }

    public void hideSelection() {
        this.removeSelectionFigure();
        this.getConnectionFigure().setLineWidth(2);
        super.hideSelection();
    }

    protected PolylineConnection getConnectionFigure() {
        return (PolylineConnection)this.getHost().getFigure();
    }

    protected List<? extends ConnectionEndpointHandle> createSelectionHandles() {
        ArrayList<ConnectionEndpointHandle> list = new ArrayList<ConnectionEndpointHandle>();
        list.add(this.createConnectionEndPointHandle((ConnectionEditPart)this.getHost(), 2));
        list.add(this.createConnectionEndPointHandle((ConnectionEditPart)this.getHost(), 3));
        return list;
    }

    protected ConnectionEndpointHandle createConnectionEndPointHandle(ConnectionEditPart connectionEditPart, int connectionLocator) {
        return new ScrollingConnectionEndpointHandle(connectionEditPart, connectionLocator);
    }

    public void showTargetFeedback(Request request) {
        IFigure connFigure;
        if (request instanceof SelectionRequest && this.hoverFeedback == null && this.handles == null && (connFigure = this.getHostFigure()) instanceof PolylineConnection) {
            PolylineConnection plc = (PolylineConnection)connFigure;
            if (this.hoverFeedback == null) {
                this.hoverFeedback = this.createSelectionFeedbackFigure(plc);
                this.addFeedback(this.hoverFeedback);
            }
        }
    }

    public void eraseTargetFeedback(Request request) {
        this.removeHoverFigure();
    }

    private void addSelectionFeedbackFigure() {
        this.selectionFeedback = this.createSelectionFeedbackFigure(this.getConnectionFigure());
        this.addFeedback(this.selectionFeedback);
    }

    protected IFigure getConnectionLayer() {
        return this.getLayer("Connection Layer");
    }

    private void removeHoverFigure() {
        if (this.hoverFeedback != null) {
            this.removeFeedback(this.hoverFeedback);
            this.hoverFeedback = null;
        }
    }

    private void removeSelectionFigure() {
        if (this.selectionFeedback != null) {
            this.removeFeedback(this.selectionFeedback);
            this.selectionFeedback = null;
        }
    }

    protected IFigure createSelectionFeedbackFigure(PolylineConnection connFigure) {
        Polyline figure = new Polyline();
        figure.setLineWidth(connFigure.getLineWidth() + 6);
        figure.setAlpha(50);
        figure.setForegroundColor(ModifiedMoveHandle.getSelectionColor());
        figure.setPoints(connFigure.getPoints().getCopy());
        return figure;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.getHost().getSelected() != 0 && this.selectionFeedback != null) {
            this.removeSelectionFigure();
            this.addSelectionFeedbackFigure();
        }
    }

    public boolean isSelectionFeedbackShowing() {
        return this.selectionFeedback != null;
    }
}

