/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.preferences;

import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.ui.preferences.FordiacPropertyPreferencePage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;

public class DiagramPreferencePage
extends FordiacPropertyPreferencePage {
    private boolean changesOnLabelSize = false;

    public DiagramPreferencePage() {
        super(1, "org.eclipse.fordiac.ide.gef");
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        BooleanFieldEditor snapToGrid = new BooleanFieldEditor("SnapToGrid", Messages.DiagramPreferences_FieldEditors_SnapToGrid, parent);
        this.addField((FieldEditor)snapToGrid);
        BooleanFieldEditor connectionAutoLayout = new BooleanFieldEditor("ConnectionAutoLayout", Messages.DiagramPreferences_LayoutConnectionsAutomatically, parent);
        this.addField((FieldEditor)connectionAutoLayout);
        IntegerFieldEditor integerFieldEditorValue = new IntegerFieldEditor("MaxDefaultValueLength", Messages.DiagramPreferences_MaximumDefaultValueSize, parent);
        integerFieldEditorValue.setValidRange(120, 100000);
        this.addField((FieldEditor)integerFieldEditorValue);
        BooleanFieldEditor manageConnections = new BooleanFieldEditor("ManageEventConnectionsAutomatically", Messages.DiagramPreferences_ManageConnectionOfEventsAutomatically, parent);
        this.addField((FieldEditor)manageConnections);
        this.createGroupInterfacePins();
        this.createExpandedInterfaceOptionsPins();
    }

    private Group createGroup(String title) {
        Group group = new Group(this.getFieldEditorParent(), 0);
        group.setText(title);
        return group;
    }

    private static void configGroup(Group group) {
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof FieldEditor && DiagramPreferencePage.matchPreferenceName(event)) {
            this.changesOnLabelSize = true;
        }
    }

    private static boolean matchPreferenceName(PropertyChangeEvent event) {
        String sourcePrefName = ((FieldEditor)event.getSource()).getPreferenceName();
        return sourcePrefName.equalsIgnoreCase("MaxDefaultValueLength") || sourcePrefName.equalsIgnoreCase("PinLabelStyle") || sourcePrefName.equalsIgnoreCase("ExpandedInterfaceEventsTop") || sourcePrefName.equalsIgnoreCase("ExpandedInterfaceOldDirectBehaviour");
    }

    public boolean performOk() {
        super.performOk();
        if (this.changesOnLabelSize) {
            this.changesOnLabelSize = false;
            DiagramPreferencePage.showMessageBox();
        }
        return true;
    }

    private static void showMessageBox() {
        MessageBox msgBox = new MessageBox(Display.getDefault().getActiveShell(), 32);
        Display.getDefault().getActiveShell();
        msgBox.setText("4diac IDE");
        msgBox.setMessage(Messages.DiagramPreferences_Restart);
        msgBox.open();
    }

    private void createGroupInterfacePins() {
        this.addField((FieldEditor)new RadioGroupFieldEditor("PinLabelStyle", Messages.DiagramPreferences_PinLabelText, 1, (String[][])new String[][]{{Messages.DiagramPreferences_ShowPinName, "PinLabelStyle_PinName"}, {Messages.DiagramPreferences_ShowPinComment, "PinLabelStyle_PinComment"}, {Messages.DiagramPreferences_ShowConnectedOutputPinName, "PinLabelStyle_SourcePinName"}}, this.getFieldEditorParent(), true));
    }

    private void createExpandedInterfaceOptionsPins() {
        Group group = this.createGroup(Messages.DiagramPreferences_ExpandedInterfaceGroupText);
        BooleanFieldEditor direct = new BooleanFieldEditor("ExpandedInterfaceOldDirectBehaviour", Messages.DiagramPreferences_ExpandedInterfaceStackPins, (Composite)group);
        BooleanFieldEditor events = new BooleanFieldEditor("ExpandedInterfaceEventsTop", Messages.DiagramPreferences_ExpandedInterfaceEvents, (Composite)group);
        BooleanFieldEditor transfer = new BooleanFieldEditor("DeactivateCommentsTransferringDemuxToMux", Messages.DiagramPreferences_DeactivateTransferingComments_DEMUX_to_MUX, (Composite)group);
        this.addField((FieldEditor)direct);
        this.addField((FieldEditor)events);
        this.addField((FieldEditor)transfer);
        DiagramPreferencePage.configGroup(group);
        events.setEnabled(this.getPreferenceStore().getBoolean("ExpandedInterfaceOldDirectBehaviour"), (Composite)group);
        direct.getDescriptionControl((Composite)group).addListener(13, event -> {
            Button button = (Button)event.widget;
            boolean selection = button.getSelection();
            Button eventsButton = (Button)events.getDescriptionControl((Composite)group);
            events.setEnabled(selection, (Composite)group);
            eventsButton.setSelection(selection);
        });
    }

    protected String getPreferencePageID() {
        return "org.eclipse.fordiac.ide.gef.preferences.DiagramPreferences";
    }

    protected String getPropertyPageID() {
        return "org.eclipse.fordiac.ide.gef.properties.DiagramPreferences";
    }
}

