/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.library.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.library.LibraryManager;
import org.eclipse.fordiac.ide.library.model.library.Manifest;
import org.eclipse.fordiac.ide.library.model.library.Required;
import org.eclipse.fordiac.ide.library.model.util.ManifestHelper;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.FileEditorInput;

public class ManifestUpdateFormPage
extends FormPage {
    private IFile manifestFile;
    private final List<Required> libraries = new ArrayList<Required>();
    private TableViewer tableViewer;

    public ManifestUpdateFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.setText("Update dependencies");
        Composite composite = form.getBody();
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.manifestFile = ((FileEditorInput)this.getEditorInput()).getFile();
        this.updateInput();
        this.tableViewer = new TableViewer(composite);
        this.configureTableViewer(this.tableViewer);
        this.tableViewer.setInput(this.libraries);
        GridDataFactory.swtDefaults().grab(true, true).applyTo((Control)composite);
        composite.layout();
        form.getBody().layout();
    }

    private void configureTableViewer(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayout((Layout)this.createTableLayout());
        TableViewerColumn symNameColumn = new TableViewerColumn(viewer, 16384);
        symNameColumn.getColumn().setText("Symbolic Name");
        symNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Required)element).getSymbolicName();
            }
        });
        TableViewerColumn versionColumn = new TableViewerColumn(viewer, 16384);
        versionColumn.getColumn().setText("Version");
        versionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Required)element).getVersion();
            }
        });
        TableViewerColumn buttonColumn = new TableViewerColumn(viewer, 16384);
        buttonColumn.getColumn().setText("Update");
        buttonColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public void update(ViewerCell cell) {
                Button button = new Button((Composite)cell.getControl(), 0);
                TableItem item = (TableItem)cell.getItem();
                button.setText("Update");
                button.addSelectionListener(new SelectionListener(item){
                    private final TableItem tItem;
                    {
                        this.tItem = tableItem;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        Required req = (Required)this.tItem.getData();
                        LibraryManager.INSTANCE.updateLibrary((this).ManifestUpdateFormPage.this.manifestFile.getProject(), req.getSymbolicName(), req.getVersion());
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                TableEditor editor = new TableEditor(item.getParent());
                editor.grabHorizontal = true;
                editor.grabVertical = true;
                editor.setEditor((Control)button, item, cell.getColumnIndex());
                editor.layout();
            }
        });
    }

    private TableLayout createTableLayout() {
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(200));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        return layout;
    }

    private void updateInput() {
        this.libraries.clear();
        Manifest manifest = ManifestHelper.getManifest((IFile)this.manifestFile);
        if (manifest.getDependencies() != null) {
            manifest.getDependencies().getRequired().forEach(this.libraries::add);
        }
    }

    public void setActive(boolean active) {
        if (active) {
            this.updateInput();
            this.tableViewer.refresh();
        }
        super.setActive(active);
    }
}

