/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.delete;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteInterfaceCommand;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerFBNElement;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.gef.commands.Command;

public class DeleteErrorMarkerCommand
extends Command
implements ScopedCommand {
    private final ErrorMarkerInterface errorIe;
    private DeleteInterfaceCommand deleteErrorMarkerIECmd;
    private final DeleteFBNetworkElementCommand deleteErrorMarkerFBN;

    public DeleteErrorMarkerCommand(ErrorMarkerInterface errorIe, FBNetworkElement errorFb) {
        this.errorIe = Objects.requireNonNull(errorIe);
        this.deleteErrorMarkerFBN = DeleteErrorMarkerCommand.createDeleteFBNCommand(errorIe, errorFb);
    }

    public void execute() {
        if (this.errorIe.eContainer() != null) {
            this.deleteErrorMarkerIECmd = new DeleteInterfaceCommand((IInterfaceElement)this.errorIe);
            this.deleteErrorMarkerIECmd.execute();
            if (this.deleteErrorMarkerFBN != null) {
                this.deleteErrorMarkerFBN.execute();
            }
        }
    }

    public void undo() {
        if (this.deleteErrorMarkerIECmd != null) {
            if (this.deleteErrorMarkerFBN != null) {
                this.deleteErrorMarkerFBN.undo();
            }
            this.deleteErrorMarkerIECmd.undo();
        }
    }

    public void redo() {
        if (this.deleteErrorMarkerIECmd != null) {
            this.deleteErrorMarkerIECmd.redo();
            if (this.deleteErrorMarkerFBN != null) {
                this.deleteErrorMarkerFBN.redo();
            }
        }
    }

    private static DeleteFBNetworkElementCommand createDeleteFBNCommand(ErrorMarkerInterface errorIe, FBNetworkElement errorFb) {
        FBNetworkElement fbNetworkElement = errorIe.getFBNetworkElement();
        if (fbNetworkElement != errorFb && fbNetworkElement instanceof ErrorMarkerFBNElement && fbNetworkElement.getInterface().getErrorMarker().size() == 1) {
            return new DeleteFBNetworkElementCommand(fbNetworkElement);
        }
        return null;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        if (this.errorIe.getFBNetworkElement() != null) {
            return Set.of(this.errorIe.getFBNetworkElement());
        }
        return Set.of(this.errorIe);
    }
}

