/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.fordiac.ide.model.data.IntType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyMagnitudeValue;
import org.eclipse.fordiac.ide.model.eval.value.AnySignedValue;
import org.eclipse.fordiac.ide.model.value.NumericValueConverter;

public final class IntValue
implements AnySignedValue {
    public static final IntValue DEFAULT = new IntValue(0);
    private final short value;

    private IntValue(short value) {
        this.value = value;
    }

    public static IntValue toIntValue(short value) {
        return new IntValue(value);
    }

    public static IntValue toIntValue(Number value) {
        return new IntValue(value.shortValue());
    }

    public static IntValue toIntValue(String value) {
        return IntValue.toIntValue((Number)NumericValueConverter.INSTANCE.toValue(value));
    }

    public static IntValue toIntValue(AnyMagnitudeValue value) {
        return IntValue.toIntValue(value.shortValue());
    }

    public IntType getType() {
        return IecTypes.ElementaryTypes.INT;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.longValue());
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.longValue());
    }

    public int hashCode() {
        return Short.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntValue other = (IntValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return Short.toString(this.value);
    }
}

