/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.variable;

import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.eval.EvaluatorInitializerException;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.AbstractVariable;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.value.TypedValue;

public class DirectlyDerivedVariable
extends AbstractVariable<Value> {
    private final Variable<?> delegate;

    protected DirectlyDerivedVariable(String name, DirectlyDerivedType type) {
        super(name, (INamedElement)type);
        try {
            this.delegate = VariableOperations.newVariable(type);
        }
        catch (Exception e) {
            throw new EvaluatorInitializerException((INamedElement)type, (Throwable)e);
        }
    }

    protected DirectlyDerivedVariable(String name, DirectlyDerivedType type, String value) {
        this(name, type);
        this.setValue(value);
    }

    protected DirectlyDerivedVariable(String name, DirectlyDerivedType type, Value value) {
        this(name, type);
        this.setValue(value);
    }

    @Override
    public Value getValue() {
        return this.delegate.getValue();
    }

    @Override
    public void setValue(Value value) throws ClassCastException {
        this.delegate.setValue(value);
    }

    @Override
    public void setValue(String value, TypeLibrary typeLibrary) throws IllegalArgumentException {
        this.delegate.setValue(value, typeLibrary);
    }

    @Override
    public void setValue(TypedValue value) {
        this.delegate.setValue(value);
    }

    @Override
    public boolean validateValue(String value, TypeLibrary typeLibrary) {
        return this.delegate.validateValue(value, typeLibrary);
    }
}

