/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search.st;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.data.AnyType;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.search.st.StructuredTextSearchSupport;
import org.eclipse.fordiac.ide.structuredtextalgorithm.util.STAlgorithmParseUtil;
import org.eclipse.xtext.parser.IParseResult;

public class AttributeSearchSupport
extends StructuredTextSearchSupport {
    private final Attribute attribute;
    private IParseResult parseResult;

    public AttributeSearchSupport(Attribute attribute) {
        this.attribute = attribute;
    }

    @Override
    public Set<String> getImportedNamespaces() {
        Set<String> result = super.getImportedNamespaces();
        if (this.attribute.getAttributeDeclaration() != null) {
            if (!PackageNameHelper.getPackageName((LibraryElement)this.attribute.getAttributeDeclaration()).isEmpty()) {
                result.add(PackageNameHelper.getFullTypeName((LibraryElement)this.attribute.getAttributeDeclaration()));
            }
        } else if (!PackageNameHelper.getPackageName((LibraryElement)this.attribute.getType()).isEmpty()) {
            result.add(PackageNameHelper.getFullTypeName((LibraryElement)this.attribute.getType()));
        }
        return result;
    }

    @Override
    public Stream<EObject> prepare() {
        return Optional.ofNullable(this.prepareValue()).map(IParseResult::getRootASTElement).stream();
    }

    protected IParseResult prepareValue() {
        if (this.parseResult == null && this.attribute.getType() instanceof AnyType && this.attribute.getValue() != null && !this.attribute.getValue().isBlank()) {
            this.parseResult = STAlgorithmParseUtil.parseInitializerExpression((String)this.attribute.getValue(), (INamedElement)this.attribute.getType(), (EObject)this.attribute);
        }
        return this.parseResult;
    }

    public boolean isIncompleteResult() {
        return this.parseResult != null && this.parseResult.hasSyntaxErrors();
    }
}

