/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search.dialog;

import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.search.dialog.AbstractTypeEntryDataHandler;
import org.eclipse.fordiac.ide.model.search.types.BlockTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.search.types.DataTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;

public class StructuredDataTypeDataHandler
extends AbstractTypeEntryDataHandler<DataTypeEntry> {
    public StructuredDataTypeDataHandler(DataTypeEntry typeEntry) {
        super(typeEntry);
    }

    @Override
    public HashMap<INamedElement, DataTypeEntry> createInputSet(DataTypeEntry inputDataTypeEntry) {
        HashMap<INamedElement, DataTypeEntry> inputElementsSet = new HashMap<INamedElement, DataTypeEntry>();
        StructuredDataTypeDataHandler.handleStruct(inputDataTypeEntry, inputElementsSet);
        return inputElementsSet;
    }

    private static void handleVarDecl(VarDeclaration varDecl, HashMap<INamedElement, DataTypeEntry> inputElementsSet, DataTypeEntry inputDataTypeEntry) {
        EObject eObject = varDecl.eContainer();
        if (eObject instanceof StructuredType) {
            StructuredType st = (StructuredType)eObject;
            DataTypeEntry stTypeEntry = (DataTypeEntry)st.getTypeEntry();
            inputElementsSet.put((INamedElement)st, inputDataTypeEntry);
            if (stTypeEntry != null) {
                StructuredDataTypeDataHandler.handleStruct(stTypeEntry, inputElementsSet);
            }
        } else if (varDecl.eContainer() instanceof InterfaceList) {
            inputElementsSet.put((INamedElement)varDecl.eContainer().eContainer(), inputDataTypeEntry);
            EObject eObject2 = varDecl.eContainer().eContainer();
            if (eObject2 instanceof FBType) {
                FBType type = (FBType)eObject2;
                BlockTypeInstanceSearch search = new BlockTypeInstanceSearch(type.getTypeEntry());
                search.performSearch().stream().filter(INamedElement.class::isInstance).map(INamedElement.class::cast).forEach(el -> {
                    DataTypeEntry dataTypeEntry2 = inputElementsSet.put((INamedElement)el, inputDataTypeEntry);
                });
            }
        } else {
            EObject eObject3 = varDecl.eContainer();
            if (eObject3 instanceof FBType) {
                FBType type = (FBType)eObject3;
                inputElementsSet.put((INamedElement)type, inputDataTypeEntry);
            }
        }
    }

    private static void handleStruct(DataTypeEntry stTypeEntry, HashMap<INamedElement, DataTypeEntry> inputElementsSet) {
        DataTypeInstanceSearch dataTypeInstanceSearch = new DataTypeInstanceSearch(stTypeEntry);
        dataTypeInstanceSearch.performSearch().forEach(obj -> {
            if (obj instanceof VarDeclaration) {
                VarDeclaration varDecl = (VarDeclaration)obj;
                StructuredDataTypeDataHandler.handleVarDecl(varDecl, inputElementsSet, stTypeEntry);
            } else if (obj instanceof StructManipulator) {
                StructManipulator structMan = (StructManipulator)obj;
                inputElementsSet.put((INamedElement)structMan, stTypeEntry);
            }
        });
    }

    public List<? extends EObject> performStructSearch() {
        DataTypeInstanceSearch structSearch = new DataTypeInstanceSearch((DataTypeEntry)this.typeEntry);
        return structSearch.performSearch();
    }
}

