/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary.impl;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.model.typelibrary.ITypeEntryCreator;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public enum TypeEntryFactory {
    INSTANCE;

    private static final String PLUGIN_ID = "org.eclipse.fordiac.ide.model";
    private static final String TYPE_CREATION_EXT_POINT_ID = "TypeEntryCreator";
    private final ITypeEntryCreator[] typeCreators = TypeEntryFactory.loadTypeCreators();

    public TypeEntry createTypeEntry(IFile file) {
        TypeEntry entry = null;
        ITypeEntryCreator[] iTypeEntryCreatorArray = this.typeCreators;
        int n = this.typeCreators.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeEntryCreator in = iTypeEntryCreatorArray[n2];
            if (in.canHandle(file)) {
                entry = in.createTypeEntry();
                TypeEntryFactory.configureTypeEntry(entry, file);
            }
            ++n2;
        }
        return entry;
    }

    private static ITypeEntryCreator[] loadTypeCreators() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elems = registry.getConfigurationElementsFor(PLUGIN_ID, TYPE_CREATION_EXT_POINT_ID);
        int numTypeCreators = 0;
        ITypeEntryCreator[] typeCreators = new ITypeEntryCreator[elems.length];
        IConfigurationElement[] iConfigurationElementArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            try {
                Object object = elem.createExecutableExtension("class");
                if (object instanceof ITypeEntryCreator) {
                    typeCreators[numTypeCreators] = (ITypeEntryCreator)object;
                    ++numTypeCreators;
                }
            }
            catch (CoreException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
        return Arrays.copyOf(typeCreators, numTypeCreators);
    }

    private static void configureTypeEntry(TypeEntry entry, IFile file) {
        entry.setType(null);
        entry.setFile(file);
    }
}

