/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.grid.DataVisualizer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class GridItemDataVisualizer
implements DataVisualizer {
    private final Map<GridItem, List<Color>> backgrounds = new HashMap<GridItem, List<Color>>();
    private final Map<GridItem, List<Color>> foregrounds = new HashMap<GridItem, List<Color>>();
    private final Map<GridItem, List<Boolean>> checkables = new HashMap<GridItem, List<Boolean>>();
    private final Map<GridItem, List<Boolean>> checkeds = new HashMap<GridItem, List<Boolean>>();
    private final Map<GridItem, List<Boolean>> grayeds = new HashMap<GridItem, List<Boolean>>();
    private final Map<GridItem, List<Integer>> columnSpans = new HashMap<GridItem, List<Integer>>();
    private final Map<GridItem, List<Integer>> rowSpans = new HashMap<GridItem, List<Integer>>();
    private final Map<GridItem, List<Font>> fonts = new HashMap<GridItem, List<Font>>();
    private final Map<GridItem, List<Image>> images = new HashMap<GridItem, List<Image>>();
    private final Map<GridItem, List<String>> texts = new HashMap<GridItem, List<String>>();
    private final Map<GridItem, List<String>> toolTipTexts = new HashMap<GridItem, List<String>>();
    private Color defaultBackground;
    private Color defaultForeground;
    private Font defaultFont;

    public GridItemDataVisualizer(Color defaultBackground, Color defaultForeground, Font defaultFont) {
        this.defaultBackground = defaultBackground;
        this.defaultForeground = defaultForeground;
        this.defaultFont = defaultFont;
    }

    @Override
    public Color getDefaultBackground() {
        return this.defaultBackground;
    }

    @Override
    public Color getDefaultForeground() {
        return this.defaultForeground;
    }

    @Override
    public Font getDefaultFont() {
        return this.defaultFont;
    }

    @Override
    public Color getBackground(GridItem gridItem, int column) {
        return this.getValueOrDefault(this.backgrounds, gridItem, column, this.defaultBackground);
    }

    protected <T> T getValueOrDefault(Map<GridItem, List<T>> map, GridItem gridItem, int column, T defaultValue) {
        if (column < 0) {
            return defaultValue;
        }
        List<T> list = map.get((Object)gridItem);
        if (list == null || column >= list.size()) {
            return defaultValue;
        }
        T t = list.get(column);
        if (t == null) {
            return defaultValue;
        }
        return t;
    }

    @Override
    public boolean getChecked(GridItem gridItem, int column) {
        return this.getValueOrDefault(this.checkeds, gridItem, column, Boolean.FALSE);
    }

    @Override
    public int getColumnSpan(GridItem gridItem, int column) {
        return this.getValueOrDefault(this.columnSpans, gridItem, column, 0);
    }

    @Override
    public int getRowSpan(GridItem gridItem, int column) {
        return this.getValueOrDefault(this.rowSpans, gridItem, column, 0);
    }

    @Override
    public Font getFont(GridItem gridItem, int column) {
        return this.getValueOrDefault(this.fonts, gridItem, column, this.defaultFont);
    }

    @Override
    public Color getForeground(GridItem gridItem, int column) {
        return this.getValueOrDefault(this.foregrounds, gridItem, column, this.defaultForeground);
    }

    @Override
    public boolean getGrayed(GridItem gridItem, int column) {
        return this.getValueOrDefault(this.grayeds, gridItem, column, Boolean.FALSE);
    }

    @Override
    public Image getImage(GridItem gridItem, int column) {
        return this.getValueOrDefault(this.images, gridItem, column, null);
    }

    @Override
    public String getText(GridItem gridItem, int column) {
        return this.getValueOrDefault(this.texts, gridItem, column, "");
    }

    @Override
    public void setBackground(GridItem gridItem, int column, Color color) {
        this.put(this.backgrounds, gridItem, column, color);
    }

    protected <T> void put(Map<GridItem, List<T>> map, GridItem gridItem, int column, T value) {
        List<T> list = map.get((Object)gridItem);
        if (list == null) {
            list = new ArrayList<T>();
            map.put(gridItem, list);
        }
        while (column > list.size()) {
            list.add(null);
        }
        if (list.size() > column) {
            list.remove(column);
        }
        list.add(column, value);
    }

    @Override
    public void setChecked(GridItem gridItem, int column, boolean checked) {
        this.put(this.checkeds, gridItem, column, checked);
    }

    @Override
    public void setColumnSpan(GridItem gridItem, int column, int span) {
        this.put(this.columnSpans, gridItem, column, span);
    }

    @Override
    public void setRowSpan(GridItem gridItem, int column, int span) {
        this.put(this.rowSpans, gridItem, column, span);
    }

    @Override
    public void setFont(GridItem gridItem, int column, Font font) {
        this.put(this.fonts, gridItem, column, font);
    }

    @Override
    public void setForeground(GridItem gridItem, int column, Color foreground) {
        this.put(this.foregrounds, gridItem, column, foreground);
    }

    @Override
    public void setGrayed(GridItem gridItem, int column, boolean grayed) {
        this.put(this.grayeds, gridItem, column, grayed);
    }

    @Override
    public void setImage(GridItem gridItem, int column, Image image) {
        this.put(this.images, gridItem, column, image);
    }

    @Override
    public void setText(GridItem gridItem, int column, String text) {
        this.put(this.texts, gridItem, column, text);
    }

    @Override
    public boolean getCheckable(GridItem gridItem, int column) {
        return this.getValueOrDefault(this.checkables, gridItem, column, Boolean.TRUE);
    }

    @Override
    public void setCheckable(GridItem gridItem, int column, boolean checked) {
        this.put(this.checkables, gridItem, column, checked);
    }

    @Override
    public String getToolTipText(GridItem gridItem, int column) {
        return this.getValueOrDefault(this.toolTipTexts, gridItem, column, null);
    }

    @Override
    public void setToolTipText(GridItem gridItem, int column, String tooltip) {
        this.put(this.toolTipTexts, gridItem, column, tooltip);
    }

    @Override
    public void clearRow(GridItem gridItem) {
        this.texts.remove((Object)gridItem);
        this.toolTipTexts.remove((Object)gridItem);
        this.foregrounds.remove((Object)gridItem);
        this.backgrounds.remove((Object)gridItem);
        this.images.remove((Object)gridItem);
        this.fonts.remove((Object)gridItem);
        this.rowSpans.remove((Object)gridItem);
        this.columnSpans.remove((Object)gridItem);
        this.grayeds.remove((Object)gridItem);
        this.checkables.remove((Object)gridItem);
        this.checkeds.remove((Object)gridItem);
    }

    protected <T> void removeInvertIndex(Map<GridItem, List<T>> map, int column) {
        for (List<T> list : map.values()) {
            if (column < 0 || column >= list.size()) continue;
            list.remove(column);
        }
    }

    @Override
    public void clearColumn(int column) {
        this.removeInvertIndex(this.texts, column);
        this.removeInvertIndex(this.toolTipTexts, column);
        this.removeInvertIndex(this.foregrounds, column);
        this.removeInvertIndex(this.backgrounds, column);
        this.removeInvertIndex(this.images, column);
        this.removeInvertIndex(this.fonts, column);
        this.removeInvertIndex(this.rowSpans, column);
        this.removeInvertIndex(this.columnSpans, column);
        this.removeInvertIndex(this.grayeds, column);
        this.removeInvertIndex(this.checkables, column);
        this.removeInvertIndex(this.checkeds, column);
    }

    @Override
    public void addColumn(int column) {
        this.addColumnToMap(this.texts, column);
        this.addColumnToMap(this.toolTipTexts, column);
        this.addColumnToMap(this.foregrounds, column);
        this.addColumnToMap(this.backgrounds, column);
        this.addColumnToMap(this.images, column);
        this.addColumnToMap(this.fonts, column);
        this.addColumnToMap(this.rowSpans, column);
        this.addColumnToMap(this.columnSpans, column);
        this.addColumnToMap(this.grayeds, column);
        this.addColumnToMap(this.checkables, column);
        this.addColumnToMap(this.checkeds, column);
    }

    private <T> void addColumnToMap(Map<GridItem, List<T>> map, int column) {
        Collection<List<T>> collections = map.values();
        if (collections != null) {
            for (List<T> list : collections) {
                if (list.isEmpty()) continue;
                int i = list.size();
                while (i < column) {
                    list.add(i, null);
                    ++i;
                }
                list.add(column, null);
            }
        }
    }

    @Override
    public void setDefaultBackground(Color defaultBackground) {
        this.defaultBackground = defaultBackground;
    }

    @Override
    public void setDefaultForeground(Color defaultForeground) {
        this.defaultForeground = defaultForeground;
    }

    @Override
    public void setDefaultFont(Font defaultFont) {
        this.defaultFont = defaultFont;
    }

    @Override
    public void clearAll() {
        this.texts.clear();
        this.toolTipTexts.clear();
        this.foregrounds.clear();
        this.backgrounds.clear();
        this.images.clear();
        this.fonts.clear();
        this.rowSpans.clear();
        this.columnSpans.clear();
        this.grayeds.clear();
        this.checkables.clear();
        this.checkeds.clear();
    }
}

