/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal.win7;

import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.internal.DefaultColumnHeaderRenderer;
import org.eclipse.nebula.widgets.grid.internal.SortArrowRenderer;
import org.eclipse.nebula.widgets.grid.internal.TextUtils;
import org.eclipse.nebula.widgets.grid.internal.win7.Win7ColumnHeaderUtil;
import org.eclipse.nebula.widgets.grid.internal.win7.Win7PaletteProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;

public class Win7GridColumnHeaderRenderer
extends DefaultColumnHeaderRenderer {
    int leftMargin = 6;
    int rightMargin = 6;
    int topMargin = 3;
    int bottomMargin = 3;
    int arrowMargin = 6;
    int imageSpacing = 3;
    private SortArrowRenderer arrowRenderer = new SortArrowRenderer();
    private TextLayout textLayout;
    private Win7PaletteProvider palette;
    private int truncationStyle = 0x1000000;

    public Win7GridColumnHeaderRenderer(Win7PaletteProvider palette) {
        this.palette = palette;
    }

    @Override
    public void setDisplay(Display d) {
        super.setDisplay(d);
        this.arrowRenderer.setDisplay(d);
        this.palette.initializePalette(this.getDisplay(), Win7PaletteProvider.NORMAL_GRID_COLUMN_HEADER);
        this.palette.initializePalette(this.getDisplay(), Win7PaletteProvider.HOVER_GRID_COLUMN_HEADER);
        this.palette.initializePalette(this.getDisplay(), Win7PaletteProvider.MOUSEDOWN_GRID_COLUMN_HEADER);
        this.palette.initializePalette(this.getDisplay(), Win7PaletteProvider.SELECTED_GRID_COLUMN_HEADER);
    }

    @Override
    public void paint(GC gc, Object value) {
        int len;
        GridColumn column = (GridColumn)((Object)value);
        gc.setFont(column.getHeaderFont());
        boolean isHover = this.isHover();
        boolean isMouseDown = this.isMouseDown() && isHover;
        boolean isSelected = this.isSelected();
        Win7ColumnHeaderUtil.drawColumn(gc, this.getBounds(), this.palette, isHover, isSelected, isMouseDown);
        gc.setForeground(this.getDisplay().getSystemColor(21));
        gc.setBackground(this.getDisplay().getSystemColor(22));
        int pushedDrawingOffset = 0;
        int x = this.leftMargin;
        int width = this.getBounds().width - x;
        width = column.getSort() == 0 ? (width -= this.rightMargin) : (width -= this.arrowMargin + this.arrowRenderer.getSize().x + this.arrowMargin);
        int y = this.bottomMargin;
        y = column.getHeaderControl() == null ? this.getBounds().y + this.getBounds().height - this.bottomMargin - gc.getFontMetrics().getHeight() : this.getBounds().y + this.getBounds().height - this.bottomMargin - gc.getFontMetrics().getHeight() - this.computeControlSize((GridColumn)column).y;
        String text = column.getText();
        if (!this.isWordWrap()) {
            text = TextUtils.getShortStr(gc, text, width, this.truncationStyle);
        }
        if (column.getAlignment() == 131072) {
            int len2 = gc.stringExtent((String)text).x;
            if (len2 < width) {
                x += width - len2;
            }
        } else if (column.getAlignment() == 0x1000000 && (len = gc.stringExtent((String)text).x) < width) {
            x += (width - len) / 2;
        }
        if (!this.isWordWrap()) {
            gc.drawString(text, this.getBounds().x + x + pushedDrawingOffset, y + pushedDrawingOffset, true);
        } else {
            this.getTextLayout(gc, column);
            this.textLayout.setWidth(width < 1 ? 1 : width);
            this.textLayout.setText(text);
            y -= this.textLayout.getBounds().height;
            y = gc.getFontMetrics().getHeight();
            if (column.getParent().isAutoHeight()) {
                column.getParent().recalculateHeader();
            }
            this.textLayout.draw(gc, this.getBounds().x + x + pushedDrawingOffset, y + pushedDrawingOffset);
        }
        if (column.getSort() != 0) {
            y = column.getHeaderControl() == null ? this.getBounds().y + (this.getBounds().height - this.arrowRenderer.getBounds().height) / 2 + 1 : this.getBounds().y + (this.getBounds().height - this.computeControlSize((GridColumn)column).y - this.arrowRenderer.getBounds().height) / 2 + 1;
            this.arrowRenderer.setSelected(column.getSort() == 128);
            if (isMouseDown && isHover) {
                this.arrowRenderer.setLocation(this.getBounds().x + this.getBounds().width - this.arrowMargin - this.arrowRenderer.getBounds().width + 1, y);
            } else {
                y = column.getHeaderControl() == null ? this.getBounds().y + (this.getBounds().height - this.arrowRenderer.getBounds().height) / 2 : this.getBounds().y + (this.getBounds().height - this.computeControlSize((GridColumn)column).y - this.arrowRenderer.getBounds().height) / 2;
                this.arrowRenderer.setLocation(this.getBounds().x + this.getBounds().width - this.arrowMargin - this.arrowRenderer.getBounds().width, y);
            }
            this.arrowRenderer.paint(gc, null);
        }
    }

    protected static void drawColumnSelectedTopShadow(GC graphics, Rectangle bounds, Color[] colors) {
        int x = bounds.x;
        int y = bounds.y;
        graphics.setForeground(colors[0]);
        graphics.drawLine(x + 1, y + 1, x + bounds.width - 2, y + 1);
        graphics.setForeground(colors[1]);
        graphics.drawLine(x + 1, y + 2, x + bounds.width - 2, y + 2);
    }

    protected static void drawColumnHeader(GC graphics, Rectangle bounds, Color[] colors) {
        int x = bounds.x;
        int y = bounds.y;
        int topRectHeight = (int)Math.round((double)(bounds.height - 3) * 0.45);
        int bottomRectHeight = bounds.height - 3 - topRectHeight;
        int bottomRectY = y + topRectHeight + 1;
        graphics.setForeground(colors[0]);
        graphics.drawLine(x, y, x + bounds.width - 1, y);
        graphics.setBackground(colors[1]);
        graphics.fillRectangle(x, y + 1, 1, topRectHeight);
        graphics.setBackground(colors[2]);
        graphics.fillRectangle(x + 1, y + 1, bounds.width - 3, topRectHeight);
        graphics.setBackground(colors[3]);
        graphics.fillRectangle(x + bounds.width - 2, y + 1, 1, topRectHeight);
        graphics.setBackground(colors[5]);
        if (colors[4] != null) {
            graphics.setForeground(colors[4]);
            graphics.fillGradientRectangle(x + bounds.width - 1, y + 1, 1, topRectHeight, true);
        } else {
            graphics.fillRectangle(x + bounds.width - 1, y + 1, 1, topRectHeight);
        }
        graphics.setBackground(colors[7]);
        if (colors[6] != null) {
            graphics.setForeground(colors[6]);
            graphics.fillGradientRectangle(x, bottomRectY, 1, bottomRectHeight, true);
        } else {
            graphics.fillRectangle(x, bottomRectY, 1, bottomRectHeight);
        }
        graphics.setBackground(colors[9]);
        if (colors[8] != null) {
            graphics.setForeground(colors[8]);
            graphics.fillGradientRectangle(x + 1, bottomRectY, bounds.width - 3, bottomRectHeight, true);
        } else {
            graphics.fillRectangle(x + 1, bottomRectY, bounds.width - 3, bottomRectHeight);
        }
        graphics.setBackground(colors[11]);
        if (colors[10] != null) {
            graphics.setForeground(colors[10]);
            graphics.fillGradientRectangle(x + bounds.width - 2, bottomRectY, 1, bottomRectHeight, true);
        } else {
            graphics.fillRectangle(x + bounds.width - 2, bottomRectY, 1, bottomRectHeight);
        }
        graphics.setBackground(colors[13]);
        if (colors[12] != null) {
            graphics.setForeground(colors[12]);
            graphics.fillGradientRectangle(x + bounds.width - 1, bottomRectY, 1, bottomRectHeight, true);
        } else {
            graphics.fillRectangle(x + bounds.width - 1, bottomRectY, 1, bottomRectHeight);
        }
        graphics.setForeground(colors[14]);
        graphics.drawLine(x, y + bounds.height - 2, x + bounds.width - 1, y + bounds.height - 2);
        graphics.setForeground(colors[15]);
        graphics.drawLine(x, y + bounds.height - 1, x + bounds.width - 1, y + bounds.height - 1);
    }

    private void getTextLayout(GC gc, GridColumn column) {
        if (this.textLayout == null) {
            this.textLayout = new TextLayout(gc.getDevice());
            this.textLayout.setFont(gc.getFont());
            column.getParent().addListener(12, e -> this.textLayout.dispose());
        }
        this.textLayout.setAlignment(column.getAlignment());
    }

    private Point computeControlSize(GridColumn column) {
        if (column.getHeaderControl() != null) {
            return column.getHeaderControl().computeSize(-1, -1);
        }
        return new Point(0, 0);
    }

    @Override
    public int getTruncationStyle() {
        return this.truncationStyle;
    }

    @Override
    public void setTruncationStyle(int truncationStyle) {
        this.truncationStyle = truncationStyle;
    }
}

