/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.debug;

import org.eclipse.acceleo.debug.IDSLDebugger;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;

public class DebuggerProgressMonitor
extends BasicMonitor {
    private final IDSLDebugger debugger;

    public DebuggerProgressMonitor(IDSLDebugger debugger) {
        this.debugger = debugger;
    }

    public void beginTask(String name, int totalWork) {
        if (name != null && name.length() != 0) {
            this.debugger.consolePrint(">>> " + name + "\n");
        }
    }

    public void setTaskName(String name) {
        if (name != null && name.length() != 0) {
            this.debugger.consolePrint("<>> " + name + "\n");
        }
    }

    public void subTask(String name) {
        if (name != null && name.length() != 0) {
            this.debugger.consolePrint(">>  " + name + "\n");
        }
    }

    public void setBlocked(Diagnostic reason) {
        super.setBlocked(reason);
        this.debugger.consolePrint("#>  " + reason.getMessage() + "\n");
    }

    public void clearBlocked() {
        this.debugger.consolePrint("=>  " + this.getBlockedReason().getMessage() + "\n");
        super.clearBlocked();
    }
}

