/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.outline;

import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.ErrorMetamodel;
import org.eclipse.acceleo.Metamodel;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.outline.AcceleoSymbol;
import org.eclipse.acceleo.aql.validation.AcceleoValidationUtils;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.util.AcceleoSwitch;
import org.eclipse.emf.ecore.EPackage;

public class AcceleoAstOutliner
extends AcceleoSwitch<AcceleoSymbol> {
    private final IAcceleoValidationResult acceleoValidationResult;
    private final IQualifiedNameResolver resolver;

    public AcceleoAstOutliner(IAcceleoValidationResult acceleoValidationResult, IQualifiedNameResolver resolver) {
        this.acceleoValidationResult = acceleoValidationResult;
        this.resolver = resolver;
    }

    private AcceleoSymbol createSymbol(AcceleoASTNode semanticElement, String symbolName, String symbolDetails) {
        return new AcceleoSymbol(semanticElement, this.acceleoValidationResult, symbolName, symbolDetails);
    }

    @Override
    public AcceleoSymbol caseMetamodel(Metamodel metamodel) {
        String details = metamodel.getReferencedPackage();
        EPackage ePkg = this.resolver.getEPackage(metamodel.getReferencedPackage());
        String name = ePkg != null ? ePkg.getName() : details;
        return this.createSymbol(metamodel, name, details);
    }

    @Override
    public AcceleoSymbol caseErrorMetamodel(ErrorMetamodel errorMetamodel) {
        return this.createSymbol(errorMetamodel, "", "");
    }

    @Override
    public AcceleoSymbol caseQuery(Query query) {
        AcceleoSymbol res;
        Object symbolName = query.getName();
        if (!query.getParameters().isEmpty()) {
            symbolName = (String)symbolName + "(";
            symbolName = (String)symbolName + AcceleoValidationUtils.getVariablesListRepresentation(query.getParameters(), this.acceleoValidationResult);
            symbolName = (String)symbolName + ")";
        }
        String symbolDetails = AcceleoValidationUtils.getPossibleTypesRepresentation(query, this.acceleoValidationResult);
        if (symbolName != null) {
            AcceleoSymbol symbolForQuery = this.createSymbol(query, (String)symbolName, symbolDetails);
            for (Variable parameter : query.getParameters()) {
                AcceleoSymbol symbolForParameter = (AcceleoSymbol)this.doSwitch(parameter);
                symbolForQuery.getChildren().add(symbolForParameter);
            }
            res = symbolForQuery;
        } else {
            res = null;
        }
        return res;
    }

    @Override
    public AcceleoSymbol caseVariable(Variable variable) {
        String symbolName = variable.getName();
        String symbolDetails = AcceleoValidationUtils.getPossibleTypesRepresentation(variable, this.acceleoValidationResult);
        AcceleoSymbol symbolForVariable = this.createSymbol(variable, symbolName, symbolDetails);
        return symbolForVariable;
    }

    @Override
    public AcceleoSymbol caseTemplate(Template template) {
        AcceleoSymbol res;
        Object symbolName = template.getName();
        if (!template.getParameters().isEmpty()) {
            symbolName = (String)symbolName + "(";
            symbolName = (String)symbolName + AcceleoValidationUtils.getVariablesListRepresentation(template.getParameters(), this.acceleoValidationResult);
            symbolName = (String)symbolName + ")";
        }
        String symbolDetails = "String";
        if (symbolName != null) {
            AcceleoSymbol symbolForTemplate = this.createSymbol(template, (String)symbolName, symbolDetails);
            for (Variable parameter : template.getParameters()) {
                AcceleoSymbol symbolForParameter = (AcceleoSymbol)this.doSwitch(parameter);
                symbolForTemplate.getChildren().add(symbolForParameter);
            }
            res = symbolForTemplate;
        } else {
            res = null;
        }
        return res;
    }
}

