/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.query.runtime.IService;

public final class ServiceRegistrationResult {
    private final List<IService<?>> registered = new ArrayList();
    private final Map<IService<?>, List<IService<?>>> duplicated = new LinkedHashMap();
    private final Map<IService<?>, List<IService<?>>> masked = new LinkedHashMap();
    private final Map<IService<?>, List<IService<?>>> isMaskedBy = new LinkedHashMap();

    public List<IService<?>> getRegistered() {
        return this.registered;
    }

    public Map<IService<?>, List<IService<?>>> getDuplicated() {
        return this.duplicated;
    }

    public Map<IService<?>, List<IService<?>>> getMasked() {
        return this.masked;
    }

    public Map<IService<?>, List<IService<?>>> getIsMaskedBy() {
        return this.isMaskedBy;
    }

    public void merge(ServiceRegistrationResult otherResult) {
        this.registered.addAll(otherResult.registered);
        this.duplicated.putAll(otherResult.duplicated);
        this.masked.putAll(otherResult.masked);
        this.isMaskedBy.putAll(otherResult.isMaskedBy);
    }

    public void addDuplicated(IService<?> newService, IService<?> duplicatedService) {
        List<IService<?>> services = this.duplicated.get(newService);
        if (services == null) {
            services = new ArrayList();
            this.duplicated.put(newService, services);
        }
        services.add(duplicatedService);
    }

    public void addMasked(IService<?> newService, IService<?> maskedService) {
        List<IService<?>> services = this.masked.get(newService);
        if (services == null) {
            services = new ArrayList();
            this.masked.put(newService, services);
        }
        services.add(maskedService);
    }

    public void addIsMaskedBy(IService<?> newService, IService<?> isMaskedByService) {
        List<IService<?>> services = this.isMaskedBy.get(newService);
        if (services == null) {
            services = new ArrayList();
            this.isMaskedBy.put(newService, services);
        }
        services.add(isMaskedByService);
    }
}

