/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl.completion;

import java.util.StringJoiner;
import org.eclipse.acceleo.query.parser.AstBuilder;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EOperationServiceCompletionProposal
implements ICompletionProposal {
    private final EOperation eOperation;

    public EOperationServiceCompletionProposal(EOperation eOperation) {
        this.eOperation = eOperation;
    }

    @Override
    public String getProposal() {
        return AstBuilder.protectWithUnderscore(this.eOperation.getName()) + "()";
    }

    @Override
    public int getCursorOffset() {
        int length = this.getProposal().length();
        if (this.eOperation.getEParameters().size() > 0) {
            return length;
        }
        return length - 1;
    }

    public EOperation getObject() {
        return this.eOperation;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.eOperation.getName());
        buffer.append('(');
        EList eParameters = this.eOperation.getEParameters();
        int i = 0;
        while (i < eParameters.size()) {
            EParameter eParameter = (EParameter)eParameters.get(i);
            buffer.append(eParameter.getName());
            buffer.append(": ");
            EClassifier eType = eParameter.getEType();
            if (eType != null) {
                buffer.append(eType.getEPackage().getName());
                buffer.append("::");
                buffer.append(eType.getName());
            }
            if (i + 1 < eParameters.size()) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append("): ");
        EClassifier eType = this.eOperation.getEType();
        if (eType != null) {
            buffer.append(eType.getEPackage().getName());
            buffer.append("::");
            buffer.append(eType.getName());
        }
        return buffer.toString();
    }

    @Override
    public String getDescription() {
        StringBuffer result = new StringBuffer();
        result.append(this.eOperation.getName());
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (EParameter parameter : this.eOperation.getEParameters()) {
            if (parameter.getEType() == null) {
                joiner.add(parameter.getName());
                continue;
            }
            joiner.add(parameter.getName() + ": " + this.getEClassifierString(parameter.getEType()));
        }
        result.append(joiner.toString());
        if (this.eOperation.getEType() != null) {
            result.append(" = ");
            if (this.eOperation.isMany()) {
                result.append("Sequence(" + this.getEClassifierString(this.eOperation.getEType()) + ")");
            } else {
                result.append(this.getEClassifierString(this.eOperation.getEType()));
            }
        }
        result.append('\n');
        result.append(this.eOperation.eClass().getName());
        result.append(" named ");
        result.append(this.eOperation.getName());
        result.append(" in ");
        result.append(this.eOperation.getEContainingClass().getName());
        result.append('(');
        result.append(this.eOperation.getEContainingClass().getEPackage().getNsURI());
        result.append(')');
        String doc = EcoreUtil.getDocumentation((EModelElement)this.eOperation);
        if (doc != null) {
            result.append('\n');
            result.append(doc);
        }
        return result.toString();
    }

    private String getEClassifierString(EClassifier eClassifier) {
        Object res = eClassifier == null ? "" : (eClassifier.getEPackage() == null ? eClassifier.getName() : eClassifier.getEPackage().getName() + "::" + eClassifier.getName());
        return res;
    }
}

