/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FontSizePropertyDescriptor;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class FontSizeSection
extends Section {
    protected FontSizePropertyDescriptor fontSize;
    IDescriptorProvider provider;
    private int width = -1;
    private boolean fillCombo = false;
    private String oldValue;

    public FontSizeSection(String labelText, Composite parent, boolean isFormStyle) {
        super(labelText, parent, isFormStyle);
    }

    @Override
    public void createSection() {
        this.getLabelControl(this.parent);
        this.getFontSizeControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    @Override
    public void layout() {
        GridData gd = (GridData)this.fontSize.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - 1 - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - 1 - this.placeholder;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillCombo;
        }
    }

    public FontSizePropertyDescriptor getFontSizeControl() {
        return this.fontSize;
    }

    protected FontSizePropertyDescriptor getFontSizeControl(Composite parent) {
        if (this.fontSize == null) {
            this.fontSize = DescriptorToolkit.createFontSizePropertyDescriptor(true);
            if (this.getProvider() != null) {
                this.fontSize.setDescriptorProvider(this.getProvider());
            }
            this.fontSize.createControl(parent);
            this.fontSize.getControl().setLayoutData((Object)new GridData());
            this.fontSize.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FontSizeSection.this.fontSize = null;
                }
            });
            this.setAccessible(this.fontSize.getControl());
        } else {
            this.checkParent(this.fontSize.getControl(), parent);
        }
        return this.fontSize;
    }

    private void setAccessible(Control control) {
        if (control instanceof Composite) {
            Composite parent = (Composite)control;
            if (parent != null && parent.getTabList() != null) {
                Control[] children = parent.getTabList();
                int i = 0;
                while (i < children.length) {
                    this.setAccessible(children[i]);
                    ++i;
                }
            }
        } else {
            control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    Label lbl = FontSizeSection.this.getLabelControl();
                    if (lbl != null) {
                        e.result = UIUtil.stripMnemonic((String)FontSizeSection.this.getLabelControl().getText()) + FontSizeSection.this.fontSize.getFontSizeValue();
                    }
                }
            });
        }
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.fontSize != null) {
            this.fontSize.setDescriptorProvider(provider);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setInput(Object input) {
        assert (input != null);
        this.fontSize.setInput(input);
    }

    public boolean isFillCombo() {
        return this.fillCombo;
    }

    public void setFillCombo(boolean fillCombo) {
        this.fillCombo = fillCombo;
    }

    public void setStringValue(String value) {
        if (this.fontSize != null) {
            if (value == null) {
                value = "";
            }
            this.oldValue = this.fontSize.getFontSizeValue();
            if (!this.oldValue.equals(value)) {
                this.fontSize.setFontSizeValue(value);
            }
        }
    }

    public void setFocus() {
        if (this.fontSize != null) {
            this.fontSize.getControl().setFocus();
        }
    }

    public String getStringValue() {
        if (this.fontSize != null) {
            return this.fontSize.getFontSizeValue();
        }
        return null;
    }

    @Override
    public void load() {
        if (this.fontSize != null && !this.fontSize.getControl().isDisposed()) {
            this.fontSize.load();
        }
    }

    @Override
    public void reset() {
        if (this.fontSize != null && !this.fontSize.getControl().isDisposed()) {
            this.fontSize.reset();
        }
    }

    @Override
    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, (boolean)isHidden);
        }
        if (this.fontSize != null) {
            this.fontSize.setHidden(isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, (boolean)isHidden);
        }
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.fontSize != null) {
            this.fontSize.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }
}

