/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swt;

import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.IChartComputation;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.RotatedRectangle;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.device.ITextMetrics;
import org.eclipse.birt.chart.device.TextRendererAdapter;
import org.eclipse.birt.chart.device.swt.R31Enhance;
import org.eclipse.birt.chart.device.swt.SwtDisplayServer;
import org.eclipse.birt.chart.device.swt.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.graphics.Transform;

final class SwtTextRenderer
extends TextRendererAdapter {
    private static final PaletteData PALETTE_DATA = new PaletteData(0xFF0000, 65280, 255);
    private static final int TRANSPARENT_COLOR = 1193046;
    private static final int SHADOW_THICKNESS = 3;

    SwtTextRenderer(IDisplayServer sxs) {
        super(sxs);
    }

    Device getDevice() {
        return ((SwtDisplayServer)this._sxs).getDevice();
    }

    public void renderShadowAtLocation(IPrimitiveRenderer ipr, int iLabelPosition, Location lo, Label la) throws ChartException {
        if (!ChartUtil.isShadowDefined((Label)la)) {
            return;
        }
        ColorDefinition cdShadow = la.getShadowColor();
        if (cdShadow == null) {
            throw new ChartException("org.eclipse.birt.chart.device.swt", 11, "SwtTextRenderer.exception.undefined.shadow.color", Messages.getResourceBundle(this._sxs.getULocale()));
        }
        switch (iLabelPosition & 0x3F) {
            case 4: {
                this.showTopValue(ipr, lo, la, false);
                break;
            }
            case 8: {
                this.showBottomValue(ipr, lo, la, false);
                break;
            }
            case 1: {
                this.showLeftValue(ipr, lo, la, false);
                break;
            }
            case 2: {
                this.showRightValue(ipr, lo, la, false);
            }
        }
    }

    private void showRightValue(IPrimitiveRenderer ipr, Location lo, Label la, boolean b) {
    }

    private void showLeftValue(IPrimitiveRenderer ipr, Location lo, Label la, boolean b) {
    }

    private void showBottomValue(IPrimitiveRenderer ipr, Location lo, Label la, boolean b) {
    }

    private void showTopValue(IPrimitiveRenderer ipr, Location lo, Label la, boolean b) {
        GC gc = (GC)((IDeviceRenderer)ipr).getGraphicsContext();
        IChartComputation cComp = ((IDeviceRenderer)ipr).getChartComputation();
        double dX = lo.getX();
        double dY = lo.getY();
        FontDefinition fd = la.getCaption().getFont();
        int dAngleInDegrees = (int)fd.getRotation();
        Color clrBackground = (Color)this._sxs.getColor(la.getShadowColor());
        ITextMetrics itm = cComp.getTextMetrics(this._sxs, la, 0.0);
        double dFW = itm.getFullWidth();
        double dFH = itm.getFullHeight();
        cComp.recycleTextMetrics(itm);
        double scaledThickness = (double)(3 * this._sxs.getDpiResolution()) / 72.0;
        gc.setBackground(clrBackground);
        R31Enhance.setAlpha(gc, la.getShadowColor());
        if (dAngleInDegrees == 0) {
            gc.fillRectangle((int)(dX + scaledThickness), (int)(dY + scaledThickness), (int)dFW, (int)dFH);
        } else if (dAngleInDegrees == 90) {
            gc.fillRectangle((int)(dX + scaledThickness), (int)(dY - dFW - scaledThickness), (int)dFH, (int)dFW);
        } else if (dAngleInDegrees == -90) {
            gc.fillRectangle((int)(dX - dFH - scaledThickness), (int)(dY + scaledThickness), (int)dFH, (int)dFW);
        } else {
            Transform transform = new Transform(this.getDevice());
            transform.translate((float)dX, (float)dY);
            transform.rotate((float)(-dAngleInDegrees));
            gc.setTransform(transform);
            gc.fillRectangle((int)scaledThickness, (int)scaledThickness, (int)dFW, (int)dFH);
            transform.dispose();
            gc.setTransform(null);
        }
    }

    public void renderTextAtLocation(IPrimitiveRenderer idr, int iLabelPosition, Location lo, Label la) throws ChartException {
        GC gc = (GC)((IDeviceRenderer)idr).getGraphicsContext();
        IChartComputation cComp = ((IDeviceRenderer)idr).getChartComputation();
        BoundingBox bb = cComp.computeBox(this._sxs, iLabelPosition, la, 0.0, 0.0);
        switch (iLabelPosition & 0x3F) {
            case 4: {
                bb.setTop(lo.getY() - bb.getHeight());
                bb.setLeft(lo.getX() - bb.getHotPoint());
                break;
            }
            case 8: {
                bb.setTop(lo.getY());
                bb.setLeft(lo.getX() - bb.getHotPoint());
                break;
            }
            case 1: {
                bb.setTop(lo.getY() - bb.getHotPoint());
                bb.setLeft(lo.getX() - bb.getWidth());
                break;
            }
            case 2: {
                bb.setTop(lo.getY() - bb.getHotPoint());
                bb.setLeft(lo.getX());
                break;
            }
            case 32: {
                bb.setTop(lo.getY() - bb.getHeight() / 2.0);
                bb.setLeft(lo.getX() - bb.getWidth() / 2.0);
            }
        }
        this.adjustTextPosition(iLabelPosition, bb);
        if (ChartUtil.isShadowDefined((Label)la)) {
            ITextMetrics itm = cComp.getTextMetrics(this._sxs, la, 0.0);
            try {
                try {
                    double dFH = itm.getFullHeight();
                    Location tmpLoc = Methods.computeRotatedTopPoint((IDisplayServer)this._sxs, (BoundingBox)bb, (Label)la, (double)dFH);
                    this.renderShadowAtLocation(idr, 4, tmpLoc, la);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.device.swt", 11, (Throwable)uiex);
                }
            }
            finally {
                cComp.recycleTextMetrics(itm);
            }
        }
        if (la.getCaption().getFont().getRotation() == 0.0 || R31Enhance.isR31Available()) {
            this.renderHorizontalText(cComp, gc, la, bb.getLeft(), bb.getTop());
        } else {
            Image imgText = this.rotatedTextAsImage(cComp, la);
            gc.drawImage(imgText, (int)bb.getLeft(), (int)bb.getTop());
            imgText.dispose();
        }
        this.renderBorder(cComp, gc, la, iLabelPosition, lo);
    }

    public void renderTextInBlock(IDeviceRenderer idr, Bounds boBlock, TextAlignment taBlock, Label la) throws ChartException {
        IChartComputation cComp = idr.getChartComputation();
        Text t = la.getCaption();
        String sText = t.getValue();
        ColorDefinition cdText = t.getColor();
        if (cdText == null) {
            throw new ChartException("org.eclipse.birt.chart.device.swt", 11, "SwtTextRenderer.exception.undefined.text.color", Messages.getResourceBundle(this._sxs.getULocale()));
        }
        GC gc = (GC)idr.getGraphicsContext();
        la.getCaption().setValue(sText);
        BoundingBox bb = cComp.computeBox(this._sxs, 4, la, 0.0, 0.0);
        if (taBlock == null) {
            taBlock = AttributeFactory.eINSTANCE.createTextAlignment();
            taBlock.setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            taBlock.setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
        }
        HorizontalAlignment haBlock = taBlock.getHorizontalAlignment();
        VerticalAlignment vaBlock = taBlock.getVerticalAlignment();
        switch (haBlock.getValue()) {
            case 1: {
                bb.setLeft(boBlock.getLeft() + (boBlock.getWidth() - bb.getWidth()) / 2.0);
                break;
            }
            case 0: {
                bb.setLeft(boBlock.getLeft());
                break;
            }
            case 2: {
                bb.setLeft(boBlock.getLeft() + boBlock.getWidth() - bb.getWidth());
            }
        }
        switch (vaBlock.getValue()) {
            case 0: {
                bb.setTop(boBlock.getTop());
                break;
            }
            case 1: {
                bb.setTop(boBlock.getTop() + (boBlock.getHeight() - bb.getHeight()) / 2.0);
                break;
            }
            case 2: {
                bb.setTop(boBlock.getTop() + boBlock.getHeight() - bb.getHeight());
            }
        }
        if (ChartUtil.isShadowDefined((Label)la)) {
            ITextMetrics itm = cComp.getTextMetrics(this._sxs, la, 0.0);
            try {
                try {
                    double dFH = itm.getFullHeight();
                    Location tmpLoc = Methods.computeRotatedTopPoint((IDisplayServer)this._sxs, (BoundingBox)bb, (Label)la, (double)dFH);
                    this.renderShadowAtLocation((IPrimitiveRenderer)idr, 4, tmpLoc, la);
                }
                catch (IllegalArgumentException uiex) {
                    throw new ChartException("org.eclipse.birt.chart.device.swt", 11, (Throwable)uiex);
                }
            }
            finally {
                cComp.recycleTextMetrics(itm);
            }
        }
        if (la.getCaption().getFont().getRotation() == 0.0 || R31Enhance.isR31Available()) {
            this.renderHorizontalText(cComp, gc, la, bb.getLeft(), bb.getTop());
        } else {
            Image imgText = this.rotatedTextAsImage(cComp, la);
            gc.drawImage(imgText, (int)bb.getLeft(), (int)bb.getTop());
            imgText.dispose();
        }
        this.renderBorder(cComp, gc, la, 4, goFactory.createLocation(bb.getLeft() + bb.getHotPoint(), bb.getTop() + bb.getHeight()));
    }

    private void renderBorder(IChartComputation cComp, GC gc, Label la, int iLabelLocation, Location lo) throws ChartException {
        LineAttributes lia = la.getOutline();
        if (lia != null && lia.isVisible() && lia.getColor() != null) {
            RotatedRectangle rr = cComp.computePolygon(this._sxs, iLabelLocation, la, lo.getX(), lo.getY(), null);
            int iOldLineStyle = gc.getLineStyle();
            int iOldLineWidth = gc.getLineWidth();
            Color cFG = (Color)this._sxs.getColor(lia.getColor());
            gc.setForeground(cFG);
            R31Enhance.setAlpha(gc, lia.getColor());
            int iLineStyle = 1;
            switch (lia.getStyle().getValue()) {
                case 2: {
                    iLineStyle = 3;
                    break;
                }
                case 3: {
                    iLineStyle = 4;
                    break;
                }
                case 1: {
                    iLineStyle = 2;
                }
            }
            gc.setLineStyle(iLineStyle);
            gc.setLineWidth(lia.getThickness());
            gc.drawPolygon(rr.getSwtPoints());
            gc.setLineStyle(iOldLineStyle);
            gc.setLineWidth(iOldLineWidth);
            cFG.dispose();
        }
    }

    private void renderHorizontalText(IChartComputation cComp, GC gc, Label la, double dX, double dY) {
        Rectangle r;
        FontDefinition fd = la.getCaption().getFont();
        Color clrText = (Color)this._sxs.getColor(la.getCaption().getColor());
        ITextMetrics itm = cComp.getTextMetrics(this._sxs, la, 0.0);
        double dFW = itm.getFullWidth();
        double dH = itm.getHeight();
        double dFH = itm.getFullHeight();
        double dXOffset = 0.0;
        double dW = 0.0;
        Insets ins = goFactory.scaleInsets(la.getInsets(), (double)this._sxs.getDpiResolution() / 72.0);
        HorizontalAlignment ha = la.getCaption().getFont().getAlignment().getHorizontalAlignment();
        boolean bRightAligned = ha.getValue() == 2;
        boolean bCenterAligned = ha.getValue() == 1;
        Transform tr = null;
        Transform trOld = new Transform(this.getDevice());
        gc.getTransform(trOld);
        Region previousClipping = null;
        if (R31Enhance.isR31Available()) {
            r = new Rectangle(0, 0, (int)dFW, (int)dFH);
            tr = new Transform(this.getDevice());
            gc.getTransform(tr);
            if (la.getCaption().getFont().getRotation() != 0.0) {
                float rotate = (float)la.getCaption().getFont().getRotation();
                double dAngleInRadians = (double)(-rotate) * Math.PI / 180.0;
                double dSineTheta = Math.sin(dAngleInRadians);
                float tTx = (float)(dX - dFW / 2.0);
                float tTy = (float)(dY - dFH / 2.0);
                if (rotate > 0.0f) {
                    tTy = (float)((double)tTy + dFW * Math.abs(dSineTheta));
                } else {
                    tTx = (float)((double)tTx + dFH * Math.abs(dSineTheta));
                }
                tr.translate((float)(dFW / 2.0), (float)(dFH / 2.0));
                tr.translate(tTx, tTy);
                tr.rotate(-rotate);
            } else {
                R31Enhance.translate(gc, tr, (float)dX, (float)dY);
            }
            previousClipping = new Region();
            gc.getClipping(previousClipping);
            R31Enhance.setTransform(gc, tr);
        } else {
            r = new Rectangle((int)dX, (int)dY, (int)dFW, (int)dFH);
        }
        boolean bFullyTransparent = true;
        if (la.getBackground() != null) {
            bFullyTransparent = ((ColorDefinition)la.getBackground()).getTransparency() == 0;
            R31Enhance.setAlpha(gc, 255);
        }
        if (!bFullyTransparent) {
            Color clrBackground = (Color)this._sxs.getColor((ColorDefinition)la.getBackground());
            Color clrPreviousBackground = gc.getBackground();
            if (((ColorDefinition)la.getBackground()).isSetTransparency()) {
                R31Enhance.setAlpha(gc, (ColorDefinition)la.getBackground());
            }
            gc.setBackground(clrBackground);
            gc.fillRectangle(r);
            clrBackground.dispose();
            gc.setBackground(clrPreviousBackground);
        }
        gc.setForeground(clrText);
        R31Enhance.setAlpha(gc, la.getCaption().getColor());
        Font f = (Font)this._sxs.createFont(fd);
        gc.setFont(f);
        TextStyle style = new TextStyle(f, null, null);
        style.underline = fd.isUnderline();
        style.strikeout = fd.isStrikethrough();
        TextLayout layout = new TextLayout(gc.getDevice());
        if (R31Enhance.isR31Available()) {
            int i = 0;
            while (i < itm.getLineCount()) {
                String oText = itm.getLine(i);
                dW = itm.getWidth(i);
                if (bRightAligned) {
                    dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                } else if (bCenterAligned) {
                    dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                }
                int x = (int)(dXOffset + ins.getLeft());
                int y = (int)(dH * (double)i + ins.getTop());
                layout.setText(oText);
                layout.setStyle(style, 0, oText.length());
                layout.draw(gc, x, y);
                ++i;
            }
        } else {
            int i = 0;
            while (i < itm.getLineCount()) {
                String oText = itm.getLine(i);
                dW = itm.getWidth(i);
                if (bRightAligned) {
                    dXOffset = -ins.getLeft() + dFW - dW - ins.getRight();
                } else if (bCenterAligned) {
                    dXOffset = -ins.getLeft() + (dFW - dW) / 2.0;
                }
                int x = (int)(dX + dXOffset + ins.getLeft());
                int y = (int)(dY + dH * (double)i + ins.getTop());
                layout.setText(oText);
                layout.setStyle(style, 0, oText.length());
                layout.draw(gc, x, y);
                ++i;
            }
        }
        R31Enhance.setTransform(gc, trOld);
        if (previousClipping != null) {
            gc.setClipping(previousClipping);
            previousClipping.dispose();
        }
        R31Enhance.disposeTransform(trOld);
        R31Enhance.disposeTransform(tr);
        layout.dispose();
        f.dispose();
        clrText.dispose();
        cComp.recycleTextMetrics(itm);
    }

    Image rotatedTextAsImage(IChartComputation cComp, Label la) {
        boolean bFullyTransparent;
        double dX = 0.0;
        double dY = 0.0;
        FontDefinition fd = la.getCaption().getFont();
        double dAngleInDegrees = fd.getRotation();
        Color clrText = (Color)this._sxs.getColor(la.getCaption().getColor());
        double dAngleInRadians = -dAngleInDegrees * Math.PI / 180.0;
        ITextMetrics itm = cComp.getTextMetrics(this._sxs, la, 0.0);
        double dFW = itm.getFullWidth();
        double dH = itm.getHeight();
        double dFH = itm.getFullHeight();
        int iLC = itm.getLineCount();
        Insets ins = goFactory.scaleInsets(la.getInsets(), (double)this._sxs.getDpiResolution() / 72.0);
        dY += dFH;
        double dCosTheta = Math.cos(dAngleInRadians);
        double dSineTheta = Math.sin(dAngleInRadians);
        double dFWt = Math.abs(dFW * dCosTheta + dFH * Math.abs(dSineTheta));
        double dFHt = Math.abs(dFH * dCosTheta + dFW * Math.abs(dSineTheta));
        int clipWs = (int)dFW;
        int clipHs = (int)dFH;
        int clipWt = (int)dFWt;
        int clipHt = (int)dFHt;
        ImageData imgdtaS = new ImageData(clipWs, clipHs, 32, PALETTE_DATA);
        imgdtaS.transparentPixel = 1193046;
        Image imgSource = new Image(this.getDevice(), imgdtaS);
        int i = 0;
        while (i < clipHs) {
            int j = 0;
            while (j < clipWs) {
                imgdtaS.setPixel(j, i, imgdtaS.transparentPixel);
                ++j;
            }
            ++i;
        }
        GC gc = new GC((Drawable)imgSource);
        Font f = (Font)this._sxs.createFont(fd);
        Rectangle r = new Rectangle((int)dX, (int)(dY - dFH), (int)dFW, (int)dFH);
        boolean bl = bFullyTransparent = ((ColorDefinition)la.getBackground()).getTransparency() == 0;
        if (!bFullyTransparent) {
            Color clrBackground = (Color)this._sxs.getColor((ColorDefinition)la.getBackground());
            gc.setBackground(clrBackground);
            gc.fillRectangle(r);
            clrBackground.dispose();
        } else {
            Color cTransparent = new Color(this.getDevice(), 18, 52, 86);
            gc.setBackground(cTransparent);
            gc.fillRectangle(r);
            cTransparent.dispose();
        }
        gc.setForeground(clrText);
        gc.setFont(f);
        int i2 = 0;
        while (i2 < itm.getLineCount()) {
            gc.drawText(itm.getLine(iLC - i2 - 1), (int)(dX + ins.getLeft()), (int)(dY - dH - dH * (double)i2 + ins.getTop()), false);
            ++i2;
        }
        int lineWidth = 0;
        if (fd.isUnderline() || fd.isStrikethrough()) {
            lineWidth = (int)(fd.getSize() / 12.0f);
            gc.setLineWidth(lineWidth);
            if (fd.isUnderline()) {
                gc.drawLine((int)(dX + ins.getLeft()), (int)(dY - dFH + dH - (double)lineWidth), (int)(dX + ins.getLeft() + dFW), (int)(dY - dFH + dH - (double)lineWidth));
            }
            if (fd.isStrikethrough()) {
                gc.drawLine((int)(dX + ins.getLeft()), (int)(dY - dFH + dH * 0.5 - (double)lineWidth), (int)(dX + ins.getLeft() + dFW), (int)(dY - dFH + dH * 0.5 - (double)lineWidth));
            }
        }
        clrText.dispose();
        cComp.recycleTextMetrics(itm);
        f.dispose();
        gc.dispose();
        imgdtaS = imgSource.getImageData();
        ImageData imgdtaT = new ImageData(clipWt, clipHt, 32, PALETTE_DATA);
        imgdtaT.palette = imgdtaS.palette;
        imgdtaT.transparentPixel = imgdtaS.transparentPixel;
        int i3 = 0;
        while (i3 < clipHt) {
            int j = 0;
            while (j < clipWt) {
                imgdtaT.setPixel(j, i3, imgdtaT.transparentPixel);
                ++j;
            }
            ++i3;
        }
        int neg = dAngleInDegrees < 0.0 ? (int)((double)clipHs * dSineTheta) : 0;
        int pos = dAngleInDegrees > 0.0 ? (int)((double)clipWs * Math.abs(dSineTheta)) : 0;
        int yMax = clipHt - pos;
        int xMax = clipWt - neg;
        int xSrc = 0;
        int ySrc = 0;
        int xDest = 0;
        int yDest = 0;
        int x = 0;
        int y = 0;
        yDest = -pos;
        while (yDest < yMax) {
            double yDestCosTheta = (double)yDest * dCosTheta;
            double yDestSineTheta = (double)yDest * dSineTheta;
            xDest = -neg;
            while (xDest < xMax) {
                xSrc = (int)Math.round((double)xDest * dCosTheta + yDestSineTheta);
                ySrc = (int)Math.round(yDestCosTheta - (double)xDest * dSineTheta);
                if (xSrc >= 0 && xSrc < clipWs && ySrc >= 0 && ySrc < clipHs) {
                    x = xDest + neg;
                    y = yDest + pos;
                    if (x >= 0 && x < clipWt && y >= 0 && y < clipHt) {
                        imgdtaT.setPixel(x, y, imgdtaS.getPixel(xSrc, ySrc));
                    }
                }
                ++xDest;
            }
            ++yDest;
        }
        imgSource.dispose();
        return new Image(this.getDevice(), imgdtaT);
    }

    protected void adjustTextPosition(int iLabelPosition, BoundingBox bb) {
        if (iLabelPosition > 63) {
            if ((iLabelPosition & 0x100) == 256) {
                bb.setTop(bb.getTop() - bb.getHotPoint());
            } else if ((iLabelPosition & 0x200) == 512) {
                bb.setTop(bb.getTop() + bb.getHotPoint());
            } else if ((iLabelPosition & 0x40) == 64) {
                bb.setLeft(bb.getLeft() - bb.getHotPoint());
            } else if ((iLabelPosition & 0x80) == 128) {
                bb.setLeft(bb.getLeft() + bb.getHotPoint());
            }
        }
    }
}

