/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.dom;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSValue;

public abstract class AbstractStyle
implements IStyle {
    protected CSSEngine engine;

    public AbstractStyle(CSSEngine engine) {
        this.engine = engine;
    }

    public CSSEngine getCSSEngine() {
        return this.engine;
    }

    @Override
    public void setProperties(IStyle style) {
        int i = 0;
        while (i < 70) {
            CSSValue v = style.getProperty(i);
            if (v != null) {
                this.setProperty(i, v);
            }
            ++i;
        }
    }

    @Override
    public String getCssText() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 70) {
            CSSValue value;
            if (i != 3 && (value = this.getProperty(i)) != null) {
                sb.append(this.engine.getPropertyName(i));
                sb.append(": ");
                short type = value.getCssValueType();
                block0 : switch (type) {
                    case 1: {
                        CSSPrimitiveValue pv = (CSSPrimitiveValue)value;
                        short unitType = pv.getPrimitiveType();
                        switch (unitType) {
                            case 19: {
                                sb.append("'");
                                sb.append(pv.getStringValue());
                                sb.append("'");
                                break block0;
                            }
                            case 20: {
                                sb.append("url('");
                                sb.append(pv.getStringValue());
                                sb.append("')");
                                break block0;
                            }
                        }
                        sb.append(value.getCssText());
                        break;
                    }
                    default: {
                        sb.append(value.getCssText());
                    }
                }
                sb.append("; ");
            }
            ++i;
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    protected String getCssText(CSSValue value) {
        if (value == null) {
            return null;
        }
        return value.getCssText();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        IStyle style = (IStyle)this.engine.parseStyleDeclaration(cssText);
        int i = 0;
        while (i < 70) {
            CSSValue value = style.getProperty(i);
            if (value != null) {
                this.setProperty(i, value);
            }
            ++i;
        }
    }

    protected int getPropertyIndex(String propertyName) {
        return this.engine.getPropertyIndex(propertyName);
    }

    @Override
    public String getPropertyValue(String propertyName) {
        int index = this.getPropertyIndex(propertyName);
        if (index != -1) {
            return this.getCssText(index);
        }
        return null;
    }

    @Override
    public CSSValue getPropertyCSSValue(String propertyName) {
        int index = this.getPropertyIndex(propertyName);
        if (index != -1) {
            return this.getProperty(index);
        }
        return null;
    }

    @Override
    public String removeProperty(String propertyName) throws DOMException {
        int index = this.getPropertyIndex(propertyName);
        if (index != -1) {
            this.setProperty(index, null);
        }
        return null;
    }

    @Override
    public String getPropertyPriority(String propertyName) {
        throw new DOMException(9, "getPropertyPriority");
    }

    @Override
    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        int index = this.getPropertyIndex(propertyName);
        if (index != -1) {
            this.setCssText(index, value);
        }
    }

    @Override
    public int getLength() {
        throw new DOMException(9, "getLength");
    }

    @Override
    public String item(int index) {
        throw new DOMException(9, "item");
    }

    @Override
    public CSSRule getParentRule() {
        throw new DOMException(9, "getParentRule");
    }

    @Override
    public String getCssText(int index) {
        CSSValue value = this.getProperty(index);
        if (value != null) {
            return value.getCssText();
        }
        return null;
    }

    @Override
    public void setCssText(int index, String cssText) {
        if (cssText != null) {
            CSSValue value = this.engine.parsePropertyValue(index, cssText);
            this.setProperty(index, value);
        } else {
            this.setProperty(index, null);
        }
    }

    @Override
    public String getFontFamily() {
        return this.getCssText(67);
    }

    @Override
    public String getFontStyle() {
        return this.getCssText(54);
    }

    @Override
    public String getFontVariant() {
        return this.getCssText(45);
    }

    @Override
    public String getFontWeight() {
        return this.getCssText(44);
    }

    @Override
    public String getFontSize() {
        return this.getCssText(53);
    }

    @Override
    public String getColor() {
        return this.getCssText(64);
    }

    @Override
    public String getBackgroundColor() {
        return this.getCssText(40);
    }

    @Override
    public String getBackgroundImage() {
        return this.getCssText(59);
    }

    @Override
    public String getBackgroundImageType() {
        return this.getCssText(60);
    }

    @Override
    public String getBackgroundHeight() {
        return this.getCssText(28);
    }

    @Override
    public String getBackgroundWidth() {
        return this.getCssText(42);
    }

    @Override
    public String getBackgroundRepeat() {
        return this.getCssText(25);
    }

    @Override
    public String getBackgroundAttachment() {
        return this.getCssText(68);
    }

    @Override
    public String getBackgroundPositionX() {
        return this.getCssText(55);
    }

    @Override
    public String getBackgroundPositionY() {
        return this.getCssText(61);
    }

    @Override
    public String getWordSpacing() {
        return this.getCssText(35);
    }

    @Override
    public String getLetterSpacing() {
        return this.getCssText(69);
    }

    @Override
    public String getTextUnderline() {
        return this.getCssText(62);
    }

    @Override
    public String getTextOverline() {
        return this.getCssText(51);
    }

    @Override
    public String getTextLineThrough() {
        return this.getCssText(36);
    }

    @Override
    public String getVerticalAlign() {
        return this.getCssText(43);
    }

    @Override
    public String getTextTransform() {
        return this.getCssText(32);
    }

    @Override
    public String getTextAlign() {
        return this.getCssText(39);
    }

    @Override
    public String getTextIndent() {
        return this.getCssText(29);
    }

    @Override
    public String getLineHeight() {
        return this.getCssText(63);
    }

    @Override
    public String getWhiteSpace() {
        return this.getCssText(57);
    }

    @Override
    public String getMarginTop() {
        return this.getCssText(6);
    }

    @Override
    public String getMarginBottom() {
        return this.getCssText(2);
    }

    @Override
    public String getMarginLeft() {
        return this.getCssText(0);
    }

    @Override
    public String getMarginRight() {
        return this.getCssText(1);
    }

    @Override
    public String getPaddingTop() {
        return this.getCssText(19);
    }

    @Override
    public String getPaddingBottom() {
        return this.getCssText(13);
    }

    @Override
    public String getPaddingLeft() {
        return this.getCssText(12);
    }

    @Override
    public String getPaddingRight() {
        return this.getCssText(16);
    }

    @Override
    public String getBorderTopWidth() {
        return this.getCssText(27);
    }

    @Override
    public String getBorderBottomWidth() {
        return this.getCssText(10);
    }

    @Override
    public String getBorderLeftWidth() {
        return this.getCssText(50);
    }

    @Override
    public String getBorderRightWidth() {
        return this.getCssText(9);
    }

    @Override
    public String getBorderTopColor() {
        return this.getCssText(24);
    }

    @Override
    public String getBorderBottomColor() {
        return this.getCssText(5);
    }

    @Override
    public String getBorderLeftColor() {
        return this.getCssText(47);
    }

    @Override
    public String getBorderRightColor() {
        return this.getCssText(4);
    }

    @Override
    public String getBorderTopStyle() {
        return this.getCssText(49);
    }

    @Override
    public String getBorderBottomStyle() {
        return this.getCssText(21);
    }

    @Override
    public String getBorderLeftStyle() {
        return this.getCssText(58);
    }

    @Override
    public String getBorderRightStyle() {
        return this.getCssText(20);
    }

    @Override
    public String getDisplay() {
        return this.getCssText(65);
    }

    @Override
    public String getOrphans() {
        return this.getCssText(41);
    }

    @Override
    public String getWidows() {
        return this.getCssText(52);
    }

    @Override
    public String getPageBreakAfter() {
        return this.getCssText(66);
    }

    @Override
    public String getPageBreakBefore() {
        return this.getCssText(30);
    }

    @Override
    public String getPageBreakInside() {
        return this.getCssText(56);
    }

    @Override
    public String getMasterPage() {
        return this.getCssText(46);
    }

    @Override
    public String getShowIfBlank() {
        return this.getCssText(48);
    }

    @Override
    public String getCanShrink() {
        return this.getCssText(33);
    }

    @Override
    public String getVisibleFormat() {
        return this.getCssText(38);
    }

    @Override
    public void setBackgroundAttachment(String backgroundAttachment) {
        this.setCssText(68, backgroundAttachment);
    }

    @Override
    public void setBackgroundColor(String backgroundColor) {
        this.setCssText(40, backgroundColor);
    }

    @Override
    public void setBackgroundImage(String backgroundImage) {
        this.setCssText(59, backgroundImage);
    }

    @Override
    public void setBackgroundImageType(String backgroundImageSourceType) {
        this.setCssText(60, backgroundImageSourceType);
    }

    @Override
    public void setBackgroundPositionX(String backgroundPositionX) {
        this.setCssText(55, backgroundPositionX);
    }

    @Override
    public void setBackgroundPositionY(String backgroundPositionY) {
        this.setCssText(61, backgroundPositionY);
    }

    @Override
    public void setBackgroundRepeat(String backgroundRepeat) {
        this.setCssText(25, backgroundRepeat);
    }

    @Override
    public void setBackgroundHeight(String height) {
        this.setCssText(28, height);
    }

    @Override
    public void setBackgroundWidth(String width) {
        this.setCssText(42, width);
    }

    @Override
    public void setBorderBottomColor(String borderBottomColor) {
        this.setCssText(5, borderBottomColor);
    }

    @Override
    public void setBorderBottomStyle(String borderBottomStyle) {
        this.setCssText(21, borderBottomStyle);
    }

    @Override
    public void setBorderBottomWidth(String borderBottomWidth) {
        this.setCssText(10, borderBottomWidth);
    }

    @Override
    public void setBorderLeftColor(String borderLeftColor) {
        this.setCssText(47, borderLeftColor);
    }

    @Override
    public void setBorderLeftStyle(String borderLeftStyle) {
        this.setCssText(58, borderLeftStyle);
    }

    @Override
    public void setBorderLeftWidth(String borderLeftWidth) {
        this.setCssText(50, borderLeftWidth);
    }

    @Override
    public void setBorderRightColor(String borderRightColor) {
        this.setCssText(4, borderRightColor);
    }

    @Override
    public void setBorderRightStyle(String borderRightStyle) {
        this.setCssText(20, borderRightStyle);
    }

    @Override
    public void setBorderRightWidth(String borderRightWidth) {
        this.setCssText(9, borderRightWidth);
    }

    @Override
    public void setBorderTopColor(String borderTopColor) {
        this.setCssText(24, borderTopColor);
    }

    @Override
    public void setBorderTopStyle(String borderTopStyle) {
        this.setCssText(49, borderTopStyle);
    }

    @Override
    public void setBorderTopWidth(String borderTopWidth) {
        this.setCssText(27, borderTopWidth);
    }

    @Override
    public void setCanShrink(String canShrink) {
        this.setCssText(33, canShrink);
    }

    @Override
    public void setColor(String color) {
        this.setCssText(64, color);
    }

    @Override
    public void setDisplay(String display) {
        this.setCssText(65, display);
    }

    @Override
    public void setFontFamily(String fontFamily) {
        this.setCssText(67, fontFamily);
    }

    @Override
    public void setFontSize(String fontSize) {
        this.setCssText(53, fontSize);
    }

    @Override
    public void setFontStyle(String fontStyle) {
        this.setCssText(54, fontStyle);
    }

    @Override
    public void setFontVariant(String fontVariant) {
        this.setCssText(45, fontVariant);
    }

    @Override
    public void setFontWeight(String fontWeight) {
        this.setCssText(44, fontWeight);
    }

    @Override
    public void setLetterSpacing(String letterSpacing) {
        this.setCssText(69, letterSpacing);
    }

    @Override
    public void setLineHeight(String lineHeight) {
        this.setCssText(63, lineHeight);
    }

    @Override
    public void setMarginBottom(String marginBottom) {
        this.setCssText(2, marginBottom);
    }

    @Override
    public void setMarginLeft(String marginLeft) {
        this.setCssText(0, marginLeft);
    }

    @Override
    public void setMarginRight(String marginRight) {
        this.setCssText(1, marginRight);
    }

    @Override
    public void setMarginTop(String marginTop) {
        this.setCssText(6, marginTop);
    }

    @Override
    public void setMasterPage(String masterPage) {
        this.setCssText(46, masterPage);
    }

    @Override
    public void setOrphans(String orphans) {
        this.setCssText(41, orphans);
    }

    @Override
    public void setPaddingBottom(String paddingBottom) {
        this.setCssText(13, paddingBottom);
    }

    @Override
    public void setPaddingLeft(String paddingLeft) {
        this.setCssText(12, paddingLeft);
    }

    @Override
    public void setPaddingRight(String paddingRight) {
        this.setCssText(16, paddingRight);
    }

    @Override
    public void setPaddingTop(String paddingTop) {
        this.setCssText(19, paddingTop);
    }

    @Override
    public void setPageBreakAfter(String pageBreakAfter) {
        this.setCssText(66, pageBreakAfter);
    }

    @Override
    public void setPageBreakBefore(String pageBreakBefore) {
        this.setCssText(30, pageBreakBefore);
    }

    @Override
    public void setPageBreakInside(String pageBreakInside) {
        this.setCssText(56, pageBreakInside);
    }

    @Override
    public void setShowIfBlank(String showIfBlank) {
        this.setCssText(48, showIfBlank);
    }

    @Override
    public void setTextAlign(String textAlign) {
        this.setCssText(39, textAlign);
    }

    @Override
    public void setTextIndent(String textIndent) {
        this.setCssText(29, textIndent);
    }

    @Override
    public void setTextLineThrough(String textLineThrough) {
        this.setCssText(36, textLineThrough);
    }

    @Override
    public void setTextOverline(String textOverline) {
        this.setCssText(51, textOverline);
    }

    @Override
    public void setTextTransform(String textTransform) {
        this.setCssText(32, textTransform);
    }

    @Override
    public void setTextUnderline(String textUnderline) {
        this.setCssText(62, textUnderline);
    }

    @Override
    public void setVerticalAlign(String verticalAlign) {
        this.setCssText(43, verticalAlign);
    }

    @Override
    public void setWhiteSpace(String whiteSpace) {
        this.setCssText(57, whiteSpace);
    }

    @Override
    public void setWidows(String widows) {
        this.setCssText(52, widows);
    }

    @Override
    public void setWordSpacing(String wordSpacing) throws DOMException {
        this.setCssText(35, wordSpacing);
    }

    private DataFormatValue copyDataFormat(DataFormatValue old) {
        DataFormatValue newValue = DataFormatValue.createDataFormatValue(old);
        this.setDataFormat(newValue);
        return newValue;
    }

    @Override
    public void setStringFormat(String format) throws DOMException {
        DataFormatValue value = this.getDataFormat();
        DataFormatValue newValue = this.copyDataFormat(value);
        newValue.setStringFormat(format, value == null ? null : value.getStringLocale());
    }

    @Override
    public void setNumberFormat(String format) throws DOMException {
        DataFormatValue value = this.getDataFormat();
        DataFormatValue newValue = this.copyDataFormat(value);
        newValue.setNumberFormat(format, value == null ? null : value.getNumberLocale());
    }

    @Override
    public void setDateFormat(String format) throws DOMException {
        DataFormatValue value = this.getDataFormat();
        DataFormatValue newValue = this.copyDataFormat(value);
        newValue.setDateFormat(format, value == null ? null : value.getDateLocale());
    }

    public void setDateTimeFormat(String format) throws DOMException {
        DataFormatValue value = this.getDataFormat();
        DataFormatValue newValue = this.copyDataFormat(value);
        newValue.setDateTimeFormat(format, value == null ? null : value.getDateTimeLocale());
    }

    public void setTimeFormat(String format) throws DOMException {
        DataFormatValue value = this.getDataFormat();
        DataFormatValue newValue = this.copyDataFormat(value);
        newValue.setTimeFormat(format, value == null ? null : value.getTimeLocale());
    }

    @Override
    public void setNumberAlign(String align) throws DOMException {
        this.setCssText(37, align);
    }

    @Override
    public void setVisibleFormat(String formats) throws DOMException {
        this.setCssText(38, formats);
    }

    @Override
    public String getStringFormat() {
        DataFormatValue value = this.getDataFormat();
        if (value != null) {
            return value.getStringPattern();
        }
        return null;
    }

    @Override
    public String getNumberFormat() {
        DataFormatValue value = this.getDataFormat();
        if (value != null) {
            return value.getNumberPattern();
        }
        return null;
    }

    @Override
    public String getDateFormat() {
        DataFormatValue value = this.getDataFormat();
        if (value != null) {
            return value.getDatePattern();
        }
        return null;
    }

    @Override
    public String getDateTimeFormat() {
        DataFormatValue value = this.getDataFormat();
        if (value != null) {
            return value.getDateTimePattern();
        }
        return null;
    }

    @Override
    public String getTimeFormat() {
        DataFormatValue value = this.getDataFormat();
        if (value != null) {
            return value.getTimePattern();
        }
        return null;
    }

    @Override
    public String getNumberAlign() {
        return this.getCssText(37);
    }

    @Override
    public String getAzimuth() {
        return null;
    }

    @Override
    public void setAzimuth(String azimuth) throws DOMException {
    }

    @Override
    public String getBackground() {
        return null;
    }

    @Override
    public void setBackground(String background) throws DOMException {
    }

    @Override
    public String getBackgroundPosition() {
        return null;
    }

    @Override
    public void setBackgroundPosition(String backgroundPosition) throws DOMException {
    }

    @Override
    public String getBorder() {
        return null;
    }

    @Override
    public void setBorder(String border) throws DOMException {
    }

    @Override
    public String getBorderCollapse() {
        return null;
    }

    @Override
    public void setBorderCollapse(String borderCollapse) throws DOMException {
    }

    @Override
    public String getBorderColor() {
        return null;
    }

    @Override
    public void setBorderColor(String borderColor) throws DOMException {
    }

    @Override
    public String getBorderSpacing() {
        return null;
    }

    @Override
    public void setBorderSpacing(String borderSpacing) throws DOMException {
    }

    @Override
    public String getBorderStyle() {
        return null;
    }

    @Override
    public void setBorderStyle(String borderStyle) throws DOMException {
    }

    @Override
    public String getBorderTop() {
        return null;
    }

    @Override
    public void setBorderTop(String borderTop) throws DOMException {
    }

    @Override
    public String getBorderRight() {
        return null;
    }

    @Override
    public void setBorderRight(String borderRight) throws DOMException {
    }

    @Override
    public String getBorderBottom() {
        return null;
    }

    @Override
    public void setBorderBottom(String borderBottom) throws DOMException {
    }

    @Override
    public String getBorderLeft() {
        return null;
    }

    @Override
    public void setBorderLeft(String borderLeft) throws DOMException {
    }

    @Override
    public String getBorderWidth() {
        return null;
    }

    @Override
    public void setBorderWidth(String borderWidth) throws DOMException {
    }

    @Override
    public String getBottom() {
        return null;
    }

    @Override
    public void setBottom(String bottom) throws DOMException {
    }

    @Override
    public String getCaptionSide() {
        return null;
    }

    @Override
    public void setCaptionSide(String captionSide) throws DOMException {
    }

    @Override
    public String getClear() {
        return null;
    }

    @Override
    public void setClear(String clear) throws DOMException {
    }

    @Override
    public String getClip() {
        return null;
    }

    @Override
    public void setClip(String clip) throws DOMException {
    }

    @Override
    public String getContent() {
        return null;
    }

    @Override
    public void setContent(String content) throws DOMException {
    }

    @Override
    public String getCounterIncrement() {
        return null;
    }

    @Override
    public void setCounterIncrement(String counterIncrement) throws DOMException {
    }

    @Override
    public String getCounterReset() {
        return null;
    }

    @Override
    public void setCounterReset(String counterReset) throws DOMException {
    }

    @Override
    public String getCue() {
        return null;
    }

    @Override
    public void setCue(String cue) throws DOMException {
    }

    @Override
    public String getCueAfter() {
        return null;
    }

    @Override
    public void setCueAfter(String cueAfter) throws DOMException {
    }

    @Override
    public String getCueBefore() {
        return null;
    }

    @Override
    public void setCueBefore(String cueBefore) throws DOMException {
    }

    @Override
    public String getCursor() {
        return null;
    }

    @Override
    public void setCursor(String cursor) throws DOMException {
    }

    @Override
    public String getDirection() {
        return this.getCssText(17);
    }

    @Override
    public void setDirection(String direction) throws DOMException {
        this.setCssText(17, direction);
    }

    @Override
    public String getElevation() {
        return null;
    }

    @Override
    public void setElevation(String elevation) throws DOMException {
    }

    @Override
    public String getEmptyCells() {
        return null;
    }

    @Override
    public void setEmptyCells(String emptyCells) throws DOMException {
    }

    @Override
    public String getCssFloat() {
        return null;
    }

    @Override
    public void setCssFloat(String cssFloat) throws DOMException {
    }

    @Override
    public String getFont() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setFont(String font) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getFontSizeAdjust() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setFontSizeAdjust(String fontSizeAdjust) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getFontStretch() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setFontStretch(String fontStretch) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getHeight() {
        return this.getCssText(34);
    }

    @Override
    public void setHeight(String height) throws DOMException {
        this.setCssText(34, height);
    }

    @Override
    public String getLeft() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setLeft(String left) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getListStyle() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setListStyle(String listStyle) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getListStyleImage() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setListStyleImage(String listStyleImage) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getListStylePosition() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setListStylePosition(String listStylePosition) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getListStyleType() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setListStyleType(String listStyleType) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getMargin() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setMargin(String margin) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getMarkerOffset() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setMarkerOffset(String markerOffset) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getMarks() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setMarks(String marks) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getMaxHeight() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setMaxHeight(String maxHeight) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getMaxWidth() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setMaxWidth(String maxWidth) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getMinHeight() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setMinHeight(String minHeight) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getMinWidth() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setMinWidth(String minWidth) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getOutline() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setOutline(String outline) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getOutlineColor() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setOutlineColor(String outlineColor) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getOutlineStyle() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setOutlineStyle(String outlineStyle) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getOutlineWidth() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setOutlineWidth(String outlineWidth) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getOverflow() {
        return this.getCssText(31);
    }

    @Override
    public void setOverflow(String overflow) throws DOMException {
        this.setCssText(31, overflow);
    }

    @Override
    public String getPadding() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setPadding(String padding) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getPage() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setPage(String page) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getPause() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setPause(String pause) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getPauseAfter() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setPauseAfter(String pauseAfter) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getPauseBefore() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setPauseBefore(String pauseBefore) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getPitch() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setPitch(String pitch) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getPitchRange() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setPitchRange(String pitchRange) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getPlayDuring() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setPlayDuring(String playDuring) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getPosition() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setPosition(String position) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getQuotes() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setQuotes(String quotes) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getRichness() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setRichness(String richness) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getRight() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setRight(String right) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getSize() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setSize(String size) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getSpeak() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setSpeak(String speak) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getSpeakHeader() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setSpeakHeader(String speakHeader) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getSpeakNumeral() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setSpeakNumeral(String speakNumeral) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getSpeakPunctuation() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setSpeakPunctuation(String speakPunctuation) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getSpeechRate() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setSpeechRate(String speechRate) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getStress() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setStress(String stress) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getTableLayout() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setTableLayout(String tableLayout) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getTextDecoration() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public void setTextDecoration(String textDecoration) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    @Override
    public String getTextShadow() {
        throw this.createUnsupportedPropertyException("text-shadow");
    }

    @Override
    public void setTextShadow(String textShadow) throws DOMException {
        throw this.createUnsupportedPropertyException("text-shadow");
    }

    @Override
    public String getTop() {
        throw this.createUnsupportedPropertyException("top");
    }

    @Override
    public void setTop(String top) throws DOMException {
        throw this.createUnsupportedPropertyException("top");
    }

    @Override
    public String getUnicodeBidi() {
        throw this.createUnsupportedPropertyException("unicode-bidi");
    }

    @Override
    public void setUnicodeBidi(String unicodeBidi) throws DOMException {
        throw this.createUnsupportedPropertyException("unicode-bidi");
    }

    @Override
    public String getVisibility() {
        throw this.createUnsupportedPropertyException("visibility");
    }

    @Override
    public void setVisibility(String visibility) throws DOMException {
        throw this.createUnsupportedPropertyException("visibility");
    }

    @Override
    public String getVoiceFamily() {
        throw this.createUnsupportedPropertyException("voice-family");
    }

    @Override
    public void setVoiceFamily(String voiceFamily) throws DOMException {
        throw this.createUnsupportedPropertyException("voice-family");
    }

    @Override
    public String getVolume() {
        throw this.createUnsupportedPropertyException("volumn");
    }

    @Override
    public void setVolume(String volume) throws DOMException {
        throw this.createUnsupportedPropertyException("volumn");
    }

    @Override
    public String getWidth() {
        return this.getCssText(23);
    }

    @Override
    public void setWidth(String width) throws DOMException {
        this.setCssText(23, width);
    }

    @Override
    public String getZIndex() {
        throw this.createUnsupportedPropertyException("zindex");
    }

    @Override
    public void setZIndex(String zIndex) throws DOMException {
        throw this.createUnsupportedPropertyException("zindex");
    }

    private DOMException createUnsupportedPropertyException(String property) {
        return new DOMException(9, property);
    }

    protected void writeCSSValue(DataOutputStream out, String propertyName, CSSValue value) throws IOException {
        int index = this.getPropertyIndex(propertyName);
        if (index == 3) {
            DataFormatValue.write(out, (DataFormatValue)value);
        } else {
            IOUtil.writeString((DataOutputStream)out, (String)value.getCssText());
        }
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        CSSValue value;
        int validCount = 0;
        int i = 0;
        while (i < 70) {
            value = this.getProperty(i);
            if (value != null) {
                ++validCount;
            }
            ++i;
        }
        IOUtil.writeInt((OutputStream)out, (int)validCount);
        i = 0;
        while (i < 70) {
            value = this.getProperty(i);
            if (value != null) {
                String propertyName = this.engine.getPropertyName(i);
                IOUtil.writeString((DataOutputStream)out, (String)propertyName);
                this.writeCSSValue(out, propertyName, value);
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void read(DataInputStream in) throws IOException {
        int validCount = IOUtil.readInt((InputStream)in);
        int i = 0;
        while (i < validCount) {
            String propertyCssText;
            String propertyName = IOUtil.readString((DataInputStream)in);
            int index = this.getPropertyIndex(propertyName);
            if (index == -1) {
                propertyCssText = IOUtil.readString((DataInputStream)in);
                if ("string-format".equalsIgnoreCase(propertyName)) {
                    this.setStringFormat(propertyCssText);
                } else if ("number-format".equalsIgnoreCase(propertyName)) {
                    this.setNumberFormat(propertyCssText);
                } else if ("sql-date-format".equalsIgnoreCase(propertyName)) {
                    this.setDateFormat(propertyCssText);
                } else if ("sql-time-format".equalsIgnoreCase(propertyName)) {
                    this.setTimeFormat(propertyCssText);
                } else if ("date-format".equalsIgnoreCase(propertyName)) {
                    this.setDateTimeFormat(propertyCssText);
                } else if ("background-image-type".equalsIgnoreCase(propertyName)) {
                    this.setBackgroundImageType(propertyCssText);
                } else if ("border-diagonal-number".equalsIgnoreCase(propertyName)) {
                    this.setDiagonalNumber(Integer.parseInt(propertyCssText));
                } else if ("border-diagonal-style".equalsIgnoreCase(propertyName)) {
                    this.setDiagonalStyle(propertyCssText);
                } else if ("border-diagonal-width".equalsIgnoreCase(propertyName)) {
                    this.setDiagonalWidth(propertyCssText);
                } else if ("border-diagonal-color".equalsIgnoreCase(propertyName)) {
                    this.setDiagonalColor(propertyCssText);
                } else if ("border-antidiagonal-number".equalsIgnoreCase(propertyName)) {
                    this.setAntidiagonalNumber(Integer.parseInt(propertyCssText));
                } else if ("border-antidiagonal-style".equalsIgnoreCase(propertyName)) {
                    this.setAntidiagonalStyle(propertyCssText);
                } else if ("border-antidiagonal-width".equalsIgnoreCase(propertyName)) {
                    this.setAntidiagonalWidth(propertyCssText);
                } else {
                    if (!"border-antidiagonal-color".equalsIgnoreCase(propertyName)) throw new IOException(propertyName + " not valid");
                    this.setAntidiagonalColor(propertyCssText);
                }
            } else if (index == 3) {
                DataFormatValue value = DataFormatValue.read(in);
                this.setProperty(index, value);
            } else {
                propertyCssText = IOUtil.readString((DataInputStream)in);
                this.setCssText(index, propertyCssText);
            }
            ++i;
        }
    }

    @Override
    public DataFormatValue getDataFormat() {
        return (DataFormatValue)this.getProperty(3);
    }

    @Override
    public void setDataFormat(DataFormatValue value) {
        this.setProperty(3, value);
    }

    @Override
    public int getDiagonalNumber() {
        return Integer.parseInt(this.getCssText(8));
    }

    @Override
    public void setDiagonalNumber(Integer number) {
        this.setCssText(8, number.toString());
    }

    @Override
    public String getDiagonalStyle() {
        return this.getCssText(22);
    }

    @Override
    public void setDiagonalStyle(String style) {
        this.setCssText(22, style);
    }

    @Override
    public String getDiagonalWidth() {
        return this.getCssText(11);
    }

    @Override
    public void setDiagonalWidth(String width) {
        this.setCssText(11, width);
    }

    @Override
    public String getDiagonalColor() {
        return this.getCssText(7);
    }

    @Override
    public void setDiagonalColor(String color) {
        this.setCssText(7, color);
    }

    @Override
    public int getAntidiagonalNumber() {
        return Integer.parseInt(this.getProperty(15).toString());
    }

    @Override
    public void setAntidiagonalNumber(Integer number) {
        this.setCssText(15, number.toString());
    }

    @Override
    public String getAntidiagonalStyle() {
        return this.getCssText(26);
    }

    @Override
    public void setAntidiagonalStyle(String style) {
        this.setCssText(26, style);
    }

    @Override
    public String getAntidiagonalWidth() {
        return this.getCssText(18);
    }

    @Override
    public void setAntidiagonalWidth(String width) {
        this.setCssText(18, width);
    }

    @Override
    public String getAntidiagonalColor() {
        return this.getCssText(14);
    }

    @Override
    public void setAntidiagonalColor(String color) {
        this.setCssText(14, color);
    }
}

