/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.style;

import com.lowagie.text.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.area.style.AreaConstants;
import org.eclipse.birt.report.engine.util.ResourceLocatorWrapper;
import org.eclipse.birt.report.engine.util.SvgFile;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.util.StructureRefUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSValue;

public class BackgroundImageInfo
extends AreaConstants {
    private static final int graphicDpi = 96;
    protected int xOffset = 0;
    protected int yOffset = 0;
    protected int repeatedMode;
    protected String url;
    protected String uri;
    protected String dataUrl;
    protected byte[] imageData;
    protected String sourceType;
    protected String mimeType;
    protected String fileExtension;
    protected int[] dpi = new int[]{96, 96};
    protected int width = 0;
    protected int height = 0;
    protected int widthMetricPt = 0;
    protected int heightMetricPt = 0;
    protected String propertyWidth = "auto";
    protected String propertyHeight = "auto";
    private static final String DATA_PROTOCOL = "data:";
    private static final String DATA_URL_BASE64 = ";base64,";
    private static final int BGI_DPI_DEFAULT = 96;
    private static final int BGI_DPI_METRIC_PT = 72000;
    private static final String[][] SUPPORTED_MIME_TYPES = new String[][]{{".jpg", "image/jpeg", "jpg"}, {".jpe", "image/jpeg", "jpg"}, {".jpeg", "image/jpeg", "jpg"}, {".tiff", "image/tiff", "tiff"}, {".svg", "image/svg+xml", "svg"}, {".png", "image/png", "png"}, {".gif", "image/gif", "gif"}};
    protected static final String BGI_SRC_TYPE_DEFAULT = "url";
    private Module module = null;
    private Image image = null;
    private ResourceLocatorWrapper rl = null;

    public BackgroundImageInfo(String url, int repeatedMode, int xOffset, int yOffset, int height, int width, ResourceLocatorWrapper rl, Module module, String sourceType, int dpi) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.repeatedMode = repeatedMode;
        this.width = width;
        this.height = height;
        this.url = url;
        this.rl = rl;
        this.module = module;
        this.sourceType = sourceType != null ? sourceType : BGI_SRC_TYPE_DEFAULT;
        this.prepareImageByteArray();
        if (dpi <= 0) {
            this.dpi = this.getImageDpi();
        } else {
            this.dpi[0] = dpi;
            this.dpi[1] = dpi;
        }
    }

    public BackgroundImageInfo(BackgroundImageInfo bgi) {
        this.xOffset = bgi.xOffset;
        this.yOffset = bgi.yOffset;
        this.repeatedMode = bgi.repeatedMode;
        this.width = bgi.width;
        this.height = bgi.height;
        this.url = bgi.url;
        this.imageData = bgi.imageData;
        this.image = bgi.image;
        this.rl = bgi.rl;
        this.dpi = bgi.dpi;
        this.sourceType = bgi.sourceType != null ? bgi.sourceType : BGI_SRC_TYPE_DEFAULT;
    }

    public BackgroundImageInfo(String url, CSSValue mode, int xOffset, int yOffset, int height, int width, ResourceLocatorWrapper rl, Module module) {
        this(url, mode != null ? (Integer)repeatMap.get(mode) : 3, xOffset, yOffset, height, width, rl, module, BGI_SRC_TYPE_DEFAULT, 0);
    }

    public BackgroundImageInfo(String url, CSSValue mode, int xOffset, int yOffset, int height, int width, ResourceLocatorWrapper rl, Module module, CSSValue sourceType) {
        this(url, mode != null ? (Integer)repeatMap.get(mode) : 3, xOffset, yOffset, height, width, rl, module, sourceType != null ? (String)bgiSourceTypeMap.get(sourceType) : BGI_SRC_TYPE_DEFAULT, 0);
    }

    public void setResourceLocator(ResourceLocatorWrapper rl) {
        this.rl = rl;
    }

    private void createDataUrl() {
        if (this.url != null && this.url.contains(DATA_PROTOCOL)) {
            this.dataUrl = this.url;
        } else if (this.imageData != null) {
            Base64.Encoder encoder = Base64.getEncoder();
            this.dataUrl = DATA_PROTOCOL + this.mimeType + DATA_URL_BASE64 + new String(encoder.encode(this.imageData), StandardCharsets.UTF_8);
        }
    }

    public String getDataUrl() {
        return this.dataUrl;
    }

    private void setMimeType(String mimeType) {
        if (mimeType != null) {
            this.mimeType = mimeType;
        } else if (this.url.contains(DATA_PROTOCOL)) {
            try {
                if (this.url.contains(";") && this.url.contains(DATA_PROTOCOL)) {
                    String partMimeType = this.url.split(";")[1];
                    this.mimeType = partMimeType.split(DATA_PROTOCOL)[0];
                }
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.mimeType = null;
            }
        } else {
            int index = 0;
            while (index < SUPPORTED_MIME_TYPES.length) {
                if (this.url.toLowerCase().contains(SUPPORTED_MIME_TYPES[index][0])) {
                    this.mimeType = SUPPORTED_MIME_TYPES[index][1];
                    this.fileExtension = SUPPORTED_MIME_TYPES[index][2];
                    break;
                }
                ++index;
            }
        }
    }

    private void prepareImageByteArray() {
        String mimeType;
        block35: {
            mimeType = null;
            if (this.sourceType.equals(BGI_SRC_TYPE_DEFAULT)) {
                if (this.url.contains(DATA_PROTOCOL)) {
                    String[] imageDataArray = this.url.split(DATA_URL_BASE64);
                    if (imageDataArray.length == 2 && this.url.contains(DATA_PROTOCOL)) {
                        try {
                            String imageDataBase64 = imageDataArray[1];
                            Base64.Decoder decoder = Base64.getDecoder();
                            this.imageData = decoder.decode(imageDataBase64);
                            this.mimeType = imageDataArray[0].split(DATA_PROTOCOL)[1];
                        }
                        catch (IndexOutOfBoundsException ioobe) {
                            this.imageData = null;
                            this.image = null;
                            this.mimeType = null;
                        }
                    } else {
                        this.imageData = null;
                        this.image = null;
                        this.mimeType = null;
                    }
                } else if (this.rl == null) {
                    InputStream in = null;
                    try {
                        try {
                            in = new URL(this.url).openStream();
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            byte[] buffer = new byte[1024];
                            int size = in.read(buffer);
                            while (size != -1) {
                                out.write(buffer, 0, size);
                                size = in.read(buffer);
                            }
                            this.imageData = out.toByteArray();
                            out.close();
                        }
                        catch (IOException ioe) {
                            this.imageData = null;
                            this.image = null;
                            this.mimeType = null;
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block35;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    try {
                        this.imageData = this.rl.findResource(new URL(this.url));
                    }
                    catch (MalformedURLException mue) {
                        this.imageData = null;
                        this.image = null;
                        this.mimeType = null;
                    }
                }
            }
        }
        if (this.sourceType.equals("embed") || this.imageData == null) {
            StructureDefn defn = (StructureDefn)MetaDataDictionary.getInstance().getStructure("EmbeddedImage");
            byte[] imageData = null;
            try {
                EmbeddedImage ei = (EmbeddedImage)StructureRefUtil.findStructure((Module)this.module, (StructureDefn)defn, (String)this.url);
                imageData = ei.getData(this.module);
                mimeType = ei.getType(this.module);
                if (this.sourceType.equals(BGI_SRC_TYPE_DEFAULT)) {
                    this.sourceType = "embed";
                }
            }
            catch (Exception te) {
                this.imageData = null;
                this.image = null;
                this.mimeType = null;
            }
            this.imageData = imageData;
        }
        if (this.imageData != null) {
            try {
                this.image = Image.getInstance((byte[])this.imageData);
            }
            catch (Exception e) {
                try {
                    this.imageData = SvgFile.transSvgToArray(new ByteArrayInputStream(this.imageData));
                    this.image = Image.getInstance((byte[])this.imageData);
                }
                catch (Exception te) {
                    this.imageData = null;
                    this.image = null;
                    this.mimeType = null;
                }
            }
        }
        this.setMimeType(mimeType);
        this.createDataUrl();
    }

    public Image getImageInstance() {
        return this.image;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int x) {
        this.xOffset = x;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int y) {
        this.yOffset = y;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getRepeatedMode() {
        return this.repeatedMode;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getUrl() {
        return this.url;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        if (this.uri == null) {
            return this.getDataUrl();
        }
        return this.uri;
    }

    public String getPropertyHeight() {
        return this.propertyHeight;
    }

    public String getPropertyWidth() {
        return this.propertyWidth;
    }

    public int getHeightMetricPt() {
        return this.heightMetricPt;
    }

    public void setHeightMetricPt(int height) {
        this.heightMetricPt = height;
    }

    public int getWidthMetricPt() {
        return this.widthMetricPt;
    }

    public void setWidthMetricPt(int width) {
        this.widthMetricPt = width;
    }

    public void setDpi(int[] dpi) {
        if (dpi.length != 2) {
            dpi = new int[]{96, 96};
        }
        this.dpi = dpi;
    }

    public int[] getDpi() {
        return this.dpi;
    }

    private int[] getImageDpi() {
        InputStream in = null;
        URL temp = null;
        ModuleHandle model = this.module.getModuleHandle();
        try {
            temp = URIUtil.isValidResourcePath((String)this.url) ? this.generateURL(model.getModuleHandle(), URIUtil.getLocalPath((String)this.url)) : this.generateURL(model.getModuleHandle(), this.url);
            if (temp != null) {
                in = temp.openStream();
            }
        }
        catch (IOException e) {
            in = null;
        }
        int[] dpi = this.getImageResolution(in);
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (dpi == null || dpi.length != 2) {
            dpi = new int[]{96, 96};
        } else {
            if (dpi[0] <= 0) {
                dpi[0] = 96;
            }
            if (dpi[1] <= 0) {
                dpi[1] = 96;
            }
        }
        return dpi;
    }

    private int[] getImageResolution(InputStream imageStream) {
        int[] dpi = new int[]{96, 96};
        if (imageStream != null) {
            try {
                ImageInputStream iis = ImageIO.createImageInputStream(imageStream);
                Iterator<ImageReader> i = ImageIO.getImageReaders(iis);
                ImageReader r = i.next();
                r.setInput(iis);
                r.read(0);
                IIOMetadata meta = r.getImageMetadata(0);
                if (meta != null) {
                    double mm2inch = 25.4;
                    Element node = (Element)meta.getAsTree("javax_imageio_1.0");
                    NodeList lst = node.getElementsByTagName("HorizontalPixelSize");
                    if (lst != null && lst.getLength() == 1) {
                        dpi[0] = (int)(mm2inch / (double)Float.parseFloat(((Element)lst.item(0)).getAttribute("value")));
                    }
                    if ((lst = node.getElementsByTagName("VerticalPixelSize")) != null && lst.getLength() == 1) {
                        dpi[1] = (int)(mm2inch / (double)Float.parseFloat(((Element)lst.item(0)).getAttribute("value")));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dpi;
    }

    public void setImageSize(IStyle style) {
        String propertyValue = null;
        int pxBackgroundHeight = 0;
        int pxBackgroundWidth = 0;
        double percentageHeight = 1.0;
        double percentageWidth = 1.0;
        if (style != null) {
            propertyValue = style.getPropertyValue("background-height");
            CSSValue dimensionValueHeight = style.getPropertyCSSValue("background-height");
            this.heightMetricPt = PropertyUtil.getDimensionValue(dimensionValueHeight);
            this.propertyHeight = propertyValue;
            if (!(propertyValue == null || "auto".equals(propertyValue) || "cover".equals(propertyValue) || "contain".equals(propertyValue))) {
                try {
                    if (propertyValue.endsWith("%")) {
                        percentageHeight = Double.parseDouble(propertyValue.replace("%", "")) / 100.0;
                    } else {
                        DimensionValue propertyBackgroundHeight = StringUtil.parse((String)propertyValue);
                        if (propertyBackgroundHeight.getUnits().equals("px")) {
                            pxBackgroundHeight = (int)propertyBackgroundHeight.getMeasure();
                        } else {
                            DimensionValue backgroundHeight = DimensionUtil.convertTo((double)propertyBackgroundHeight.getMeasure(), (String)propertyBackgroundHeight.getUnits(), (String)"in");
                            pxBackgroundHeight = (int)BackgroundImageInfo.inchToPixel(backgroundHeight.getMeasure());
                        }
                    }
                }
                catch (Exception propertyBackgroundHeight) {
                    // empty catch block
                }
            }
            propertyValue = style.getPropertyValue("background-width");
            CSSValue dimensionValueWidth = style.getPropertyCSSValue("background-width");
            this.widthMetricPt = PropertyUtil.getDimensionValue(dimensionValueWidth);
            this.propertyWidth = propertyValue;
            if (!(propertyValue == null || "auto".equals(propertyValue) || "cover".equals(propertyValue) || "contain".equals(propertyValue))) {
                try {
                    if (propertyValue.endsWith("%")) {
                        percentageWidth = Double.parseDouble(propertyValue.replace("%", "")) / 100.0;
                    } else {
                        DimensionValue propertyBackgroundWidth = StringUtil.parse((String)propertyValue);
                        if (propertyBackgroundWidth.getUnits().equals("px")) {
                            pxBackgroundWidth = (int)propertyBackgroundWidth.getMeasure();
                        } else {
                            DimensionValue backgroundWidth = DimensionUtil.convertTo((double)propertyBackgroundWidth.getMeasure(), (String)propertyBackgroundWidth.getUnits(), (String)"in");
                            pxBackgroundWidth = (int)BackgroundImageInfo.inchToPixel(backgroundWidth.getMeasure());
                        }
                    }
                }
                catch (Exception propertyBackgroundWidth) {
                    // empty catch block
                }
            }
        }
        this.height = pxBackgroundHeight;
        this.width = pxBackgroundWidth;
        double scaleFactorHeight = 1.0;
        double scaleFactorWidth = 1.0;
        if (this.image != null) {
            double inch;
            int dpi = this.dpi[0];
            double imageHeight = this.image.getHeight();
            double imageWidth = this.image.getWidth();
            if (dpi > 0) {
                if (this.height <= 0) {
                    inch = imageHeight / (double)dpi;
                    this.height = (int)BackgroundImageInfo.inchToPixel(inch);
                    this.heightMetricPt = (int)(inch * 72000.0);
                } else if (pxBackgroundHeight > 0 && pxBackgroundWidth <= 0) {
                    inch = imageHeight / (double)dpi;
                    scaleFactorWidth = (double)this.height / BackgroundImageInfo.inchToPixel(inch);
                }
            }
            if (dpi > 0) {
                if (this.width <= 0) {
                    inch = imageWidth / (double)dpi;
                    this.width = (int)BackgroundImageInfo.inchToPixel(inch);
                    this.widthMetricPt = (int)(inch * 72000.0);
                } else if (pxBackgroundHeight <= 0 && pxBackgroundWidth > 0) {
                    inch = imageWidth / (double)dpi;
                    scaleFactorHeight = (double)this.width / BackgroundImageInfo.inchToPixel(inch);
                }
            }
            if (dpi <= 0 && this.height <= 0 && this.width <= 0) {
                this.heightMetricPt = (int)(this.image.getHeight() * 72000.0f / 100.0f);
                this.height = this.heightMetricPt = (int)(this.image.getWidth() * 72000.0f / 100.0f);
                this.width = this.widthMetricPt;
            }
        }
        if (percentageHeight != 1.0 && percentageWidth == 1.0 && pxBackgroundWidth == 0) {
            percentageWidth = percentageHeight;
        } else if (percentageWidth != 1.0 && percentageHeight == 1.0 && pxBackgroundHeight == 0) {
            percentageHeight = percentageWidth;
        }
        this.height = (int)((double)this.height * percentageHeight * scaleFactorHeight);
        this.width = (int)((double)this.width * percentageWidth * scaleFactorWidth);
        this.heightMetricPt = (int)((double)this.heightMetricPt * percentageHeight * scaleFactorHeight);
        this.widthMetricPt = (int)((double)this.widthMetricPt * percentageWidth * scaleFactorWidth);
    }

    private URL generateURL(ModuleHandle designHandle, String uri) throws MalformedURLException {
        try {
            return new URL(uri);
        }
        catch (MalformedURLException e) {
            String path = URIUtil.getLocalPath((String)uri);
            if (path != null && designHandle != null) {
                return designHandle.findResource(path, 1);
            }
            return URI.create(uri).toURL();
        }
    }

    private static double inchToPixel(double inch) {
        return inch * 96.0;
    }
}

