/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.logging.Logger;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class SvgFile {
    private static Logger logger = Logger.getLogger(SvgFile.class.getName());
    private static final String URL_IMAGE_TYPE_SVG = "image/svg+xml";
    private static final String URL_PROTOCOL_TYPE_DATA = "data:";
    private static final String URL_PROTOCOL_TYPE_DATA_BASE = ";base64,";
    private static final String URL_PROTOCOL_TYPE_DATA_UTF8 = ";utf8,";
    static boolean isSvg = false;

    public static boolean isSvg(String uri) {
        isSvg = uri != null && uri.endsWith(".svg") || uri.toLowerCase().contains(URL_IMAGE_TYPE_SVG);
        return isSvg;
    }

    public static boolean isSvg(String mimeType, String uri, String extension) {
        isSvg = mimeType != null && mimeType.equalsIgnoreCase(URL_IMAGE_TYPE_SVG) || uri != null && (uri.toLowerCase().endsWith(".svg") || uri.toLowerCase().contains(URL_IMAGE_TYPE_SVG)) || extension != null && extension.toLowerCase().endsWith(".svg");
        return isSvg;
    }

    public static byte[] transSvgToArray(String uri) throws Exception {
        byte[] data = null;
        if (uri != null && uri.toLowerCase().contains(URL_PROTOCOL_TYPE_DATA) && uri.toLowerCase().contains(URL_IMAGE_TYPE_SVG)) {
            String encodedImg = null;
            String decodedImg = null;
            if (uri.toLowerCase().contains(URL_IMAGE_TYPE_SVG)) {
                String svgSplitter = "svg\\+xml,";
                if (uri.contains("image/svg+xml;utf8,")) {
                    svgSplitter = "svg\\+xml;utf8,";
                } else if (uri.contains("image/svg+xml;base64,")) {
                    svgSplitter = "svg\\+xml;base64,";
                }
                String[] uriParts = uri.split(svgSplitter);
                if (uriParts.length >= 2) {
                    decodedImg = encodedImg = uriParts[1];
                    if (uri.contains(URL_PROTOCOL_TYPE_DATA_BASE)) {
                        decodedImg = new String(Base64.getDecoder().decode(encodedImg.getBytes(StandardCharsets.UTF_8)));
                    }
                }
            }
            try {
                decodedImg = URLDecoder.decode(decodedImg, StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            data = SvgFile.transSvgToArray(new ByteArrayInputStream(decodedImg.getBytes()));
        } else {
            InputStream in = new URL(uri).openStream();
            Throwable throwable = null;
            Object var4_9 = null;
            try {
                try {
                    data = SvgFile.transSvgToArray(in);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return data;
    }

    public static byte[] transSvgToArray(InputStream inputStream) throws Exception {
        PNGTranscoder transcoder = new PNGTranscoder();
        TranscoderInput input = new TranscoderInput(inputStream);
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
        transcoder.transcode(input, output);
        ostream.flush();
        return ostream.toByteArray();
    }
}

