/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2CustomFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class CollapseFlowNodeFeature
extends AbstractBpmn2CustomFeature {
    private boolean hasDoneChanges = false;

    public CollapseFlowNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return "Collapse";
    }

    public String getDescription() {
        return "Collapse the Activity and hide contents";
    }

    public String getImageId() {
        return ImageProvider.IMG_16_COLLAPSE;
    }

    public boolean isAvailable(IContext context) {
        return true;
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)pes[0]);
            return FeatureSupport.isElementExpanded((BaseElement)be);
        }
        return false;
    }

    public void execute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            PictogramElement pe0 = pes[0];
            Object bo = this.getBusinessObjectForPictogramElement(pe0);
            if (pe0 instanceof ContainerShape && bo instanceof FlowNode) {
                ContainerShape containerShape = (ContainerShape)pe0;
                FlowNode flowNode = (FlowNode)bo;
                try {
                    BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((PictogramElement)pe0);
                    BPMNShape bpmnShape = DIUtils.findBPMNShape((BPMNDiagram)bpmnDiagram, (BaseElement)flowNode);
                    if (bpmnShape.isIsExpanded()) {
                        GraphicsAlgorithm ga = containerShape.getGraphicsAlgorithm();
                        FeatureSupport.updateExpandedSize((ContainerShape)containerShape);
                        IDimension newSize = FeatureSupport.getCollapsedSize((ContainerShape)containerShape);
                        int newWidth = newSize.getWidth();
                        int newHeight = newSize.getHeight();
                        int oldWidth = ga.getWidth();
                        int oldHeight = ga.getHeight();
                        ResizeShapeContext resizeContext = new ResizeShapeContext((Shape)containerShape);
                        resizeContext.setX(ga.getX() + oldWidth / 2 - newWidth / 2);
                        resizeContext.setY(ga.getY() + oldHeight / 2 - newHeight / 2);
                        resizeContext.setWidth(newWidth);
                        resizeContext.setHeight(newHeight);
                        FeatureSupport.setElementExpanded((PictogramElement)containerShape, (boolean)false);
                        IResizeShapeFeature resizeFeature = this.getFeatureProvider().getResizeShapeFeature((IResizeShapeContext)resizeContext);
                        resizeFeature.resizeShape((IResizeShapeContext)resizeContext);
                        bpmnShape.setIsExpanded(false);
                        UpdateContext updateContext = new UpdateContext((PictogramElement)containerShape);
                        updateContext.putProperty((Object)"force.update.all", (Object)Boolean.TRUE);
                        IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)updateContext);
                        updateFeature.update((IUpdateContext)updateContext);
                        FeatureSupport.updateConnections((IFeatureProvider)this.getFeatureProvider(), (List)FeatureSupport.getConnections((AnchorContainer)containerShape), (boolean)true);
                        this.getDiagramEditor().selectPictogramElements(new PictogramElement[0]);
                    }
                    this.hasDoneChanges = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean hasDoneChanges() {
        return this.hasDoneChanges;
    }
}

