/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddFeature;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.features.label.AddShapeLabelFeature;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public abstract class AddChoreographyActivityFeature<T extends ChoreographyActivity>
extends AbstractBpmn2AddFeature<T> {
    protected final IGaService gaService = Graphiti.getGaService();
    protected final IPeService peService = Graphiti.getPeService();

    public AddChoreographyActivityFeature(IFeatureProvider fp) {
        super(fp);
    }

    public IAddFeature getAddLabelFeature(IFeatureProvider fp) {
        return new AddShapeLabelFeature(fp);
    }

    public boolean canAdd(IAddContext context) {
        return context.getTargetContainer().equals(this.getDiagram());
    }

    public PictogramElement add(IAddContext context) {
        boolean isImport;
        ChoreographyActivity businessObject = (ChoreographyActivity)this.getBusinessObject(context);
        int x = context.getX();
        int y = context.getY();
        int width = this.getWidth(context);
        int height = this.getHeight(context);
        ContainerShape containerShape = this.peService.createContainerShape(context.getTargetContainer(), true);
        Rectangle invisibleRect = this.gaService.createInvisibleRectangle((PictogramElement)containerShape);
        this.gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRect, x, y, width, height);
        Shape rectShape = this.peService.createShape(containerShape, false);
        RoundedRectangle rect = this.gaService.createRoundedRectangle((GraphicsAlgorithmContainer)rectShape, 5, 5);
        StyleUtil.applyStyle((GraphicsAlgorithm)rect, (BaseElement)businessObject);
        this.gaService.setLocationAndSize((GraphicsAlgorithm)rect, 0, 0, width, height);
        this.link((PictogramElement)rectShape, businessObject);
        boolean bl = isImport = context.getProperty((Object)"is.importing") != null;
        if (isImport) {
            List participants = businessObject.getParticipantRefs();
            List allShapes = ModelUtil.getAllObjectsOfType((Resource)businessObject.eResource(), BPMNShape.class);
            ArrayList<BPMNShape> participantBandShapes = new ArrayList<BPMNShape>();
            BPMNShape choreoBpmnShape = null;
            for (BPMNShape bpmnShape : allShapes) {
                if (!businessObject.equals(bpmnShape.getBpmnElement())) continue;
                choreoBpmnShape = bpmnShape;
                break;
            }
            for (BPMNShape bpmnShape : allShapes) {
                if (!participants.contains(bpmnShape.getBpmnElement()) || !choreoBpmnShape.equals(bpmnShape.getChoreographyActivityShape())) continue;
                participantBandShapes.add(bpmnShape);
            }
        }
        ShapeDecoratorUtil.hideActivityMarker((ContainerShape)containerShape, (String)"activity.marker.expand");
        if (businessObject instanceof ChoreographyTask) {
            FeatureSupport.setPropertyValue((PropertyContainer)containerShape, (String)"choreography.message.ref.ids", (String)ChoreographyUtil.getMessageRefIds((ChoreographyTask)((ChoreographyTask)businessObject)));
        }
        this.peService.createChopboxAnchor((AnchorContainer)containerShape);
        this.createDIShape((Shape)containerShape, (BaseElement)businessObject, !isImport);
        this.decorateShape(context, containerShape, (BaseElement)businessObject);
        return containerShape;
    }
}

