/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.diagrams;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.Import;
import org.eclipse.bpmn2.impl.DefinitionsImpl;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractBpmn2PropertySection;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractListComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultListComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.ListCompositeColumnProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.ListCompositeContentProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.TableColumn;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.TextAndButtonObjectEditor;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.TextObjectEditor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.ImportUtil;
import org.eclipse.bpmn2.modeler.core.utils.NamespaceUtil;
import org.eclipse.bpmn2.modeler.ui.property.diagrams.Messages;
import org.eclipse.bpmn2.modeler.ui.property.dialogs.NamespacesEditingDialog;
import org.eclipse.bpmn2.modeler.ui.property.dialogs.SchemaImportDialog;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

public class DefinitionsPropertyComposite
extends DefaultDetailComposite {
    private NamespaceListComposite namespacesTable;

    public DefinitionsPropertyComposite(Composite parent, int style) {
        super(parent, style);
    }

    public DefinitionsPropertyComposite(AbstractBpmn2PropertySection section) {
        super(section);
    }

    public AbstractPropertiesProvider getPropertiesProvider(EObject object) {
        if (this.propertiesProvider == null) {
            this.propertiesProvider = new AbstractPropertiesProvider(object){
                String[] properties;
                {
                    this.properties = new String[]{"name", "targetNamespace", "typeLanguage", "expressionLanguage", "exporter", "exporterVersion", "imports", "namespaces", "rootElements#ItemDefinition", "relationships", "rootElements#PartnerEntity", "rootElements#PartnerRole", "rootElements#EndPoint", "rootElements#Resource", "rootElements#DataStore", "rootElements#Message", "rootElements#Error", "rootElements#Escalation", "rootElements#Signal", "rootElements#CorrelationProperty", "rootElements#Category"};
                }

                public String[] getProperties() {
                    return this.properties;
                }
            };
        }
        return this.propertiesProvider;
    }

    public void cleanBindings() {
        super.cleanBindings();
        this.namespacesTable = null;
    }

    protected Composite bindProperty(EObject be, String property) {
        if ("namespaces".equals(property)) {
            this.namespacesTable = new NamespaceListComposite((Composite)this);
            DefinitionsImpl definitions = (DefinitionsImpl)this.getBusinessObject();
            DocumentRoot root = (DocumentRoot)definitions.eContainer();
            this.namespacesTable.bindList((EObject)root, (EStructuralFeature)Bpmn2Package.eINSTANCE.getDocumentRoot_XMLNSPrefixMap());
            this.namespacesTable.setTitle("Namespaces");
            return this.namespacesTable;
        }
        return super.bindProperty(be, property);
    }

    protected AbstractListComposite bindList(EObject object, EStructuralFeature feature, EClass listItemClass) {
        if ("imports".equals(feature.getName())) {
            ImportListComposite importsTable = new ImportListComposite((Composite)this);
            EStructuralFeature importsFeature = object.eClass().getEStructuralFeature("imports");
            importsTable.bindList(object, importsFeature);
            return importsTable;
        }
        if ("relationships".equals(feature.getName())) {
            DefaultListComposite table = new DefaultListComposite((Composite)this, 28835840);
            table.bindList(this.getBusinessObject(), feature);
            return table;
        }
        return super.bindList(object, feature, listItemClass);
    }

    public class ImportDetailComposite
    extends DefaultDetailComposite {
        public ImportDetailComposite(Composite parent, int style) {
            super(parent, style);
        }

        public ImportDetailComposite(AbstractBpmn2PropertySection section) {
            super(section);
        }

        public void createBindings(EObject be) {
            final Import imp = (Import)be;
            Composite composite = this.getAttributesParent();
            EAttribute feature = null;
            String label = Messages.DefinitionsPropertyComposite_Prefix_Label;
            TextAndButtonObjectEditor editor = new TextAndButtonObjectEditor((AbstractDetailComposite)this, be, (EStructuralFeature)feature){

                protected void buttonClicked(int buttonId) {
                    IInputValidator validator = new IInputValidator(){

                        public String isValid(String newText) {
                            String ns = NamespaceUtil.getNamespaceForPrefix((Resource)imp.eResource(), (String)newText);
                            if (ns == null) {
                                return null;
                            }
                            return NLS.bind((String)Messages.DefinitionsPropertyComposite_Invalid_Duplicate, (Object)newText, (Object)ns);
                        }
                    };
                    String initialValue = this.getText();
                    InputDialog dialog = new InputDialog(ImportDetailComposite.this.getShell(), Messages.DefinitionsPropertyComposite_Prefix_Label, Messages.DefinitionsPropertyComposite_Prefix_Message, initialValue, validator);
                    if (dialog.open() == 0) {
                        this.setValue(dialog.getValue());
                    }
                }

                public boolean setValue(final Object value) {
                    final Resource resource = imp.eResource();
                    TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Resource)resource);
                    if (domain != null) {
                        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                            protected void doExecute() {
                                String prefix = text.getText();
                                NamespaceUtil.removeNamespaceForPrefix((Resource)resource, (String)prefix);
                                NamespaceUtil.addNamespace((Resource)resource, (String)((String)value), (String)imp.getNamespace());
                            }
                        });
                    }
                    this.setText((String)value);
                    return true;
                }

                protected String getText() {
                    return ImportDetailComposite.this.getNamespacePrefix();
                }
            };
            editor.createControl(composite, label);
            feature = Bpmn2Package.eINSTANCE.getImport_Namespace();
            label = ExtendedPropertiesProvider.getLabel((EObject)be, (EStructuralFeature)feature);
            editor = new TextObjectEditor((AbstractDetailComposite)this, be, (EStructuralFeature)feature);
            editor.createControl(composite, label);
            editor.setEditable(false);
            feature = Bpmn2Package.eINSTANCE.getImport_Location();
            label = ExtendedPropertiesProvider.getLabel((EObject)be, (EStructuralFeature)feature);
            editor = new TextObjectEditor((AbstractDetailComposite)this, be, (EStructuralFeature)feature);
            editor.createControl(composite, label);
            editor.setEditable(false);
            feature = Bpmn2Package.eINSTANCE.getImport_ImportType();
            label = ExtendedPropertiesProvider.getLabel((EObject)be, (EStructuralFeature)feature);
            editor = new TextObjectEditor((AbstractDetailComposite)this, be, (EStructuralFeature)feature);
            editor.createControl(composite, label);
            editor.setEditable(false);
        }

        private String getNamespacePrefix() {
            Import imp = (Import)this.businessObject;
            String prefix = NamespaceUtil.getPrefixForNamespace((Resource)imp.eResource(), (String)imp.getNamespace());
            if (prefix == null) {
                prefix = "";
            }
            return prefix;
        }
    }

    public class ImportListComposite
    extends DefaultListComposite {
        public ImportListComposite(Composite parent) {
            super(parent, 28835840);
        }

        public ListCompositeColumnProvider getColumnProvider(EObject object, EStructuralFeature feature) {
            if (this.columnProvider == null) {
                this.columnProvider = new ListCompositeColumnProvider((AbstractListComposite)this);
                TableColumn tableColumn = new TableColumn(object, null){

                    public String getHeaderText() {
                        return Messages.DefinitionsPropertyComposite_Prefix_Label;
                    }

                    public String getText(Object element) {
                        Import imp = (Import)element;
                        String prefix = NamespaceUtil.getPrefixForNamespace((Resource)imp.eResource(), (String)imp.getNamespace());
                        if (prefix != null) {
                            return prefix;
                        }
                        return "";
                    }

                    public CellEditor createCellEditor(Composite parent) {
                        CellEditor ce = null;
                        return ce;
                    }
                };
                this.columnProvider.add(tableColumn);
                this.columnProvider.add(new TableColumn(object, (EStructuralFeature)PACKAGE.getImport_Namespace())).setEditable(false);
                this.columnProvider.add(new TableColumn(object, (EStructuralFeature)PACKAGE.getImport_Location())).setEditable(false);
                this.columnProvider.add(new TableColumn(object, (EStructuralFeature)PACKAGE.getImport_ImportType())).setEditable(false);
            }
            return this.columnProvider;
        }

        protected EObject editListItem(EObject object, EStructuralFeature feature) {
            return super.editListItem(object, feature);
        }

        protected Object removeListItem(EObject object, EStructuralFeature feature, int index) {
            EList list = (EList)object.eGet(feature);
            Import imp = (Import)list.get(index);
            ImportUtil.removeImport((Import)imp);
            return null;
        }

        protected EObject addListItem(EObject object, EStructuralFeature feature) {
            Object[] result;
            TargetRuntime rt = TargetRuntime.getRuntime((EObject)object);
            SchemaImportDialog dialog = new SchemaImportDialog(this.getShell(), rt);
            if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
                ImportUtil importer = new ImportUtil();
                return importer.addImport(object, result[0]);
            }
            return null;
        }
    }

    public class NamespaceListComposite
    extends DefaultListComposite {
        public NamespaceListComposite(Composite parent) {
            super(parent, 0x980000);
        }

        protected EObject addListItem(EObject object, EStructuralFeature feature) {
            DocumentRoot root = (DocumentRoot)object;
            Map map = root.getXMLNSPrefixMap();
            NamespacesEditingDialog dialog = new NamespacesEditingDialog(this.getShell(), Messages.DefinitionsPropertyComposite_Create_Namespace_Title, map, "", "");
            if (dialog.open() == 0) {
                map.put(dialog.getPrefix(), dialog.getNamespace());
            }
            return null;
        }

        protected Object removeListItem(EObject object, EStructuralFeature feature, int index) {
            DocumentRoot root = (DocumentRoot)object;
            Map map = root.getXMLNSPrefixMap();
            for (Map.Entry entry : map.entrySet()) {
                if (index-- != 0) continue;
                map.remove(entry.getKey());
                break;
            }
            return null;
        }

        protected EObject editListItem(EObject object, EStructuralFeature feature) {
            IStructuredSelection sel = (IStructuredSelection)this.tableViewer.getSelection();
            Map.Entry entry = (Map.Entry)sel.getFirstElement();
            DocumentRoot root = (DocumentRoot)object;
            Map map = root.getXMLNSPrefixMap();
            NamespacesEditingDialog dialog = new NamespacesEditingDialog(this.getShell(), Messages.DefinitionsPropertyComposite_Change_Namespace_Title, map, (String)entry.getKey(), (String)entry.getValue());
            if (dialog.open() == 0) {
                map.put(dialog.getPrefix(), dialog.getNamespace());
            }
            return null;
        }

        public AbstractDetailComposite createDetailComposite(Class eClass, Composite parent, int style) {
            this.detailSection.setText(Messages.DefinitionsPropertyComposite_Namespace_Details_Title);
            DefaultDetailComposite composite = new DefaultDetailComposite(parent, 0){

                protected void bindAttribute(Composite parent, EObject object, EAttribute attribute, String label) {
                    if (attribute.getName().equals("key")) {
                        TextAndButtonObjectEditor editor = new TextAndButtonObjectEditor((AbstractDetailComposite)this, this.businessObject, (EStructuralFeature)attribute){

                            protected void buttonClicked(int buttonId) {
                                Map.Entry entry = (Map.Entry)this.object;
                                DocumentRoot root = (DocumentRoot)this.object.eContainer();
                                Map map = root.getXMLNSPrefixMap();
                                NamespacesEditingDialog dialog = new NamespacesEditingDialog(this.getShell(), Messages.DefinitionsPropertyComposite_Change_Namespace_Title, map, (String)entry.getKey(), null);
                                if (dialog.open() == 0) {
                                    this.setValue(dialog.getPrefix());
                                }
                            }

                            public boolean setValue(final Object result) {
                                if (result instanceof String && !((String)result).isEmpty()) {
                                    Map.Entry entry = (Map.Entry)this.object;
                                    final String oldKey = (String)entry.getKey();
                                    TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
                                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                                        protected void doExecute() {
                                            DocumentRoot root = (DocumentRoot)object.eContainer();
                                            Map map = root.getXMLNSPrefixMap();
                                            String value = (String)map.remove(oldKey);
                                            map.put((String)result, value);
                                        }
                                    });
                                    return true;
                                }
                                this.text.setText(ExtendedPropertiesProvider.getTextValue((EObject)this.object, (EStructuralFeature)this.feature));
                                return false;
                            }
                        };
                        editor.createControl(parent, "Prefix");
                    } else {
                        TextObjectEditor editor = new TextObjectEditor((AbstractDetailComposite)this, this.businessObject, (EStructuralFeature)attribute);
                        editor.createControl(parent, Messages.DefinitionsPropertyComposite_Namespace_Label);
                    }
                }
            };
            return composite;
        }

        public ListCompositeContentProvider getContentProvider(EObject object, EStructuralFeature feature, EList<EObject> list) {
            if (this.contentProvider == null) {
                this.contentProvider = new ListCompositeContentProvider((AbstractListComposite)this, object, feature, list){

                    public Object[] getElements(Object inputElement) {
                        ArrayList<Map.Entry> elements = new ArrayList<Map.Entry>();
                        EcoreEMap map = (EcoreEMap)inputElement;
                        for (Map.Entry entry : map.entrySet()) {
                            elements.add(entry);
                        }
                        return elements.toArray(new EObject[elements.size()]);
                    }
                };
            }
            return this.contentProvider;
        }

        protected int createColumnProvider(EObject theobject, EStructuralFeature thefeature) {
            if (this.columnProvider == null) {
                this.columnProvider = this.getColumnProvider(theobject, thefeature);
            }
            return this.columnProvider.getColumns().size();
        }

        public ListCompositeColumnProvider getColumnProvider(EObject object, EStructuralFeature feature) {
            if (this.columnProvider == null) {
                this.columnProvider = new ListCompositeColumnProvider((AbstractListComposite)this);
                this.columnProvider.addRaw((TableColumn)new NamespacesTableColumn(object, 0));
                this.columnProvider.addRaw((TableColumn)new NamespacesTableColumn(object, 1));
            }
            return this.columnProvider;
        }

        public class NamespacesTableColumn
        extends TableColumn {
            int columnIndex;

            public NamespacesTableColumn(EObject object, int columnIndex) {
                super(object, null);
                this.columnIndex = columnIndex;
            }

            public String getProperty() {
                return this.getHeaderText();
            }

            public String getHeaderText() {
                if (this.columnIndex == 0) {
                    return Messages.DefinitionsPropertyComposite_Prefix_Label;
                }
                return Messages.DefinitionsPropertyComposite_Namespace_Label;
            }

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                if (this.columnIndex == 0) {
                    return (String)entry.getKey();
                }
                return (String)entry.getValue();
            }
        }
    }
}

