/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingclient.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingclient.internal.ExecutableToolingClient;
import com.gradleware.tooling.toolingclient.internal.InspectableRequest;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProgressListener;

abstract class BaseRequest<T, SELF extends BaseRequest<T, SELF>>
implements InspectableRequest<T> {
    private final ExecutableToolingClient toolingClient;
    private boolean colorOutput;
    private OutputStream standardOutput;
    private OutputStream standardError;
    private InputStream standardInput;
    private File javaHomeDir;
    private ImmutableList<String> jvmArguments;
    private ImmutableList<String> arguments;
    private ImmutableList<ProgressListener> progressListeners;
    private ImmutableList<org.gradle.tooling.events.ProgressListener> typedProgressListeners;
    private CancellationToken cancellationToken;

    BaseRequest(ExecutableToolingClient toolingClient) {
        this.toolingClient = (ExecutableToolingClient)Preconditions.checkNotNull((Object)toolingClient);
        this.jvmArguments = ImmutableList.of();
        this.arguments = ImmutableList.of();
        this.progressListeners = ImmutableList.of();
        this.typedProgressListeners = ImmutableList.of();
        this.cancellationToken = GradleConnector.newCancellationTokenSource().token();
    }

    ExecutableToolingClient getToolingClient() {
        return this.toolingClient;
    }

    public SELF colorOutput(boolean colorOutput) {
        this.colorOutput = colorOutput;
        return this.getThis();
    }

    @Override
    public boolean isColorOutput() {
        return this.colorOutput;
    }

    public SELF standardOutput(OutputStream outputStream) {
        this.standardOutput = outputStream;
        return this.getThis();
    }

    @Override
    public OutputStream getStandardOutput() {
        return this.standardOutput;
    }

    public SELF standardError(OutputStream outputStream) {
        this.standardError = outputStream;
        return this.getThis();
    }

    @Override
    public OutputStream getStandardError() {
        return this.standardError;
    }

    public SELF standardInput(InputStream inputStream) {
        this.standardInput = inputStream;
        return this.getThis();
    }

    @Override
    public InputStream getStandardInput() {
        return this.standardInput;
    }

    public SELF javaHomeDir(File javaHomeDir) {
        this.javaHomeDir = javaHomeDir;
        return this.getThis();
    }

    @Override
    public File getJavaHomeDir() {
        return this.javaHomeDir;
    }

    public SELF jvmArguments(String ... jvmArguments) {
        this.jvmArguments = ImmutableList.copyOf((Object[])jvmArguments);
        return this.getThis();
    }

    @Override
    public String[] getJvmArguments() {
        return (String[])this.jvmArguments.toArray((Object[])new String[this.jvmArguments.size()]);
    }

    public SELF arguments(String ... arguments) {
        this.arguments = ImmutableList.copyOf((Object[])arguments);
        return this.getThis();
    }

    @Override
    public String[] getArguments() {
        return (String[])this.arguments.toArray((Object[])new String[this.arguments.size()]);
    }

    public SELF progressListeners(ProgressListener ... listeners) {
        this.progressListeners = ImmutableList.copyOf((Object[])listeners);
        return this.getThis();
    }

    public SELF addProgressListeners(ProgressListener ... listeners) {
        this.progressListeners = ImmutableList.builder().addAll(this.progressListeners).addAll((Iterable)ImmutableList.copyOf((Object[])listeners)).build();
        return this.getThis();
    }

    @Override
    public ProgressListener[] getProgressListeners() {
        return (ProgressListener[])this.progressListeners.toArray((Object[])new ProgressListener[this.progressListeners.size()]);
    }

    public SELF typedProgressListeners(org.gradle.tooling.events.ProgressListener ... listeners) {
        this.typedProgressListeners = ImmutableList.copyOf((Object[])listeners);
        return this.getThis();
    }

    public SELF addTypedProgressListeners(org.gradle.tooling.events.ProgressListener ... listeners) {
        this.typedProgressListeners = ImmutableList.builder().addAll(this.typedProgressListeners).addAll((Iterable)ImmutableList.copyOf((Object[])listeners)).build();
        return this.getThis();
    }

    @Override
    public org.gradle.tooling.events.ProgressListener[] getTypedProgressListeners() {
        return (org.gradle.tooling.events.ProgressListener[])this.typedProgressListeners.toArray((Object[])new org.gradle.tooling.events.ProgressListener[this.typedProgressListeners.size()]);
    }

    public SELF cancellationToken(CancellationToken cancellationToken) {
        this.cancellationToken = (CancellationToken)Preconditions.checkNotNull((Object)cancellationToken);
        return this.getThis();
    }

    @Override
    public CancellationToken getCancellationToken() {
        return this.cancellationToken;
    }

    <S, S_SELF extends BaseRequest<S, S_SELF>> S_SELF copy(BaseRequest<S, S_SELF> request) {
        return (S_SELF)((BaseRequest)((BaseRequest)((BaseRequest)((BaseRequest)((BaseRequest)((BaseRequest)((BaseRequest)((BaseRequest)((BaseRequest)request.colorOutput(this.isColorOutput())).standardOutput(this.getStandardOutput())).standardError(this.getStandardError())).standardInput(this.getStandardInput())).javaHomeDir(this.getJavaHomeDir())).jvmArguments(this.getJvmArguments())).arguments(this.getArguments())).progressListeners(this.getProgressListeners())).typedProgressListeners(this.getTypedProgressListeners())).cancellationToken(this.getCancellationToken());
    }

    abstract SELF getThis();
}

