/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.configuration;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.io.File;
import java.io.IOException;
import org.eclipse.buildship.core.util.configuration.FixedRequestAttributesBuilder;

public final class ProjectConfiguration {
    private final File rootProjectDirectory;
    private final GradleDistribution gradleDistribution;

    private ProjectConfiguration(File rootProjectDirectory, GradleDistribution gradleDistribution) {
        this.rootProjectDirectory = ProjectConfiguration.canonicalize(rootProjectDirectory);
        this.gradleDistribution = (GradleDistribution)Preconditions.checkNotNull((Object)gradleDistribution);
    }

    private static File canonicalize(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public FixedRequestAttributes toRequestAttributes(ConversionStrategy strategy) {
        return strategy.getFixedRequestAttributesBuilder(this.rootProjectDirectory).gradleDistribution(this.gradleDistribution).build();
    }

    public File getRootProjectDirectory() {
        return this.rootProjectDirectory;
    }

    public GradleDistribution getGradleDistribution() {
        return this.gradleDistribution;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProjectConfiguration) {
            ProjectConfiguration other = (ProjectConfiguration)obj;
            return Objects.equal((Object)this.rootProjectDirectory, (Object)other.rootProjectDirectory) && Objects.equal((Object)this.gradleDistribution, (Object)other.gradleDistribution);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.rootProjectDirectory, this.gradleDistribution});
    }

    public static ProjectConfiguration from(FixedRequestAttributes build, OmniEclipseProject project) {
        return ProjectConfiguration.from(build.getProjectDir(), build.getGradleDistribution());
    }

    public static ProjectConfiguration from(File rootProjectDir, GradleDistribution gradleDistribution) {
        return new ProjectConfiguration(rootProjectDir, gradleDistribution);
    }

    public static enum ConversionStrategy {
        MERGE_WORKSPACE_SETTINGS{

            @Override
            protected FixedRequestAttributesBuilder getFixedRequestAttributesBuilder(File rootDir) {
                return FixedRequestAttributesBuilder.fromWorkspaceSettings(rootDir);
            }
        }
        ,
        IGNORE_WORKSPACE_SETTINGS{

            @Override
            protected FixedRequestAttributesBuilder getFixedRequestAttributesBuilder(File rootDir) {
                return FixedRequestAttributesBuilder.fromEmptySettings(rootDir);
            }
        };


        protected abstract FixedRequestAttributesBuilder getFixedRequestAttributesBuilder(File var1);
    }
}

