/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.adapter;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.impldep.net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
class TypeInspector {
    private final Set<Class<?>> stopAt = new HashSet();
    private final Map<Class<?>, Set<Class<?>>> inspected = new HashMap();

    public TypeInspector() {
        this.stopAt.add(List.class);
        this.stopAt.add(Set.class);
        this.stopAt.add(Collection.class);
        this.stopAt.add(Map.class);
    }

    public Set<Class<?>> getReachableTypes(Class<?> type) {
        Set<Class<?>> types = this.inspected.get(type);
        if (types == null) {
            types = new HashSet();
            this.visit(type, types);
            this.inspected.put(type, types);
        }
        return types;
    }

    private void visit(Class<?> type, Set<Class<?>> types) {
        if (type.isArray()) {
            this.visit(type.getComponentType(), types);
            return;
        }
        if (!type.isInterface() || !types.add(type) || this.stopAt.contains(type)) {
            return;
        }
        for (Type superType : type.getGenericInterfaces()) {
            this.visit(superType, types);
        }
        for (Method method : type.getDeclaredMethods()) {
            this.visit(method.getGenericReturnType(), types);
            for (TypeVariable<Method> typeVariable : method.getTypeParameters()) {
                this.visit(typeVariable, types);
            }
        }
    }

    private void visit(Type type, Set<Class<?>> types) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        block4: {
                            if (!(type instanceof Class)) break block4;
                            this.visit((Class)type, types);
                            break block5;
                        }
                        if (!(type instanceof ParameterizedType)) break block6;
                        ParameterizedType parameterizedType = (ParameterizedType)type;
                        this.visit(parameterizedType.getRawType(), types);
                        for (Type typeArg : parameterizedType.getActualTypeArguments()) {
                            this.visit(typeArg, types);
                        }
                        break block5;
                    }
                    if (!(type instanceof WildcardType)) break block7;
                    WildcardType wildcardType = (WildcardType)type;
                    for (Type bound : wildcardType.getUpperBounds()) {
                        this.visit(bound, types);
                    }
                    for (Type bound : wildcardType.getLowerBounds()) {
                        this.visit(bound, types);
                    }
                    break block5;
                }
                if (!(type instanceof GenericArrayType)) break block8;
                GenericArrayType arrayType = (GenericArrayType)type;
                this.visit(arrayType.getGenericComponentType(), types);
                break block5;
            }
            if (!(type instanceof TypeVariable)) break block5;
            TypeVariable typeVariable = (TypeVariable)type;
            for (Type bound : typeVariable.getBounds()) {
                this.visit(bound, types);
            }
        }
    }
}

