/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.launch;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import com.gradleware.tooling.toolingutils.binding.Validator;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.i18n.CoreMessages;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.util.gradle.GradleDistributionValidator;
import org.eclipse.buildship.core.util.gradle.GradleDistributionWrapper;
import org.eclipse.buildship.core.util.gradle.PublishedGradleVersionsWrapper;
import org.eclipse.buildship.ui.PluginImage;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.buildship.ui.i18n.UiMessages;
import org.eclipse.buildship.ui.launch.LaunchMessages;
import org.eclipse.buildship.ui.util.file.DirectoryDialogSelectionListener;
import org.eclipse.buildship.ui.util.font.FontUtils;
import org.eclipse.buildship.ui.util.selection.Enabler;
import org.eclipse.buildship.ui.util.widget.ButtonUtils;
import org.eclipse.buildship.ui.util.widget.UiBuilder;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gradle.util.GradleVersion;

public final class GradleDistributionTab
extends AbstractLaunchConfigurationTab {
    private final Font defaultFont = FontUtils.getDefaultDialogFont();
    private final UiBuilder.UiBuilderFactory builderFactory = new UiBuilder.UiBuilderFactory(this.defaultFont);
    private final Validator<GradleDistributionWrapper> gradleDistributionValidator = GradleDistributionValidator.gradleDistributionValidator();
    private final PublishedGradleVersionsWrapper publishedGradleVersions = CorePlugin.publishedGradleVersions();
    private Text localInstallationDirText;
    private Text remoteDistributionUriText;
    private Combo gradleVersionCombo;
    private Button useAutomaticOption;
    private Button useGradleWrapperOption;
    private Button useLocalInstallationDirOption;
    private Button useRemoteDistributionUriOption;
    private Button useGradleVersionOption;
    private List<Button> allRadioButtons;
    private final SelectionListener optionSelectionChangedListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (!GradleDistributionTab.this.disableUpdateDialog) {
                GradleDistributionTab.this.updateLaunchConfigurationDialog();
            }
        }
    };
    private final ModifyListener textChangedListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (!GradleDistributionTab.this.disableUpdateDialog) {
                GradleDistributionTab.this.updateLaunchConfigurationDialog();
            }
        }
    };
    private boolean disableUpdateDialog = false;

    public String getName() {
        return LaunchMessages.Tab_Name_GradleDistribution;
    }

    public Image getImage() {
        return PluginImages.RUN_CONFIG_GRADLE_DISTRIBUTION.withState(PluginImage.ImageState.ENABLED).getImage();
    }

    public void createControl(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        page.setLayout((Layout)layout);
        this.setControl((Control)page);
        Group gradleDistributionGroup = this.createGroup(page, CoreMessages.RunConfiguration_Label_GradleDistribution + ":");
        this.createGradleDistributionSelectionControl(gradleDistributionGroup);
    }

    private Group createGroup(Composite parent, String groupName) {
        Group group = new Group(parent, 0);
        group.setText(groupName);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        return group;
    }

    private void createGradleDistributionSelectionControl(Group container) {
        this.useAutomaticOption = this.builderFactory.newRadio((Composite)container).alignLeft().text(CoreMessages.GradleDistribution_Label_FromImportSettings).control();
        this.useAutomaticOption.setToolTipText(CoreMessages.GradleDistribution_Label_FromImportSettings_Tooltip);
        this.useAutomaticOption.setSelection(true);
        this.builderFactory.span((Composite)container);
        this.builderFactory.span((Composite)container);
        this.useGradleWrapperOption = this.builderFactory.newRadio((Composite)container).alignLeft().text(CoreMessages.GradleDistribution_Label_GradleWrapper).control();
        this.builderFactory.span((Composite)container);
        this.builderFactory.span((Composite)container);
        this.useLocalInstallationDirOption = this.builderFactory.newRadio((Composite)container).alignLeft().text(CoreMessages.GradleDistribution_Label_LocalInstallationDirectory).control();
        this.localInstallationDirText = this.builderFactory.newText((Composite)container).alignFillHorizontal().disabled().control();
        Button localInstallationDirBrowseButton = this.builderFactory.newButton((Composite)container).alignLeft().disabled().text(UiMessages.Button_Label_Browse).control();
        localInstallationDirBrowseButton.addSelectionListener((SelectionListener)new DirectoryDialogSelectionListener(container.getShell(), (Widget)this.localInstallationDirText, CoreMessages.GradleDistribution_Label_LocalInstallationDirectory));
        this.useRemoteDistributionUriOption = this.builderFactory.newRadio((Composite)container).alignLeft().text(CoreMessages.GradleDistribution_Label_RemoteDistributionUri).control();
        this.remoteDistributionUriText = this.builderFactory.newText((Composite)container).alignFillHorizontal().disabled().control();
        this.builderFactory.span((Composite)container);
        this.useGradleVersionOption = this.builderFactory.newRadio((Composite)container).alignLeft().text(CoreMessages.GradleDistribution_Label_SpecificGradleVersion).control();
        this.gradleVersionCombo = this.builderFactory.newCombo((Composite)container).alignLeft().disabled().control();
        this.gradleVersionCombo.setSize(150, this.gradleVersionCombo.getSize().y);
        this.gradleVersionCombo.setItems(this.getGradleVersions());
        this.builderFactory.span((Composite)container);
        this.localInstallationDirText.addModifyListener(this.textChangedListener);
        this.remoteDistributionUriText.addModifyListener(this.textChangedListener);
        this.gradleVersionCombo.addModifyListener(this.textChangedListener);
        this.useAutomaticOption.addSelectionListener(this.optionSelectionChangedListener);
        this.useGradleWrapperOption.addSelectionListener(this.optionSelectionChangedListener);
        this.useLocalInstallationDirOption.addSelectionListener(this.optionSelectionChangedListener);
        this.useRemoteDistributionUriOption.addSelectionListener(this.optionSelectionChangedListener);
        this.useGradleVersionOption.addSelectionListener(this.optionSelectionChangedListener);
        new Enabler(this.useAutomaticOption).enables(new Control[0]);
        new Enabler(this.useGradleWrapperOption).enables(new Control[0]);
        new Enabler(this.useLocalInstallationDirOption).enables(new Control[]{this.localInstallationDirText, localInstallationDirBrowseButton});
        new Enabler(this.useRemoteDistributionUriOption).enables(new Control[]{this.remoteDistributionUriText});
        new Enabler(this.useGradleVersionOption).enables(new Control[]{this.gradleVersionCombo});
        this.allRadioButtons = ImmutableList.of((Object)this.useAutomaticOption, (Object)this.useGradleWrapperOption, (Object)this.useLocalInstallationDirOption, (Object)this.useRemoteDistributionUriOption, (Object)this.useGradleVersionOption);
    }

    private String[] getGradleVersions() {
        return (String[])FluentIterable.from((Iterable)this.publishedGradleVersions.getVersions()).transform((Function)new Function<GradleVersion, String>(){

            public String apply(GradleVersion gradleVersion) {
                return gradleVersion.getVersion();
            }
        }).toArray(String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeFrom(ILaunchConfiguration configuration) {
        this.disableUpdateDialog = true;
        try {
            GradleRunConfigurationAttributes configurationAttributes = GradleRunConfigurationAttributes.from((ILaunchConfiguration)configuration);
            if (configurationAttributes.isUseGradleDistributionFromImport()) {
                this.setSelectionToAutomatic();
            } else {
                this.setSelection(GradleDistributionWrapper.from((GradleDistribution)configurationAttributes.getGradleDistribution()));
            }
        }
        finally {
            this.disableUpdateDialog = false;
        }
    }

    private void setSelectionToAutomatic() {
        this.resetValues();
        this.updateSelectedState(this.useAutomaticOption, this.allRadioButtons);
    }

    private void resetValues() {
        this.localInstallationDirText.setText("");
        this.remoteDistributionUriText.setText("");
        if (this.gradleVersionCombo.getItemCount() > 0) {
            this.gradleVersionCombo.select(0);
        } else {
            this.gradleVersionCombo.setText("");
        }
    }

    private void setSelection(GradleDistributionWrapper wrapper) {
        this.resetValues();
        GradleDistributionWrapper.DistributionType type = wrapper.getType();
        String configuration = Strings.nullToEmpty((String)wrapper.getConfiguration());
        switch (type) {
            case WRAPPER: {
                this.updateSelectedState(this.useGradleWrapperOption, this.allRadioButtons);
                break;
            }
            case LOCAL_INSTALLATION: {
                this.updateSelectedState(this.useLocalInstallationDirOption, this.allRadioButtons);
                this.localInstallationDirText.setText(configuration);
                break;
            }
            case REMOTE_DISTRIBUTION: {
                this.updateSelectedState(this.useRemoteDistributionUriOption, this.allRadioButtons);
                this.remoteDistributionUriText.setText(configuration);
                break;
            }
            case VERSION: {
                this.updateSelectedState(this.useGradleVersionOption, this.allRadioButtons);
                this.updateVersionSelection(configuration);
                break;
            }
            default: {
                throw new GradlePluginsRuntimeException("Unrecognized Gradle distribution type: " + type);
            }
        }
    }

    private void updateSelectedState(Button selectedRadioButton, List<Button> allRadioButtons) {
        for (Button radioButton : allRadioButtons) {
            boolean selected = radioButton.equals(selectedRadioButton);
            ButtonUtils.setSelectionAndFireEvent(radioButton, selected);
            if (!selected) continue;
            radioButton.setFocus();
        }
    }

    private void updateVersionSelection(String version) {
        for (int i = 0; i < this.gradleVersionCombo.getItemCount(); ++i) {
            if (!this.gradleVersionCombo.getItem(i).equals(version)) continue;
            this.gradleVersionCombo.select(i);
            return;
        }
        int index = this.gradleVersionCombo.getItemCount();
        this.gradleVersionCombo.add(version, index);
        this.gradleVersionCombo.select(index);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.useAutomaticOption.getSelection()) {
            GradleRunConfigurationAttributes.applyUseGradleDistributionFromImport((boolean)true, (ILaunchConfigurationWorkingCopy)configuration);
        } else {
            GradleRunConfigurationAttributes.applyUseGradleDistributionFromImport((boolean)false, (ILaunchConfigurationWorkingCopy)configuration);
            GradleRunConfigurationAttributes.applyGradleDistribution((GradleDistribution)this.getSelection().toGradleDistribution(), (ILaunchConfigurationWorkingCopy)configuration);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (!this.useAutomaticOption.getSelection()) {
            GradleDistributionWrapper gradleDistribution = this.getSelection();
            Optional error = this.gradleDistributionValidator.validate((Object)gradleDistribution);
            this.setErrorMessage((String)error.orNull());
            return !error.isPresent();
        }
        return true;
    }

    private GradleDistributionWrapper getSelection() {
        if (this.useGradleWrapperOption.getSelection()) {
            return GradleDistributionWrapper.from((GradleDistributionWrapper.DistributionType)GradleDistributionWrapper.DistributionType.WRAPPER, null);
        }
        if (this.useLocalInstallationDirOption.getSelection()) {
            return GradleDistributionWrapper.from((GradleDistributionWrapper.DistributionType)GradleDistributionWrapper.DistributionType.LOCAL_INSTALLATION, (String)this.localInstallationDirText.getText());
        }
        if (this.useRemoteDistributionUriOption.getSelection()) {
            return GradleDistributionWrapper.from((GradleDistributionWrapper.DistributionType)GradleDistributionWrapper.DistributionType.REMOTE_DISTRIBUTION, (String)this.remoteDistributionUriText.getText());
        }
        if (this.useGradleVersionOption.getSelection()) {
            return this.getGradleDistributionWrapper();
        }
        throw new IllegalStateException("No Gradle distribution selected.");
    }

    private GradleDistributionWrapper getGradleDistributionWrapper() {
        int selectionIndex = this.gradleVersionCombo.getSelectionIndex();
        return GradleDistributionWrapper.from((GradleDistributionWrapper.DistributionType)GradleDistributionWrapper.DistributionType.VERSION, (String)Strings.emptyToNull((String)(selectionIndex == -1 || !Strings.isNullOrEmpty((String)this.gradleVersionCombo.getText()) ? this.gradleVersionCombo.getText() : this.gradleVersionCombo.getItem(selectionIndex))));
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void dispose() {
        this.defaultFont.dispose();
        super.dispose();
    }
}

