/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.buildship.core.util.variable.ExpressionUtils;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.view.task.ProjectNode;
import org.eclipse.buildship.ui.view.task.ProjectTaskNode;
import org.eclipse.buildship.ui.view.task.TaskNode;
import org.eclipse.buildship.ui.view.task.TaskSelectorNode;
import org.eclipse.buildship.ui.view.task.TaskViewActionStateRules;
import org.eclipse.core.resources.IProject;

public final class TaskNodeSelectionUtils {
    private TaskNodeSelectionUtils() {
    }

    public static boolean isValidRunConfiguration(NodeSelection selection) {
        return TaskViewActionStateRules.taskScopedTaskExecutionActionsEnabledFor(selection) || TaskViewActionStateRules.projectScopedTaskExecutionActionsEnabledFor(selection);
    }

    public static Optional<GradleRunConfigurationAttributes> tryGetRunConfigurationAttributes(NodeSelection selection) {
        if (TaskNodeSelectionUtils.isValidRunConfiguration(selection)) {
            return Optional.of((Object)TaskNodeSelectionUtils.getRunConfigurationAttributes(selection));
        }
        return Optional.absent();
    }

    public static GradleRunConfigurationAttributes getRunConfigurationAttributes(NodeSelection selection) {
        Preconditions.checkNotNull((Object)selection);
        Optional<FixedRequestAttributes> requestAttributes = TaskNodeSelectionUtils.getFixedRequestAttributes(selection);
        ImmutableList<String> tasks = TaskNodeSelectionUtils.getTaskPathStrings(selection);
        String projectDirectoryExpression = TaskNodeSelectionUtils.getProjectDirectoryExpression(selection);
        GradleDistribution gradleDistribution = requestAttributes.isPresent() ? ((FixedRequestAttributes)requestAttributes.get()).getGradleDistribution() : GradleDistribution.fromBuild();
        String javaHome = requestAttributes.isPresent() ? (String)FileUtils.getAbsolutePath((File)((FixedRequestAttributes)requestAttributes.get()).getJavaHome()).orNull() : null;
        ImmutableList jvmArguments = requestAttributes.isPresent() ? ((FixedRequestAttributes)requestAttributes.get()).getJvmArguments() : ImmutableList.of();
        ImmutableList arguments = requestAttributes.isPresent() ? ((FixedRequestAttributes)requestAttributes.get()).getArguments() : ImmutableList.of();
        boolean showExecutionView = true;
        boolean showConsoleView = true;
        return GradleRunConfigurationAttributes.with(tasks, (String)projectDirectoryExpression, (GradleDistribution)gradleDistribution, (String)javaHome, (List)jvmArguments, (List)arguments, (boolean)showExecutionView, (boolean)showConsoleView, (boolean)true);
    }

    private static Optional<FixedRequestAttributes> getFixedRequestAttributes(NodeSelection selection) {
        if (TaskViewActionStateRules.taskScopedTaskExecutionActionsEnabledFor(selection)) {
            TaskNode taskNode = selection.getFirstElement(TaskNode.class);
            return TaskNodeSelectionUtils.getFixedRequestAttributes(taskNode.getParentProjectNode());
        }
        if (TaskViewActionStateRules.projectScopedTaskExecutionActionsEnabledFor(selection)) {
            ProjectNode projectNode = selection.getFirstElement(ProjectNode.class);
            return TaskNodeSelectionUtils.getFixedRequestAttributes(projectNode);
        }
        throw new IllegalStateException("Unsupported selection: " + selection);
    }

    private static Optional<FixedRequestAttributes> getFixedRequestAttributes(ProjectNode projectNode) {
        Optional<IProject> workspaceProject = projectNode.getWorkspaceProject();
        if (workspaceProject.isPresent() && GradleProjectNature.isPresentOn((IProject)((IProject)workspaceProject.get()))) {
            ProjectConfiguration projectConfiguration = CorePlugin.projectConfigurationManager().readProjectConfiguration((IProject)workspaceProject.get());
            return Optional.of((Object)projectConfiguration.toRequestAttributes(ProjectConfiguration.ConversionStrategy.IGNORE_WORKSPACE_SETTINGS));
        }
        return Optional.absent();
    }

    private static ImmutableList<String> getTaskPathStrings(NodeSelection selection) {
        if (TaskViewActionStateRules.taskScopedTaskExecutionActionsEnabledFor(selection)) {
            ImmutableList.Builder taskStrings = ImmutableList.builder();
            block4: for (TaskNode node : selection.toList(TaskNode.class)) {
                TaskNode.TaskNodeType type = node.getType();
                switch (type) {
                    case PROJECT_TASK_NODE: {
                        taskStrings.add((Object)((ProjectTaskNode)node).getProjectTask().getPath().getPath());
                        continue block4;
                    }
                    case TASK_SELECTOR_NODE: {
                        taskStrings.add((Object)((TaskSelectorNode)node).getTaskSelector().getName());
                        continue block4;
                    }
                }
                throw new IllegalStateException("Unsupported Task node type: " + (Object)((Object)type));
            }
            return taskStrings.build();
        }
        if (TaskViewActionStateRules.projectScopedTaskExecutionActionsEnabledFor(selection)) {
            return ImmutableList.of();
        }
        throw new IllegalStateException("Unsupported selection: " + selection);
    }

    private static String getProjectDirectoryExpression(NodeSelection selection) {
        if (TaskViewActionStateRules.taskScopedTaskExecutionActionsEnabledFor(selection)) {
            TaskNode taskNode = selection.getFirstElement(TaskNode.class);
            if (taskNode instanceof ProjectTaskNode) {
                return TaskNodeSelectionUtils.getProjectDirectoryExpression(taskNode.getParentProjectNode().getRootProjectNode());
            }
            if (taskNode instanceof TaskSelectorNode) {
                return TaskNodeSelectionUtils.getProjectDirectoryExpression(taskNode.getParentProjectNode());
            }
        } else if (TaskViewActionStateRules.projectScopedTaskExecutionActionsEnabledFor(selection)) {
            ProjectNode projectNode = selection.getFirstElement(ProjectNode.class);
            return TaskNodeSelectionUtils.getProjectDirectoryExpression(projectNode);
        }
        throw new IllegalStateException("Unsupported selection: " + selection);
    }

    private static String getProjectDirectoryExpression(ProjectNode projectNode) {
        Optional<IProject> workspaceProject = projectNode.getWorkspaceProject();
        if (workspaceProject.isPresent()) {
            return ExpressionUtils.encodeWorkspaceLocation((IProject)((IProject)workspaceProject.get()));
        }
        return projectNode.getEclipseProject().getProjectDirectory().getAbsolutePath();
    }
}

