/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.wizard.project;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingutils.binding.Property;
import java.util.List;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.i18n.CoreMessages;
import org.eclipse.buildship.core.projectimport.ProjectImportConfiguration;
import org.eclipse.buildship.core.util.gradle.GradleDistributionWrapper;
import org.eclipse.buildship.core.util.gradle.PublishedGradleVersionsWrapper;
import org.eclipse.buildship.ui.i18n.UiMessages;
import org.eclipse.buildship.ui.util.file.DirectoryDialogSelectionListener;
import org.eclipse.buildship.ui.util.layout.LayoutUtils;
import org.eclipse.buildship.ui.util.selection.Enabler;
import org.eclipse.buildship.ui.util.widget.UiBuilder;
import org.eclipse.buildship.ui.wizard.project.AbstractWizardPage;
import org.eclipse.buildship.ui.wizard.project.ProjectWizardMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gradle.util.GradleVersion;

public final class GradleOptionsWizardPage
extends AbstractWizardPage {
    private final PublishedGradleVersionsWrapper publishedGradleVersions;
    private final String pageContextInformation;
    private Text localInstallationDirText;
    private Text remoteDistributionUriText;
    private Combo gradleVersionCombo;
    private Button useGradleWrapperOption;
    private Button useLocalInstallationDirOption;
    private Button useRemoteDistributionUriOption;
    private Button useGradleVersionOption;

    public GradleOptionsWizardPage(ProjectImportConfiguration configuration, PublishedGradleVersionsWrapper publishedGradleVersions) {
        this(configuration, publishedGradleVersions, ProjectWizardMessages.Title_GradleOptionsWizardPage, ProjectWizardMessages.InfoMessage_GradleOptionsWizardPageDefault, ProjectWizardMessages.InfoMessage_GradleOptionsWizardPageContext);
    }

    public GradleOptionsWizardPage(ProjectImportConfiguration configuration, PublishedGradleVersionsWrapper publishedGradleVersions, String title, String defaultMessage, String pageContextInformation) {
        super("GradleOptions", title, defaultMessage, configuration, (List<Property<?>>)ImmutableList.of((Object)configuration.getGradleDistribution()));
        this.publishedGradleVersions = publishedGradleVersions;
        this.pageContextInformation = pageContextInformation;
    }

    @Override
    protected void createWidgets(Composite root) {
        root.setLayout((Layout)new GridLayout(1, false));
        this.createGradleDistributionContent((Composite)GradleOptionsWizardPage.createGroup(root, ProjectWizardMessages.Label_GradleDistribution));
        this.bindGradleDistributionToConfiguration();
    }

    private static Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setText(text);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)LayoutUtils.newGridLayout(3));
        return group;
    }

    private void createGradleDistributionContent(Composite root) {
        UiBuilder.UiBuilderFactory uiBuilderFactory = this.getUiBuilderFactory();
        this.useGradleWrapperOption = uiBuilderFactory.newRadio(root).alignLeft().text(CoreMessages.GradleDistribution_Label_GradleWrapper).control();
        uiBuilderFactory.span(root);
        uiBuilderFactory.span(root);
        this.useLocalInstallationDirOption = uiBuilderFactory.newRadio(root).alignLeft().text(CoreMessages.GradleDistribution_Label_LocalInstallationDirectory).control();
        this.localInstallationDirText = uiBuilderFactory.newText(root).alignFillHorizontal().disabled().control();
        Button localInstallationDirBrowseButton = uiBuilderFactory.newButton(root).alignLeft().disabled().text(UiMessages.Button_Label_Browse).control();
        localInstallationDirBrowseButton.addSelectionListener((SelectionListener)new DirectoryDialogSelectionListener(root.getShell(), (Widget)this.localInstallationDirText, CoreMessages.GradleDistribution_Label_LocalInstallationDirectory));
        this.useRemoteDistributionUriOption = uiBuilderFactory.newRadio(root).alignLeft().text(CoreMessages.GradleDistribution_Label_RemoteDistributionUri).control();
        this.remoteDistributionUriText = uiBuilderFactory.newText(root).alignFillHorizontal().disabled().control();
        uiBuilderFactory.span(root);
        this.useGradleVersionOption = uiBuilderFactory.newRadio(root).alignLeft().text(CoreMessages.GradleDistribution_Label_SpecificGradleVersion).control();
        this.gradleVersionCombo = uiBuilderFactory.newCombo(root).alignLeft().disabled().control();
        this.gradleVersionCombo.setSize(150, this.gradleVersionCombo.getSize().y);
        this.gradleVersionCombo.setItems(this.getGradleVersions());
        if (this.gradleVersionCombo.getItemCount() > 0) {
            this.gradleVersionCombo.select(0);
        }
        uiBuilderFactory.span(root);
        ImmutableList allRadios = ImmutableList.of((Object)this.useGradleWrapperOption, (Object)this.useLocalInstallationDirOption, (Object)this.useRemoteDistributionUriOption, (Object)this.useGradleVersionOption);
        GradleDistributionWrapper wrapper = (GradleDistributionWrapper)this.getConfiguration().getGradleDistribution().getValue();
        GradleDistributionWrapper.DistributionType type = wrapper.getType();
        String configuration = Strings.nullToEmpty((String)wrapper.getConfiguration());
        switch (type) {
            case WRAPPER: {
                this.updateSelectedState(this.useGradleWrapperOption, (List<Button>)allRadios);
                break;
            }
            case LOCAL_INSTALLATION: {
                this.updateSelectedState(this.useLocalInstallationDirOption, (List<Button>)allRadios);
                this.localInstallationDirText.setText(configuration);
                break;
            }
            case REMOTE_DISTRIBUTION: {
                this.updateSelectedState(this.useRemoteDistributionUriOption, (List<Button>)allRadios);
                this.remoteDistributionUriText.setText(configuration);
                break;
            }
            case VERSION: {
                this.updateSelectedState(this.useGradleVersionOption, (List<Button>)allRadios);
                this.updateVersionSelection(configuration);
                break;
            }
            default: {
                throw new GradlePluginsRuntimeException("Unrecognized Gradle distribution type: " + type);
            }
        }
        new Enabler(this.useGradleWrapperOption).enables(new Control[0]);
        new Enabler(this.useLocalInstallationDirOption).enables(new Control[]{this.localInstallationDirText, localInstallationDirBrowseButton});
        new Enabler(this.useRemoteDistributionUriOption).enables(new Control[]{this.remoteDistributionUriText});
        new Enabler(this.useGradleVersionOption).enables(new Control[]{this.gradleVersionCombo});
    }

    private String[] getGradleVersions() {
        return (String[])FluentIterable.from((Iterable)this.publishedGradleVersions.getVersions()).transform((Function)new Function<GradleVersion, String>(){

            public String apply(GradleVersion gradleVersion) {
                return gradleVersion.getVersion();
            }
        }).toArray(String.class);
    }

    private void updateSelectedState(Button selectedRadioButton, List<Button> allRadioButtons) {
        for (Button radioButton : allRadioButtons) {
            if (radioButton.equals(selectedRadioButton)) {
                radioButton.setSelection(true);
                radioButton.setFocus();
                continue;
            }
            radioButton.setSelection(false);
        }
    }

    private void updateVersionSelection(String version) {
        for (int i = 0; i < this.gradleVersionCombo.getItemCount(); ++i) {
            if (!this.gradleVersionCombo.getItem(i).equals(version)) continue;
            this.gradleVersionCombo.select(i);
            return;
        }
        int index = this.gradleVersionCombo.getItemCount();
        this.gradleVersionCombo.add(version, index);
        this.gradleVersionCombo.select(index);
    }

    private void bindGradleDistributionToConfiguration() {
        this.localInstallationDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GradleDistributionWrapper gradleDistribution = GradleDistributionWrapper.from((GradleDistributionWrapper.DistributionType)GradleDistributionWrapper.DistributionType.LOCAL_INSTALLATION, (String)Strings.emptyToNull((String)GradleOptionsWizardPage.this.localInstallationDirText.getText()));
                GradleOptionsWizardPage.this.getConfiguration().setGradleDistribution(gradleDistribution);
            }
        });
        this.remoteDistributionUriText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GradleDistributionWrapper gradleDistribution = GradleDistributionWrapper.from((GradleDistributionWrapper.DistributionType)GradleDistributionWrapper.DistributionType.REMOTE_DISTRIBUTION, (String)Strings.emptyToNull((String)GradleOptionsWizardPage.this.remoteDistributionUriText.getText()));
                GradleOptionsWizardPage.this.getConfiguration().setGradleDistribution(gradleDistribution);
            }
        });
        this.gradleVersionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GradleDistributionWrapper gradleDistribution = GradleOptionsWizardPage.this.getSpecificVersion();
                GradleOptionsWizardPage.this.getConfiguration().setGradleDistribution(gradleDistribution);
            }
        });
        this.gradleVersionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GradleDistributionWrapper gradleDistribution = GradleOptionsWizardPage.this.getSpecificVersion();
                GradleOptionsWizardPage.this.getConfiguration().setGradleDistribution(gradleDistribution);
            }
        });
        this.useGradleWrapperOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GradleOptionsWizardPage.this.useGradleWrapperOption.getSelection()) {
                    GradleDistributionWrapper gradleDistribution = GradleDistributionWrapper.from((GradleDistributionWrapper.DistributionType)GradleDistributionWrapper.DistributionType.WRAPPER, null);
                    GradleOptionsWizardPage.this.getConfiguration().setGradleDistribution(gradleDistribution);
                }
            }
        });
        this.useLocalInstallationDirOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GradleOptionsWizardPage.this.useLocalInstallationDirOption.getSelection()) {
                    GradleDistributionWrapper gradleDistribution = GradleDistributionWrapper.from((GradleDistributionWrapper.DistributionType)GradleDistributionWrapper.DistributionType.LOCAL_INSTALLATION, (String)Strings.emptyToNull((String)GradleOptionsWizardPage.this.localInstallationDirText.getText()));
                    GradleOptionsWizardPage.this.getConfiguration().setGradleDistribution(gradleDistribution);
                }
            }
        });
        this.useRemoteDistributionUriOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GradleOptionsWizardPage.this.useRemoteDistributionUriOption.getSelection()) {
                    GradleDistributionWrapper gradleDistribution = GradleDistributionWrapper.from((GradleDistributionWrapper.DistributionType)GradleDistributionWrapper.DistributionType.REMOTE_DISTRIBUTION, (String)Strings.emptyToNull((String)GradleOptionsWizardPage.this.remoteDistributionUriText.getText()));
                    GradleOptionsWizardPage.this.getConfiguration().setGradleDistribution(gradleDistribution);
                }
            }
        });
        this.useGradleVersionOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GradleOptionsWizardPage.this.useGradleVersionOption.getSelection()) {
                    GradleDistributionWrapper gradleDistribution = GradleOptionsWizardPage.this.getSpecificVersion();
                    GradleOptionsWizardPage.this.getConfiguration().setGradleDistribution(gradleDistribution);
                }
            }
        });
    }

    private GradleDistributionWrapper getSpecificVersion() {
        int selectionIndex = this.gradleVersionCombo.getSelectionIndex();
        return GradleDistributionWrapper.from((GradleDistributionWrapper.DistributionType)GradleDistributionWrapper.DistributionType.VERSION, (String)Strings.emptyToNull((String)(selectionIndex == -1 || !Strings.isNullOrEmpty((String)this.gradleVersionCombo.getText()) ? this.gradleVersionCombo.getText() : this.gradleVersionCombo.getItem(selectionIndex))));
    }

    @Override
    protected String getPageContextInformation() {
        return this.pageContextInformation;
    }
}

