/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.configuration.internal;

import com.google.common.base.Objects;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.configuration.BuildConfiguration;
import org.eclipse.buildship.core.configuration.GradleArguments;
import org.eclipse.buildship.core.configuration.RunConfiguration;
import org.eclipse.buildship.core.configuration.WorkspaceConfiguration;
import org.eclipse.buildship.core.configuration.internal.DefaultBuildConfiguration;
import org.eclipse.buildship.core.configuration.internal.DefaultBuildConfigurationProperties;
import org.eclipse.buildship.core.configuration.internal.RunConfigurationProperties;

public class DefaultRunConfiguration
implements RunConfiguration {
    private final BuildConfiguration buildConfiguration;
    private final RunConfigurationProperties properties;

    public DefaultRunConfiguration(WorkspaceConfiguration workspaceConfiguration, DefaultBuildConfigurationProperties buildProperties, RunConfigurationProperties properties) {
        this.buildConfiguration = new DefaultBuildConfiguration(buildProperties, workspaceConfiguration);
        this.properties = properties;
    }

    @Override
    public BuildConfiguration getBuildConfiguration() {
        return this.buildConfiguration;
    }

    @Override
    public List<String> getTasks() {
        return this.properties.getTasks();
    }

    @Override
    public GradleDistribution getGradleDistribution() {
        if (this.properties.isOverrideBuildSettings()) {
            return this.properties.getGradleDistribution();
        }
        return this.buildConfiguration.getGradleDistribution();
    }

    @Override
    public File getGradleUserHome() {
        if (this.properties.isOverrideBuildSettings()) {
            return this.properties.getGradleUserHome();
        }
        return this.buildConfiguration.getGradleUserHome();
    }

    @Override
    public File getJavaHome() {
        return this.properties.getJavaHome();
    }

    @Override
    public List<String> getJvmArguments() {
        return this.properties.getJvmArguments();
    }

    @Override
    public List<String> getArguments() {
        return this.properties.getArguments();
    }

    private boolean isBuildScansEnabled() {
        if (this.properties.isOverrideBuildSettings()) {
            return this.properties.isBuildScansEnabled();
        }
        return this.buildConfiguration.isBuildScansEnabled();
    }

    private boolean isOfflineMode() {
        if (this.properties.isOverrideBuildSettings()) {
            return this.properties.isOfflineMode();
        }
        return this.buildConfiguration.isOfflineMode();
    }

    @Override
    public boolean isShowExecutionView() {
        return this.properties.isShowExecutionView();
    }

    @Override
    public boolean isShowConsoleView() {
        return this.properties.isShowConsoleView();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultRunConfiguration) {
            DefaultRunConfiguration other = (DefaultRunConfiguration)obj;
            return Objects.equal((Object)this.buildConfiguration, (Object)other.buildConfiguration) && Objects.equal((Object)this.properties, (Object)other.properties);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.buildConfiguration, this.properties});
    }

    @Override
    public GradleArguments toGradleArguments() {
        return GradleArguments.from(this.getBuildConfiguration().getRootProjectDirectory(), this.getGradleDistribution(), this.getGradleUserHome(), this.getJavaHome(), this.isBuildScansEnabled(), this.isOfflineMode(), this.getArguments(), this.getJvmArguments());
    }
}

