/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gradleware.tooling.toolingmodel.OmniClasspathAttribute;
import com.gradleware.tooling.toolingmodel.OmniEclipseSourceDirectory;
import com.gradleware.tooling.toolingmodel.util.Maybe;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

final class SourceFolderUpdater {
    private final IJavaProject project;
    private final Map<IPath, OmniEclipseSourceDirectory> sourceFoldersByPath;

    private SourceFolderUpdater(IJavaProject project, List<OmniEclipseSourceDirectory> sourceFolders) {
        this.project = (IJavaProject)Preconditions.checkNotNull((Object)project);
        this.sourceFoldersByPath = Maps.newLinkedHashMap();
        for (OmniEclipseSourceDirectory sourceFolder : sourceFolders) {
            IPath fullPath = project.getProject().getFullPath().append(sourceFolder.getPath());
            this.sourceFoldersByPath.put(fullPath, sourceFolder);
        }
    }

    private void updateSourceFolders(IProgressMonitor monitor) throws JavaModelException {
        ArrayList classpath = Lists.newArrayList((Object[])this.project.getRawClasspath());
        this.updateExistingSourceFolders(classpath);
        this.addNewSourceFolders(classpath);
        this.project.setRawClasspath(classpath.toArray(new IClasspathEntry[0]), monitor);
    }

    private void updateExistingSourceFolders(List<IClasspathEntry> classpath) {
        ListIterator<IClasspathEntry> iterator = classpath.listIterator();
        while (iterator.hasNext()) {
            IClasspathEntry classpathEntry = iterator.next();
            if (classpathEntry.getEntryKind() != 3) continue;
            IPath path = classpathEntry.getPath();
            OmniEclipseSourceDirectory sourceFolder = this.sourceFoldersByPath.get(path);
            if (sourceFolder == null) {
                iterator.remove();
                continue;
            }
            iterator.set(this.toClasspathEntry(sourceFolder, classpathEntry));
            this.sourceFoldersByPath.remove(path);
        }
    }

    private IClasspathEntry toClasspathEntry(OmniEclipseSourceDirectory sourceFolder, IClasspathEntry existingEntry) {
        SourceFolderEntryBuilder builder = new SourceFolderEntryBuilder(this.project, existingEntry.getPath());
        builder.setOutput(existingEntry.getOutputLocation());
        builder.setAttributes(existingEntry.getExtraAttributes());
        builder.setIncludes(existingEntry.getInclusionPatterns());
        builder.setExcludes(existingEntry.getExclusionPatterns());
        this.synchronizeAttributesFromModel(builder, sourceFolder);
        return builder.build();
    }

    private void synchronizeAttributesFromModel(SourceFolderEntryBuilder builder, OmniEclipseSourceDirectory sourceFolder) {
        Optional includes;
        Optional excludes;
        Optional attributes;
        Maybe output = sourceFolder.getOutput();
        if (output.isPresent()) {
            builder.setOutput((String)output.get());
        }
        if ((attributes = sourceFolder.getClasspathAttributes()).isPresent()) {
            builder.setAttributes((List)attributes.get());
        }
        if ((excludes = sourceFolder.getExcludes()).isPresent()) {
            builder.setExcludes((List)excludes.get());
        }
        if ((includes = sourceFolder.getIncludes()).isPresent()) {
            builder.setIncludes((List)includes.get());
        }
    }

    private void addNewSourceFolders(List<IClasspathEntry> classpath) {
        for (OmniEclipseSourceDirectory sourceFolder : this.sourceFoldersByPath.values()) {
            IResource physicalLocation = this.getUnderlyingDirectory(sourceFolder);
            if (!this.existsInSameLocation(physicalLocation, sourceFolder)) continue;
            classpath.add(this.toClasspathEntry(sourceFolder, physicalLocation));
        }
    }

    private IResource getUnderlyingDirectory(OmniEclipseSourceDirectory directory) {
        IProject project = this.project.getProject();
        IPath path = project.getFullPath().append(directory.getPath());
        if (path.segmentCount() == 1) {
            return project;
        }
        return project.getFolder(path.removeFirstSegments(1));
    }

    private boolean existsInSameLocation(IResource directory, OmniEclipseSourceDirectory sourceFolder) {
        if (!directory.exists()) {
            return false;
        }
        if (directory.isLinked()) {
            return this.hasSameLocationAs(directory, sourceFolder);
        }
        return true;
    }

    private boolean hasSameLocationAs(IResource directory, OmniEclipseSourceDirectory sourceFolder) {
        return directory.getLocation() != null && directory.getLocation().toFile().equals(sourceFolder.getDirectory());
    }

    private IClasspathEntry toClasspathEntry(OmniEclipseSourceDirectory sourceFolder, IResource physicalLocation) {
        IPackageFragmentRoot fragmentRoot = this.project.getPackageFragmentRoot(physicalLocation);
        SourceFolderEntryBuilder builder = new SourceFolderEntryBuilder(this.project, fragmentRoot.getPath());
        this.synchronizeAttributesFromModel(builder, sourceFolder);
        return builder.build();
    }

    public static void update(IJavaProject project, List<OmniEclipseSourceDirectory> sourceFolders, IProgressMonitor monitor) throws JavaModelException {
        SourceFolderUpdater updater = new SourceFolderUpdater(project, sourceFolders);
        updater.updateSourceFolders(monitor);
    }

    private static class SourceFolderEntryBuilder {
        private final IPath path;
        private IPath output = null;
        private IPath[] includes = new IPath[0];
        private IPath[] excludes = new IPath[0];
        private IClasspathAttribute[] attributes = new IClasspathAttribute[0];
        private IJavaProject project;

        public SourceFolderEntryBuilder(IJavaProject project, IPath path) {
            this.project = project;
            this.path = path;
        }

        public void setOutput(IPath output) {
            this.output = output;
        }

        public void setOutput(String output) {
            this.output = output != null ? this.project.getPath().append(output) : null;
        }

        public void setIncludes(IPath[] includes) {
            this.includes = includes;
        }

        public void setIncludes(List<String> includes) {
            this.includes = SourceFolderEntryBuilder.stringListToPaths(includes);
        }

        public void setExcludes(IPath[] excludes) {
            this.excludes = excludes;
        }

        public void setExcludes(List<String> excludes) {
            this.excludes = SourceFolderEntryBuilder.stringListToPaths(excludes);
        }

        public void setAttributes(IClasspathAttribute[] attributes) {
            this.attributes = attributes;
        }

        public void setAttributes(List<OmniClasspathAttribute> attributes) {
            this.attributes = new IClasspathAttribute[attributes.size()];
            for (int i = 0; i < attributes.size(); ++i) {
                OmniClasspathAttribute attribute = attributes.get(i);
                this.attributes[i] = JavaCore.newClasspathAttribute((String)attribute.getName(), (String)attribute.getValue());
            }
        }

        public IClasspathEntry build() {
            return JavaCore.newSourceEntry((IPath)this.path, (IPath[])this.includes, (IPath[])this.excludes, (IPath)this.output, (IClasspathAttribute[])this.attributes);
        }

        private static IPath[] stringListToPaths(List<String> strings) {
            IPath[] result = new IPath[strings.size()];
            for (int i = 0; i < strings.size(); ++i) {
                result[i] = new Path(strings.get(i));
            }
            return result;
        }
    }
}

