/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.workspace;

import com.google.common.collect.Sets;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.BuildConfiguration;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.event.Event;
import org.eclipse.buildship.core.util.collections.AdapterFunction;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.buildship.core.workspace.GradleNatureAddedEvent;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddBuildshipNatureHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            List elements = ((StructuredSelection)selection).toList();
            Set<IProject> projects = this.collectProjects(elements);
            Set<BuildConfiguration> buildConfigs = this.createBuildConfigsFor(projects);
            this.synchronize(buildConfigs);
            this.publishNatureAddedEvent(projects);
        }
        return null;
    }

    private Set<IProject> collectProjects(List<?> elements) {
        LinkedHashSet projects = Sets.newLinkedHashSet();
        AdapterFunction adapterFunction = AdapterFunction.forType(IProject.class);
        for (Object element : elements) {
            IProject project = (IProject)adapterFunction.apply(element);
            if (project == null || GradleProjectNature.isPresentOn((IProject)project) || project.getLocation() == null) continue;
            projects.add(project);
        }
        return projects;
    }

    private Set<BuildConfiguration> createBuildConfigsFor(Set<IProject> projects) {
        LinkedHashSet buildConfigs = Sets.newLinkedHashSet();
        for (IProject project : projects) {
            buildConfigs.add(CorePlugin.configurationManager().createBuildConfiguration(project.getLocation().toFile(), false, GradleDistribution.fromBuild(), null, false, false, false));
        }
        return buildConfigs;
    }

    private void synchronize(Set<BuildConfiguration> buildConfigs) {
        for (BuildConfiguration buildConfig : buildConfigs) {
            GradleBuild gradleBuild = CorePlugin.gradleWorkspaceManager().getGradleBuild(buildConfig);
            gradleBuild.synchronize(NewProjectHandler.IMPORT_AND_MERGE);
        }
    }

    private void publishNatureAddedEvent(Set<IProject> projects) {
        CorePlugin.listenerRegistry().dispatch((Event)new GradleNatureAddedEvent(projects));
    }
}

