/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public abstract class ReflectionCache<T extends CachedInvokable<?>> {
    private final Object lock = new Object();
    private final WeaklyClassReferencingCache cache = new WeaklyClassReferencingCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(Class<?> receiver, Class<?>[] key) {
        Object object = this.lock;
        synchronized (object) {
            return this.cache.get(receiver, key);
        }
    }

    protected abstract T create(Class<?> var1, Class<?>[] var2);

    public int size() {
        return this.cache.size();
    }

    private class CacheEntry {
        private WeaklyClassReferencingCache table;
        private T value;

        private CacheEntry() {
            this.table = new WeaklyClassReferencingCache();
        }
    }

    public static class CachedInvokable<T> {
        private final WeakReference<T> invokable;

        public CachedInvokable(T invokable) {
            this.invokable = new WeakReference<T>(invokable);
        }

        public T getMethod() {
            return this.invokable.get();
        }
    }

    private class WeaklyClassReferencingCache
    extends WeakHashMap<Class<?>, CacheEntry> {
        private WeaklyClassReferencingCache() {
        }

        public T get(Class<?> receiver, Class<?>[] classes) {
            WeaklyClassReferencingCache cur = this;
            CacheEntry last = this.fetchNext(cur, receiver);
            for (Class<?> aClass : classes) {
                cur = last.table;
                last = this.fetchNext(cur, aClass);
            }
            if (last.value == null || last.value.getMethod() == null) {
                last.value = ReflectionCache.this.create(receiver, classes);
            }
            return last.value;
        }

        private CacheEntry fetchNext(WeaklyClassReferencingCache cur, Class<?> aClass) {
            CacheEntry last = (CacheEntry)cur.get(aClass);
            if (last == null) {
                last = new CacheEntry();
                cur.put(aClass, last);
            }
            return last;
        }
    }
}

