/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.modelqualitychecks.PPetriNet;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.project.generatortasks.GeneratorTask;
import org.eclipse.comma.project.generatortasks.OutputLocator;
import org.eclipse.comma.project.project.HomeState;
import org.eclipse.comma.project.project.HomeStateSet;
import org.eclipse.comma.project.project.ModelQualityChecksGenerationTask;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ModelQualityChecksGeneratorTask
extends GeneratorTask {
    protected final ModelQualityChecksGenerationTask task;
    protected final IScopeProvider scopeProvider;
    protected final IFileSystemAccess2 fsa;

    public ModelQualityChecksGeneratorTask(ModelQualityChecksGenerationTask task, IScopeProvider scopeProvider, OutputLocator outputLocator, IFileSystemAccess2 fsa) {
        super(task, scopeProvider, outputLocator, fsa);
        this.task = task;
        this.scopeProvider = scopeProvider;
        this.fsa = fsa;
    }

    @Override
    protected void doGenerate() {
        try {
            boolean _isPicture;
            boolean _tripleNotEquals;
            Parameters parameters = null;
            String _params = this.task.getParams();
            boolean bl = _tripleNotEquals = _params != null;
            if (_tripleNotEquals) {
                EObject _head = (EObject)IterableExtensions.head((Iterable)EcoreUtil2.getResource((Resource)this.task.eResource(), (String)this.task.getParams()).getContents());
                parameters = (Parameters)_head;
            }
            Interface _interface = this.task.getTarget().getInterface();
            PPetriNet net = new PPetriNet(_interface, parameters).build();
            String _name = this.task.getName();
            String _plus = "ModelQualityChecks/" + _name;
            String base = String.valueOf(_plus) + "/";
            boolean _isPetriNetModel = this.task.isPetriNetModel();
            if (_isPetriNetModel) {
                this.fsa.generateFile(String.valueOf(base) + "net.py", (CharSequence)net.toSnakes());
            }
            if (_isPicture = this.task.isPicture()) {
                InputStream picture = net.toPicture();
                this.fsa.generateFile(String.valueOf(base) + "net.png", picture);
            }
            if (this.task.isReachabilitygraph() || this.task.isVerificationReport()) {
                boolean _isVerificationReport;
                boolean _tripleNotEquals_1;
                int _xifexpression = 0;
                int _rgMaxDepth = this.task.getRgMaxDepth();
                boolean _equals = _rgMaxDepth == 0;
                _xifexpression = _equals ? 30 : this.task.getRgMaxDepth();
                int depth = _xifexpression;
                List homeStates = null;
                EList<HomeStateSet> _homeStateSets = this.task.getHomeStateSets();
                boolean bl2 = _tripleNotEquals_1 = _homeStateSets != null;
                if (_tripleNotEquals_1) {
                    Functions.Function1<HomeStateSet, List<State>> _function = new Functions.Function1<HomeStateSet, List<State>>(){

                        public List<State> apply(HomeStateSet set) {
                            Functions.Function1<HomeState, State> _function = new Functions.Function1<HomeState, State>(){

                                public State apply(HomeState s) {
                                    return s.getHs();
                                }
                            };
                            return ListExtensions.map(set.getStates(), (Functions.Function1)_function);
                        }
                    };
                    homeStates = ListExtensions.map(this.task.getHomeStateSets(), (Functions.Function1)_function);
                }
                Integer weakTerminitionCheckQueueSize = null;
                net.execute(depth, this.task.isVerificationReport(), homeStates, weakTerminitionCheckQueueSize);
                boolean _isReachabilitygraph = this.task.isReachabilitygraph();
                if (_isReachabilitygraph) {
                    this.fsa.generateFile(String.valueOf(base) + "reachability_graph.json", (CharSequence)net.getReachabilityGraphJson());
                    this.fsa.generateFile(String.valueOf(base) + "reachability_graph.html", (CharSequence)net.getReachabilityGraphHTML());
                }
                if (_isVerificationReport = this.task.isVerificationReport()) {
                    byte[] _dashboard = net.getDashboard();
                    ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_dashboard);
                    this.fsa.generateFile(String.valueOf(base) + "verification_report.html", (InputStream)_byteArrayInputStream);
                }
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                e.printStackTrace();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Error occured during execution of \"");
                String _name_1 = this.task.getName();
                _builder.append(_name_1);
                _builder.append(" (");
                String _message = e.getMessage();
                _builder.append(_message);
                _builder.append(")\"");
                throw new RuntimeException(_builder.toString(), e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

