/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.simpleconfigurator.manipulator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.frameworkadmin.equinox.ParserUtils;
import org.eclipse.equinox.internal.frameworkadmin.utils.Utils;
import org.eclipse.equinox.internal.provisional.configuratormanipulator.ConfiguratorManipulator;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundlesState;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.internal.simpleconfigurator.SimpleConfiguratorImpl;
import org.eclipse.equinox.internal.simpleconfigurator.manipulator.SimpleConfiguratorManipulatorUtils;
import org.eclipse.equinox.internal.simpleconfigurator.utils.EquinoxUtils;
import org.eclipse.equinox.internal.simpleconfigurator.utils.SimpleConfiguratorUtils;
import org.eclipse.equinox.simpleconfigurator.manipulator.SimpleConfiguratorManipulator;
import org.osgi.framework.BundleContext;

public class SimpleConfiguratorManipulatorImpl
implements SimpleConfiguratorManipulator,
ConfiguratorManipulator {
    private static final boolean DEBUG = false;
    private static final BundleInfo[] NULL_BUNDLEINFOS = new BundleInfo[0];
    public static final String PROP_KEY_EXCLUSIVE_INSTALLATION = "org.eclipse.equinox.simpleconfigurator.exclusiveInstallation";
    public static final String CONFIG_LIST = "bundles.info";
    public static final String CONFIG_FOLDER = "configuration";
    public static final String CONFIGURATOR_FOLDER = "org.eclipse.equinox.simpleconfigurator";
    public static final String PROP_KEY_CONFIGURL = "org.eclipse.equinox.simpleconfigurator.configUrl";
    public static final String SHARED_BUNDLES_INFO = "configuration" + File.separatorChar + "org.eclipse.equinox.simpleconfigurator" + File.separatorChar + "bundles.info";
    private Set<Manipulator> manipulators = new HashSet<Manipulator>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File getConfigFile(Manipulator manipulator) throws IllegalStateException {
        File configuratorFolder;
        File targetFile;
        File fwConfigLoc = manipulator.getLauncherData().getFwConfigLocation();
        File baseDir = null;
        if (fwConfigLoc == null) {
            baseDir = manipulator.getLauncherData().getHome();
            if (baseDir == null) {
                if (manipulator.getLauncherData().getLauncher() == null) throw new IllegalStateException("All of fwConfigFile, home, launcher are not set.");
                baseDir = manipulator.getLauncherData().getLauncher().getParentFile();
            }
        } else {
            baseDir = fwConfigLoc.exists() ? (fwConfigLoc.isDirectory() ? fwConfigLoc : fwConfigLoc.getParentFile()) : (fwConfigLoc.getName().endsWith(".ini") ? fwConfigLoc.getParentFile() : fwConfigLoc);
        }
        if (Utils.createParentDir((File)(targetFile = new File(configuratorFolder = new File(baseDir, CONFIGURATOR_FOLDER), CONFIG_LIST)))) return targetFile;
        return null;
    }

    static boolean isPrerequisiteBundles(URI location, LocationInfo info) {
        boolean ret = false;
        if (info.prerequisiteLocations == null) {
            return false;
        }
        URI[] uRIArray = info.prerequisiteLocations;
        int n = info.prerequisiteLocations.length;
        int n2 = 0;
        while (n2 < n) {
            URI prerequisiteLocation = uRIArray[n2];
            if (location.equals(prerequisiteLocation)) {
                ret = true;
                break;
            }
            ++n2;
        }
        return ret;
    }

    static boolean isSystemBundle(URI location, LocationInfo info) {
        if (info.systemBundleLocation == null) {
            return false;
        }
        return location.equals(info.systemBundleLocation);
    }

    static boolean isSystemFragmentBundle(URI location, LocationInfo info) {
        boolean ret = false;
        if (info.systemFragmentedBundleLocations == null) {
            return false;
        }
        URI[] uRIArray = info.systemFragmentedBundleLocations;
        int n = info.systemFragmentedBundleLocations.length;
        int n2 = 0;
        while (n2 < n) {
            URI systemFragmentedBundleLocation = uRIArray[n2];
            if (location.equals(systemFragmentedBundleLocation)) {
                ret = true;
                break;
            }
            ++n2;
        }
        return ret;
    }

    private static boolean isTargetConfiguratorBundle(BundleInfo[] bInfos) {
        BundleInfo[] bundleInfoArray = bInfos;
        int n = bInfos.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo bInfo = bundleInfoArray[n2];
            if (SimpleConfiguratorManipulatorImpl.isTargetConfiguratorBundle(bInfo.getLocation())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isTargetConfiguratorBundle(URI location) {
        String symbolic = Utils.getPathFromClause((String)Utils.getManifestMainAttributes((URI)location, (String)"Bundle-SymbolicName"));
        return CONFIGURATOR_FOLDER.equals(symbolic);
    }

    private void algorithm(int initialSl, SortedMap<Integer, List<BundleInfo>> bslToList, BundleInfo configuratorBInfo, List<BundleInfo> setToInitialConfig, List<BundleInfo> setToSimpleConfig, LocationInfo info) {
        int configuratorSL = configuratorBInfo.getStartLevel();
        Integer sL0 = bslToList.keySet().iterator().next();
        List list0 = (List)bslToList.get(sL0);
        if (sL0 == 0) {
            for (BundleInfo bInfo : list0) {
                if (!SimpleConfiguratorManipulatorImpl.isSystemBundle(bInfo.getLocation(), info)) continue;
                setToSimpleConfig.add(bInfo);
                break;
            }
        }
        for (Integer sL : bslToList.keySet()) {
            List list = (List)bslToList.get(sL);
            if (sL < configuratorSL) {
                for (BundleInfo bInfo : list) {
                    if (SimpleConfiguratorManipulatorImpl.isSystemBundle(bInfo.getLocation(), info)) continue;
                    setToInitialConfig.add(bInfo);
                }
                continue;
            }
            if (sL > configuratorSL) {
                for (BundleInfo bInfo : list) {
                    if ((SimpleConfiguratorManipulatorImpl.isPrerequisiteBundles(bInfo.getLocation(), info) || SimpleConfiguratorManipulatorImpl.isSystemFragmentBundle(bInfo.getLocation(), info)) && !SimpleConfiguratorManipulatorImpl.isSystemBundle(bInfo.getLocation(), info)) {
                        setToInitialConfig.add(bInfo);
                    }
                    setToSimpleConfig.add(bInfo);
                }
                continue;
            }
            boolean found = false;
            for (BundleInfo bInfo : list) {
                if (found) {
                    if (!SimpleConfiguratorManipulatorImpl.isSystemBundle(bInfo.getLocation(), info) && (SimpleConfiguratorManipulatorImpl.isPrerequisiteBundles(bInfo.getLocation(), info) || SimpleConfiguratorManipulatorImpl.isSystemFragmentBundle(bInfo.getLocation(), info))) {
                        setToInitialConfig.add(bInfo);
                    }
                    setToSimpleConfig.add(bInfo);
                    continue;
                }
                if (SimpleConfiguratorManipulatorImpl.isTargetConfiguratorBundle(bInfo.getLocation())) {
                    found = true;
                } else if (!SimpleConfiguratorManipulatorImpl.isSystemBundle(bInfo.getLocation(), info)) {
                    setToInitialConfig.add(bInfo);
                }
                setToSimpleConfig.add(bInfo);
            }
        }
        setToInitialConfig.add(configuratorBInfo);
    }

    private boolean checkResolve(BundleInfo bInfo, BundlesState state) {
        if (bInfo == null) {
            throw new IllegalArgumentException("bInfo is null.");
        }
        if (!state.isResolved()) {
            state.resolve(false);
        }
        if (!state.isResolved(bInfo)) {
            this.printoutUnsatisfiedConstraints(bInfo, state);
            return false;
        }
        return true;
    }

    private boolean divideBundleInfos(Manipulator manipulator, List<BundleInfo> setToInitialConfig, List<BundleInfo> setToSimpleConfig, int initialBSL) {
        BundlesState state = manipulator.getBundlesState();
        BundleInfo[] targetBundleInfos = null;
        targetBundleInfos = state.isFullySupported() ? state.getExpectedState() : manipulator.getConfigData().getBundles();
        BundleInfo configuratorBInfo = null;
        BundleInfo[] bundleInfoArray = targetBundleInfos;
        int n = targetBundleInfos.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo targetBundleInfo = bundleInfoArray[n2];
            if (SimpleConfiguratorManipulatorImpl.isTargetConfiguratorBundle(targetBundleInfo.getLocation()) && targetBundleInfo.isMarkedAsStarted()) {
                configuratorBInfo = targetBundleInfo;
                break;
            }
            ++n2;
        }
        if (configuratorBInfo == null && !this.manipulators.contains(manipulator)) {
            return false;
        }
        if (this.manipulators.contains(manipulator) && targetBundleInfos.length == 0) {
            this.manipulators.remove(manipulator);
        } else if (!this.manipulators.contains(manipulator)) {
            this.manipulators.add(manipulator);
        }
        if (state.isFullySupported()) {
            state.resolve(false);
        }
        LocationInfo info = new LocationInfo();
        this.setSystemBundles(state, info);
        if (configuratorBInfo != null) {
            this.setPrerequisiteBundles(configuratorBInfo, state, info);
            SortedMap<Integer, List<BundleInfo>> bslToList = this.getSortedMap(initialBSL, targetBundleInfos);
            this.algorithm(initialBSL, bslToList, configuratorBInfo, setToInitialConfig, setToSimpleConfig, info);
        }
        return true;
    }

    private SortedMap<Integer, List<BundleInfo>> getSortedMap(int initialSl, BundleInfo[] bInfos) {
        TreeMap<Integer, List<BundleInfo>> bslToList = new TreeMap<Integer, List<BundleInfo>>();
        BundleInfo[] bundleInfoArray = bInfos;
        int n = bInfos.length;
        int n2 = 0;
        while (n2 < n) {
            LinkedList<BundleInfo> list;
            BundleInfo bInfo = bundleInfoArray[n2];
            Integer sL = bInfo.getStartLevel();
            if (sL == -1) {
                sL = initialSl;
            }
            if ((list = (LinkedList<BundleInfo>)bslToList.get(sL)) == null) {
                list = new LinkedList<BundleInfo>();
                bslToList.put(sL, list);
            }
            list.add(bInfo);
            ++n2;
        }
        return bslToList;
    }

    private BundleInfo[] orderingInitialConfig(List<BundleInfo> setToInitialConfig) {
        LinkedList<BundleInfo> notToBeStarted = new LinkedList<BundleInfo>();
        LinkedList<BundleInfo> toBeStarted = new LinkedList<BundleInfo>();
        for (BundleInfo bInfo : setToInitialConfig) {
            if (bInfo.isMarkedAsStarted()) {
                toBeStarted.add(bInfo);
                continue;
            }
            notToBeStarted.add(bInfo);
        }
        setToInitialConfig.clear();
        setToInitialConfig.addAll(notToBeStarted);
        setToInitialConfig.addAll(toBeStarted);
        return Utils.getBundleInfosFromList(setToInitialConfig);
    }

    private void printoutUnsatisfiedConstraints(BundleInfo bInfo, BundlesState state) {
    }

    private URL chooseConfigurationURL(String relativePath, URL[] configURL) throws MalformedURLException {
        if (configURL != null) {
            File userConfig = new File(configURL[0].getFile(), relativePath);
            if (configURL.length == 1) {
                return userConfig.exists() ? userConfig.toURI().toURL() : null;
            }
            File sharedConfig = new File(configURL[1].getFile(), relativePath);
            if (!userConfig.exists()) {
                return sharedConfig.exists() ? sharedConfig.toURI().toURL() : null;
            }
            if (!sharedConfig.exists()) {
                return userConfig.toURI().toURL();
            }
            if (Boolean.getBoolean("eclipse.ignoreUserConfiguration")) {
                return sharedConfig.toURI().toURL();
            }
            return userConfig.toURI().toURL();
        }
        return null;
    }

    @Override
    public BundleInfo[] loadConfiguration(BundleContext context, String infoPath) throws IOException {
        URI installArea = EquinoxUtils.getInstallLocationURI((BundleContext)context);
        URL configURL = null;
        if (infoPath == null) {
            SimpleConfiguratorImpl simpleImpl = new SimpleConfiguratorImpl(context, null);
            configURL = simpleImpl.getConfigurationURL();
        } else {
            boolean defaultSource;
            boolean bl = defaultSource = infoPath == SOURCE_INFO;
            if (defaultSource) {
                infoPath = "org.eclipse.equinox.source/source.info";
            }
            URL[] configURLs = EquinoxUtils.getConfigAreaURL((BundleContext)context);
            configURL = this.chooseConfigurationURL(infoPath, configURLs);
        }
        if (configURL == null) {
            return NULL_BUNDLEINFOS;
        }
        ArrayList<BundleInfo> result = new ArrayList<BundleInfo>();
        result.addAll(Arrays.asList(this.loadConfiguration(configURL.openStream(), installArea)));
        try {
            ArrayList infoFiles = SimpleConfiguratorUtils.getInfoFiles();
            for (File infoFile : infoFiles) {
                BundleInfo[] info = this.loadConfiguration(infoFile.toURL().openStream(), infoFile.getParentFile().toURI());
                result.addAll(Arrays.asList(info));
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        return result.toArray(new BundleInfo[result.size()]);
    }

    @Override
    public BundleInfo[] loadConfiguration(InputStream stream, URI installArea) throws IOException {
        if (stream == null) {
            return NULL_BUNDLEINFOS;
        }
        List simpleBundles = SimpleConfiguratorUtils.readConfiguration((InputStream)stream, (URI)installArea);
        BundleInfo[] result = new BundleInfo[simpleBundles.size()];
        int i = 0;
        for (org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo simpleInfo : simpleBundles) {
            URI location = simpleInfo.getLocation();
            if (!location.isAbsolute() && simpleInfo.getBaseLocation() != null) {
                location = URIUtil.makeAbsolute((URI)location, (URI)simpleInfo.getBaseLocation());
            }
            BundleInfo bundleInfo = new BundleInfo(simpleInfo.getSymbolicName(), simpleInfo.getVersion(), location, simpleInfo.getStartLevel(), simpleInfo.isMarkedAsStarted());
            bundleInfo.setBaseLocation(simpleInfo.getBaseLocation());
            result[i++] = bundleInfo;
        }
        return result;
    }

    @Override
    public void saveConfiguration(BundleInfo[] configuration, OutputStream stream, URI installArea) throws IOException {
        org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo[] simpleInfos = this.convertBundleInfos(configuration, installArea);
        SimpleConfiguratorManipulatorUtils.writeConfiguration(simpleInfos, stream);
    }

    @Override
    public void saveConfiguration(BundleInfo[] configuration, File outputFile, URI installArea) throws IOException {
        this.saveConfiguration(configuration, outputFile, installArea, false);
    }

    private void saveConfiguration(BundleInfo[] configuration, File outputFile, URI installArea, boolean backup) throws IOException {
        File backupFile;
        if (backup && outputFile.exists() && !outputFile.renameTo(backupFile = Utils.getSimpleDataFormattedFile((File)outputFile))) {
            throw new IOException("Fail to rename from (" + outputFile + ") to (" + backupFile + ")");
        }
        org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo[] simpleInfos = this.convertBundleInfos(configuration, installArea);
        if (simpleInfos == null || simpleInfos.length == 0) {
            File parentDir;
            if (outputFile.exists()) {
                outputFile.delete();
            }
            if ((parentDir = outputFile.getParentFile()).exists()) {
                parentDir.delete();
            }
            return;
        }
        SimpleConfiguratorManipulatorUtils.writeConfiguration(simpleInfos, outputFile);
        if (CONFIG_LIST.equals(outputFile.getName()) && installArea != null && this.isSharedInstallSetup(URIUtil.toFile((URI)installArea), outputFile)) {
            this.rememberSharedBundlesInfoTimestamp(installArea, outputFile.getParentFile());
        }
    }

    private void rememberSharedBundlesInfoTimestamp(URI installArea, File outputFolder) {
        if (installArea == null) {
            return;
        }
        File sharedBundlesInfo = new File(URIUtil.append((URI)installArea, (String)SHARED_BUNDLES_INFO));
        if (!sharedBundlesInfo.exists()) {
            return;
        }
        Properties timestampToPersist = new Properties();
        timestampToPersist.put("bundlesInfoTimestamp", Long.toString(SimpleConfiguratorUtils.getFileLastModified((File)sharedBundlesInfo)));
        timestampToPersist.put("extTimestamp", Long.toString(SimpleConfiguratorUtils.getExtendedTimeStamp()));
        OutputStream os = null;
        try {
            try {
                File outputFile = new File(outputFolder, ".baseBundlesInfoTimestamp");
                os = new BufferedOutputStream(new FileOutputStream(outputFile));
                timestampToPersist.store(os, "Written by " + this.getClass());
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo[] convertBundleInfos(BundleInfo[] configuration, URI installArea) {
        org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo[] simpleInfos = new org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo[configuration.length];
        int i = 0;
        while (i < configuration.length) {
            BundleInfo bundleInfo = configuration[i];
            URI location = bundleInfo.getLocation();
            if (bundleInfo.getSymbolicName() == null || bundleInfo.getVersion() == null || location == null) {
                throw new IllegalArgumentException("Cannot persist bundleinfo: " + bundleInfo.toString());
            }
            if (installArea != null) {
                location = URIUtil.makeRelative((URI)location, (URI)installArea);
            }
            simpleInfos[i] = new org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo(bundleInfo.getSymbolicName(), bundleInfo.getVersion(), location, bundleInfo.getStartLevel(), bundleInfo.isMarkedAsStarted());
            simpleInfos[i].setBaseLocation(bundleInfo.getBaseLocation());
            ++i;
        }
        return simpleInfos;
    }

    public BundleInfo[] save(Manipulator manipulator, boolean backup) throws IOException {
        LinkedList<BundleInfo> setToInitialConfig = new LinkedList<BundleInfo>();
        LinkedList<BundleInfo> setToSimpleConfig = new LinkedList<BundleInfo>();
        ConfigData configData = manipulator.getConfigData();
        if (!this.divideBundleInfos(manipulator, setToInitialConfig, setToSimpleConfig, configData.getInitialBundleStartLevel())) {
            return configData.getBundles();
        }
        File outputFile = SimpleConfiguratorManipulatorImpl.getConfigFile(manipulator);
        URI installArea = ParserUtils.getOSGiInstallArea(Arrays.asList(manipulator.getLauncherData().getProgramArgs()), (Properties)manipulator.getConfigData().getProperties(), (LauncherData)manipulator.getLauncherData()).toURI();
        this.saveConfiguration(setToSimpleConfig.toArray(new BundleInfo[setToSimpleConfig.size()]), outputFile, installArea, backup);
        configData.setProperty(PROP_KEY_CONFIGURL, outputFile.toURL().toExternalForm());
        return this.orderingInitialConfig(setToInitialConfig);
    }

    void setPrerequisiteBundles(BundleInfo configuratorBundleInfo, BundlesState state, LocationInfo info) {
        if (state.isFullySupported() && !this.checkResolve(configuratorBundleInfo, state)) {
            this.printoutUnsatisfiedConstraints(configuratorBundleInfo, state);
            return;
        }
        BundleInfo[] prerequisites = state.getPrerequisteBundles(configuratorBundleInfo);
        info.prerequisiteLocations = new URI[prerequisites.length];
        int i = 0;
        while (i < prerequisites.length) {
            info.prerequisiteLocations[i] = prerequisites[i].getLocation();
            ++i;
        }
    }

    void setSystemBundles(BundlesState state, LocationInfo info) {
        BundleInfo systemBundleInfo = state.getSystemBundle();
        if (systemBundleInfo == null) {
            return;
        }
        if (state.isFullySupported() && !this.checkResolve(systemBundleInfo, state)) {
            this.printoutUnsatisfiedConstraints(systemBundleInfo, state);
            return;
        }
        info.systemBundleLocation = systemBundleInfo.getLocation();
        BundleInfo[] fragments = state.getSystemFragmentedBundles();
        info.systemFragmentedBundleLocations = new URI[fragments.length];
        int i = 0;
        while (i < fragments.length) {
            info.systemFragmentedBundleLocations[i] = fragments[i].getLocation();
            ++i;
        }
    }

    public void updateBundles(Manipulator manipulator) throws IOException {
        int n;
        int n2;
        BundleInfo[] bundleInfoArray;
        String[] jvmArgs;
        BundleInfo[] currentBInfos;
        BundlesState bundleState = manipulator.getBundlesState();
        if (bundleState == null) {
            return;
        }
        if (bundleState.isFullySupported()) {
            bundleState.resolve(true);
        }
        if (!SimpleConfiguratorManipulatorImpl.isTargetConfiguratorBundle(currentBInfos = bundleState.getExpectedState())) {
            return;
        }
        Properties properties = new Properties();
        String[] stringArray = jvmArgs = manipulator.getLauncherData().getJvmArgs();
        int n3 = jvmArgs.length;
        int n4 = 0;
        while (n4 < n3) {
            int index;
            String jvmArg = stringArray[n4];
            if (jvmArg.startsWith("-D") && (index = jvmArg.indexOf("=")) > 0 && jvmArg.length() > 2) {
                String key = jvmArg.substring(2, index);
                String value = jvmArg.substring(index + 1);
                properties.setProperty(key, value);
            }
            ++n4;
        }
        Utils.appendProperties((Properties)properties, (Properties)manipulator.getConfigData().getProperties());
        boolean exclusiveInstallation = Boolean.parseBoolean(properties.getProperty(PROP_KEY_EXCLUSIVE_INSTALLATION));
        File configFile = SimpleConfiguratorManipulatorImpl.getConfigFile(manipulator);
        File installArea = ParserUtils.getOSGiInstallArea(Arrays.asList(manipulator.getLauncherData().getProgramArgs()), (Properties)manipulator.getConfigData().getProperties(), (LauncherData)manipulator.getLauncherData());
        BundleInfo[] toInstall = new BundleInfo[]{};
        boolean isShared = this.isSharedInstallSetup(installArea, configFile);
        if (!isShared || isShared && !this.hasBaseChanged(installArea.toURI(), configFile.getParentFile())) {
            try {
                toInstall = this.loadConfiguration(new FileInputStream(configFile), installArea.toURI());
            }
            catch (FileNotFoundException fileNotFoundException) {
                toInstall = new BundleInfo[]{};
            }
        }
        LinkedList<BundleInfo> toUninstall = new LinkedList<BundleInfo>();
        if (exclusiveInstallation) {
            bundleInfoArray = currentBInfos;
            n2 = currentBInfos.length;
            n = 0;
            while (n < n2) {
                BundleInfo currentBInfo = bundleInfoArray[n];
                boolean install = false;
                BundleInfo[] bundleInfoArray2 = toInstall;
                int n5 = toInstall.length;
                int n6 = 0;
                while (n6 < n5) {
                    BundleInfo toInstall1 = bundleInfoArray2[n6];
                    if (currentBInfo.getLocation().equals(toInstall1.getLocation())) {
                        install = true;
                        break;
                    }
                    ++n6;
                }
                if (!install) {
                    toUninstall.add(currentBInfo);
                }
                ++n;
            }
        }
        bundleInfoArray = toInstall;
        n2 = toInstall.length;
        n = 0;
        while (n < n2) {
            BundleInfo toInstall1 = bundleInfoArray[n];
            try {
                bundleState.installBundle(toInstall1);
            }
            catch (RuntimeException runtimeException) {}
            ++n;
        }
        if (exclusiveInstallation) {
            for (BundleInfo bInfo : toUninstall) {
                bundleState.uninstallBundle(bInfo);
            }
        }
        bundleState.resolve(true);
        manipulator.getConfigData().setBundles(bundleState.getExpectedState());
    }

    public void cleanup(Manipulator manipulator) {
        File outputFile = SimpleConfiguratorManipulatorImpl.getConfigFile(manipulator);
        outputFile.delete();
        if (outputFile.getParentFile().isDirectory()) {
            outputFile.getParentFile().delete();
        }
    }

    private boolean hasBaseChanged(URI installArea, File outputFolder) {
        String extensionTimestsamp;
        String rememberedTimestamp;
        try {
            rememberedTimestamp = (String)this.loadProperties(new File(outputFolder, ".baseBundlesInfoTimestamp")).get("bundlesInfoTimestamp");
            extensionTimestsamp = (String)this.loadProperties(new File(outputFolder, ".baseBundlesInfoTimestamp")).get("extTimestamp");
        }
        catch (IOException iOException) {
            return false;
        }
        if (rememberedTimestamp == null) {
            return false;
        }
        File sharedBundlesInfo = new File(URIUtil.append((URI)installArea, (String)SHARED_BUNDLES_INFO));
        if (!sharedBundlesInfo.exists()) {
            return true;
        }
        return !String.valueOf(SimpleConfiguratorUtils.getFileLastModified((File)sharedBundlesInfo)).equals(rememberedTimestamp) || !String.valueOf(SimpleConfiguratorUtils.getExtendedTimeStamp()).equals(extensionTimestsamp);
    }

    private boolean isSharedInstallSetup(File installArea, File outputFile) {
        return !new File(installArea, SHARED_BUNDLES_INFO).equals(outputFile);
    }

    private Properties loadProperties(File inputFile) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(inputFile);
            props.load(is);
        }
        catch (Throwable throwable) {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException iOException) {}
            is = null;
            throw throwable;
        }
        try {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (IOException iOException) {}
        is = null;
        return props;
    }

    class LocationInfo {
        URI[] prerequisiteLocations = null;
        URI systemBundleLocation = null;
        URI[] systemFragmentedBundleLocations = null;

        LocationInfo() {
        }
    }
}

